/**
 * @type {Record<Internal.EntityType_<Internal.LivingEntity>, number[]>}
 * Numbers are as follow:
 * - Max Health
 * - Attack Damage
 * - Armor
 */
global.hpModifications = {
	'minecraft:allay': [30, 10, 0],
	'minecraft:armor_stand': [100, 15, 0],
	'minecraft:axolotl': [70, 10, 0],
	'minecraft:bat': [8, 15, 0],
	'minecraft:bee': [8, 10, 0],
	'minecraft:blaze': [70, 30, 0],
	'minecraft:camel': [160, 15, 0],
	'minecraft:cat': [50, 15, 0],
	'minecraft:cave_spider': [40, 10, 0],
	'minecraft:chicken': [8, 15, 0],
	'minecraft:cod': [8, 15, 0],
	'minecraft:cow': [50, 15, 0],
	'minecraft:creeper': [60, 10, 0],
	'minecraft:dolphin': [50, 11, 0],
	'minecraft:donkey': [220, 15, 0],
	'minecraft:drowned': [105, 16, 2],
	'minecraft:elder_guardian': [500, 30, 0],
	'minecraft:ender_dragon': [5000, 15, 20],
	'minecraft:enderman': [190, 23, 0],
	'minecraft:endermite': [25, 10, 0],
	'minecraft:evoker': [180, 10, 0],
	'minecraft:fox': [40, 10, 0],
	'minecraft:frog': [8, 50, 0],
	'minecraft:ghast': [70, 15, 0],
	'minecraft:giant': [300, 80, 0],
	'minecraft:glow_squid': [30, 15, 0],
	'minecraft:goat': [30, 10, 0],
	'minecraft:guardian': [[60, null, null, 100], [17, null, 19, 28], [3, null, null, 7]],
	'minecraft:hoglin': [140, 26, 0],
	'minecraft:horse': [265, 15, 0],
	'minecraft:husk': [100, 18, 2],
	'minecraft:illusioner': [170, 10, 0],
	'minecraft:iron_golem': [[750, null, null, 1250], [35, null, null, 64], [15, null, null, 30]],
	'minecraft:llama': [60, 10, 0],
	'minecraft:magma_cube': [15, 12, 3],
	'minecraft:mooshroom': [50, 15, 0],
	'minecraft:mule': [265, 15, 0],
	'minecraft:ocelot': [50, 15, 0],
	'minecraft:panda': [100, 30, 0],
	'minecraft:parrot': [30, 15, 0],
	'minecraft:phantom': [35, 10, 2],
	'minecraft:pig': [50, 15, 0],
	'minecraft:piglin': [90, 10, 0],
	'minecraft:piglin_brute': [210, 15, 0],
	'minecraft:pillager': [140, 10, 0],
	'minecraft:polar_bear': [150, 30, 0],
	'minecraft:pufferfish': [8, 15, 0],
	'minecraft:rabbit': [30, 15, 0],
	'minecraft:ravager': [300, 35, 0],
	'minecraft:salmon': [8, 15, 0],
	'minecraft:sheep': [40, 15, 0],
	'minecraft:shulker': [200, 15, 0],
	'minecraft:silverfish': [20, 5, 0],
	'minecraft:skeleton': [75, 10, 0],
	'minecraft:skeleton_horse': [100, 15, 0],
	'minecraft:slime': [10, 7, 0],
	'minecraft:sniffer': [200, 15, 0],
	'minecraft:snow_golem': [30, 10, 0],
	'minecraft:spider': [65, 10, 0],
	'minecraft:squid': [50, 15, 0],
	'minecraft:stray': [90, 10, 0],
	'minecraft:strider': [100, 15, 0],
	'minecraft:tadpole': [30, 15, 0],
	'minecraft:trader_llama': [265, 15, 0],
	'minecraft:tropical_fish': [8, 15, 0],
	'minecraft:turtle': [150, 15, 0],
	'minecraft:vex': [[25, null, 30, 40, null, 45], [12, null, null, 20, null, 27], [0, null, null, 2, 3, 4]],
	'minecraft:villager': [250, 6, [5, 10, 15, 20, 25, 30, 40]],
	'minecraft:vindicator': [160, 14, 0],
	'minecraft:wandering_trader': [250, 15, [10, 20, 30, 40, 50, 60]],
	'minecraft:warden': [1500, 1000, 0],
	'minecraft:witch': [110, 10, [0, null, 2, 4, null, 8]],
	'minecraft:wither': [1000, 10, 6],
	'minecraft:wither_skeleton': [120, 6, 6],
	'minecraft:wolf': [100, 16, 4],
	'minecraft:zoglin': [200, 30, 0],
	'minecraft:zombie': [90, 15, [1, 2, null, 3]],
	'minecraft:zombie_horse': [75, 15, 0],
	'minecraft:zombie_villager': [150, 10, 8],
	'minecraft:zombified_piglin': [110, 10, 4],
	'majruszsdifficulty:cerberus': [330, 25, 10],
	'majruszsdifficulty:creeperling': [30, 10, 0],
	'majruszsdifficulty:giant': [300, 40, 0],
	'majruszsdifficulty:illusioner': [160, 10, 0],
	'majruszsdifficulty:tank': [[270, null, 340, 400], 30, [0, null, 5, 15]],
	'botania:pixie': [10, 15, 0],
	'botania:doppleganger': [800, 15, 0],
	'botania:pink_wither': [1500, 10, 4],
	'the_bumblezone:variant_bee': [50, 10, 0],
	'the_bumblezone:honey_slime': [40, 5, 0],
	'the_bumblezone:beehemoth': [200, 20, 0],
	'the_bumblezone:bee_queen': [2500, 50, 0],
	'the_bumblezone:rootmin': [50, 15, 0],
	'the_bumblezone:cosmic_crystal_entity': [300, 5, 0],
	'mutantmonsters:creeper_minion': [20, 15, 0],
	'mutantmonsters:mutant_creeper': [370, 30, 6],
	'mutantmonsters:mutant_enderman': [550, 35, 6],
	'mutantmonsters:mutant_skeleton': [450, 25, 6],
	'mutantmonsters:mutant_snow_golem': [300, 25, 6],
	'mutantmonsters:mutant_zombie': [600, 40, 6],
	'mutantmonsters:spider_pig': [135, 12, 0],
	'mutantmonsters:endersoul_clone': [1, 1, 0],
	'phantasm:crystie': [60, 10, 0],
	'phantasm:behemoth': [300, 55, 0],
	'galosphere:sparkle': [50, 15, 0],
	'galosphere:spectre': [20, 10, 0],
	'galosphere:specterpillar': [10, 15, 0],
	'galosphere:spectator_vision': [5, 15, 0],
	'galosphere:berserker': [775, 50, 0],
	'galosphere:preserved': [100, 20, 2],
	'spelunkers_charm:tremor_handler': [500, 15, 0],
	'spelunkers_charm:sound_entity': [50, 15, 0],
	'born_in_chaos_v1:decrepit_skeleton': [60, 14, 0],
	'born_in_chaos_v1:skeleton_demoman': [110, 20, 2],
	'born_in_chaos_v1:decaying_zombie': [80, 12, 0],
	'born_in_chaos_v1:decaying_zombie_not_despawn': [80, 12, 0],
	'born_in_chaos_v1:baby_skeleton': [50, 8, 1],
	'born_in_chaos_v1:baby_skeleton_minion': [50, 8, 1],
	'born_in_chaos_v1:controlled_baby_skeleton': [85, 15, 1],
	'born_in_chaos_v1:barrel_zombie': [140, 11, 8],
	'born_in_chaos_v1:phantom_creeper': [60, 15, 0],
	'born_in_chaos_v1:phantom_creeper_copy': [60, 15, 0],
	'born_in_chaos_v1:door_knight': [120, 10, 7],
	'born_in_chaos_v1:door_knight_not_despawn': [10, 10, 7],
	'born_in_chaos_v1:restless_spirit': [70, 11, 0],
	'born_in_chaos_v1:skeleton_thrasher': [150, 25, 5],
	'born_in_chaos_v1:skeleton_thrasher_not_despawn': [150, 25, 5],
	'born_in_chaos_v1:pumpkin_spirit': [160, 30, 4],
	'born_in_chaos_v1:seared_spirit': [160, 33, 6],
	'born_in_chaos_v1:seared_spirit_not_despawn': [160, 33, 6],
	'born_in_chaos_v1:firelight': [60, 6, 0],
	'born_in_chaos_v1:firelight_not_despawn': [40, 6, 0],
	'born_in_chaos_v1:diamond_termite': [20, 5, 20],
	'born_in_chaos_v1:bonescaller': [175, 15, 1],
	'born_in_chaos_v1:bonescaller_not_despawn': [175, 15, 1],
	'born_in_chaos_v1:bone_imp': [70, 15, 3],
	'born_in_chaos_v1:bone_imp_minion': [70, 15, 3],
	'born_in_chaos_v1:supreme_bonescaller': [320, 25, 10],
	'born_in_chaos_v1:supreme_bonescaller_stage_10': [320, 25, 10],
	'born_in_chaos_v1:supreme_bonescaller_not_despawn': [320, 25, 10],
	'born_in_chaos_v1:dark_vortex': [80, 20, 5],
	'born_in_chaos_v1:dread_hound': [65, 18, 0],
	'born_in_chaos_v1:dread_hound_not_despawn': [65, 18, 0],
	'born_in_chaos_v1:fallen_chaos_knight': [120, 19, 12],
	'born_in_chaos_v1:scarlet_persecutor': [120, 18, 0],
	'born_in_chaos_v1:spirit_guide': [110, 15, 3],
	'born_in_chaos_v1:spirit_guide_assistant': [60, 10, 3],
	'born_in_chaos_v1:zombie_clown': [210, 15, 3],
	'born_in_chaos_v1:zombie_clown_not_despawn': [210, 15, 3],
	'born_in_chaos_v1:mr_pumpkin': [60, 15, 0],
	'born_in_chaos_v1:mr_pumpkin_controlled': [130, 15, 0],
	'born_in_chaos_v1:sir_pumpkinhead': [800, 30, 9],
	'born_in_chaos_v1:felsteed': [300, 15, 2],
	'born_in_chaos_v1:sir_pumpkinhead_without_horse': [600, 15, 4],
	'born_in_chaos_v1:sir_the_headless': [350, 20, 4],
	'born_in_chaos_v1:pumpkinhead': [325, 15, 4],
	'born_in_chaos_v1:riding_felsteed': [300, 15, 0],
	'born_in_chaos_v1:dire_hound_leader': [[220, null, null, 310, null, 440], [27, null, null, 37], [3, null, null, 9]],
	'born_in_chaos_v1:maggot': [5, 1, 0],
	'born_in_chaos_v1:corpse_fly': [40, 8, 0],
	'born_in_chaos_v1:bloody_gadfly': [55, 16, 1],
	'born_in_chaos_v1:corpse_fish': [30, 12, 0],
	'born_in_chaos_v1:zombie_fisherman': [125, 20, 4],
	'born_in_chaos_v1:swarmer': [160, 10, 8],
	'born_in_chaos_v1:thornshell_crab': [90, 20, 4],
	'born_in_chaos_v1:glutton_fish': [[150, null, null, 220], [20, null, null, 32], 3],
	'born_in_chaos_v1:zombie_bruiser': [130, 30, 2],
	'born_in_chaos_v1:pumpkin_bomb': [75, 5, 0],
	'born_in_chaos_v1:senor_pumpkin': [175, 25, 2],
	'born_in_chaos_v1:lord_pumpkinhead': [3330, 60, 6],
	'born_in_chaos_v1:lords_felsteed': [1300, 45, 6],
	'born_in_chaos_v1:lord_pumpkinhead_withouta_horse': [1800, 30, 2],
	'born_in_chaos_v1:lord_the_headless': [1500, 60, 2],
	'born_in_chaos_v1:lord_pumpkinhead_head': [1000, 30, 9],
	'born_in_chaos_v1:infernal_spirit': [450, 80, 2],
	'born_in_chaos_v1:riding_lords_felsteed': [450, 45, 2],
	'born_in_chaos_v1:zombie_lumberjack': [110, 20, 4],
	'born_in_chaos_v1:siamese_skeletons': [60, 16, 0],
	'born_in_chaos_v1:siamese_skeletonsleft': [40, 8, 0],
	'born_in_chaos_v1:siamese_skeletonsright': [40, 8, 0],
	'born_in_chaos_v1:phantom_bomb_entity': [75, 5, 0],
	'born_in_chaos_v1:controlled_spiritual_assistant': [110, 20, 3],
	'born_in_chaos_v1:spiritof_chaos': [40, 12, 0],
	'born_in_chaos_v1:lifestealer': [350, 40, 10],
	'born_in_chaos_v1:lifestealer_true_form': [350, 40, 7],
	'born_in_chaos_v1:baby_spider': [50, 11, 0],
	'born_in_chaos_v1:mother_spider': [[300, null, null, 420, null, 550], 27, [10, null, null, 20, 25, 30]],
	'born_in_chaos_v1:baby_spider_controlled': [30, 9, 0],
	'born_in_chaos_v1:nightmare_stalker': [[220, null, null, 360, null, 500], [21, null, null, 30, null, 45], [15, null, null, 25, null, 30]],
	'born_in_chaos_v1:pumpkin_dunce': [100, 15, 0],
	'born_in_chaos_v1:mrs_pumpkin': [150, 15, 1],
	'born_in_chaos_v1:pumpkin_bruiser': [450, 45, 6],
	'born_in_chaos_v1:krampus': [900, 35, 8],
	'born_in_chaos_v1:krampus_henchman': [130, 177, 5],
	'born_in_chaos_v1:missioner': [500, 40, 5],
	'born_in_chaos_v1:missionary_raider': [500, 40, 5],
	'cataclysm:ender_golem': [3000, 40, 10],
	'cataclysm:ender_guardian': [3500, 50, 10],
	'cataclysm:old_netherite_monstrosity': [2500, 105, 0],
	'cataclysm:netherite_monstrosity': [2200, 80, 10],
	'cataclysm:netherite_ministrosity': [600, 15, 5],
	'cataclysm:nameless_sorcerer': [250, 10, 0],
	'cataclysm:ignis': [2250, 70, 0],
	'cataclysm:endermaptera': [80, 20, 6],
	'cataclysm:deepling': [130, 20, 0],
	'cataclysm:deepling_brute': [300, 25, 8],
	'cataclysm:deepling_angler': [150, 20, 0],
	'cataclysm:deepling_priest': [225, 20, 0],
	'cataclysm:deepling_warlock': [225, 20, 0],
	'cataclysm:lionfish': [60, 10, 0],
	'cataclysm:coral_golem': [550, 55, 5],
	'cataclysm:coralssus': [800, 50, 5],
	'cataclysm:ignited_revenant': [400, 30, 2],
	'cataclysm:ignited_berserker': [325, 35, 8],
	'cataclysm:the_harbinger': [1950, 45, 2],
	'cataclysm:the_watcher': [125, 25, 5],
	'cataclysm:the_prowler': [800, 70, 0],
	'cataclysm:the_leviathan': [2000, 55, 0],
	'cataclysm:the_baby_leviathan': [600, 20, 5],
	'cataclysm:amethyst_crab': [1000, 65, 0],
	'cataclysm:ancient_ancient_remnant': [2000, 125, 0],
	'cataclysm:ancient_remnant': [2250, 125, 2],
	'cataclysm:modern_remnant': [750, 30, 5],
	'cataclysm:koboleton': [125, 15, 0],
	'cataclysm:kobolediator': [900, 70, 0],
	'cataclysm:wadjet': [750, 55, 5],
	'cataclysm:maledictus': [2100, 65, 0],
	'cataclysm:draugr': [140, 20, 3],
	'cataclysm:royal_draugr': [150, 25, 5],
	'cataclysm:elite_draugr': [160, 25, 3],
	'cataclysm:aptrgangr': [800, 90, 0],
	'cataclysm:hippocamtus': [425, 50, 5],
	'cataclysm:cindaria': [300, 35, 0],
	'cataclysm:clawdian': [1125, 80, 2],
	'cataclysm:scylla': [1950, 90, 2],
	'cataclysm:urchinkin': [60, 15, 0],
	'cataclysm:drowned_host': [100, 15, 2],
	'cataclysm:symbiocto': [80, 15, 0],
	'tide:tuna': [8, 15, 0],
	'tide:ocean_perch': [8, 15, 0],
	'tide:bluegill': [8, 15, 0],
	'tide:pike': [8, 15, 0],
	'tide:trout': [8, 15, 0],
	'tide:barracuda': [8, 15, 0],
	'tide:guppy': [8, 15, 0],
	'tide:clayfish': [8, 15, 0],
	'tide:catfish': [8, 15, 0],
	'tide:mackerel': [8, 15, 0],
	'tide:bass': [8, 15, 0],
	'tide:angelfish': [8, 15, 0],
	'tide:sailfish': [8, 15, 0],
	'tide:yellow_perch': [8, 15, 0],
	'tide:mint_carp': [8, 15, 0],
	'artifacts:mimic': [150, 18, 0],
	'netherexp:apparition': [120, 20, 0],
	'netherexp:wisp': [10, 15, 0],
	'netherexp:vessel': [120, 10, 0],
	'netherexp:ecto_slab': [5, 5, 3],
	'netherexp:banshee': [100, 30, 0],
	'netherexp:stampede': [400, 40, 0],
	'netherexp:carcass': [150, 25, 0],
	'netherexp:false_carcass': [100, 25, 0],
	'unusualend:ender_blob': [120, 20, 0],
	'unusualend:undead_enderling': [150, 20, 0],
	'unusualend:endstone_trapper': [500, 20, 3],
	'unusualend:ender_firefly': [200, 0, 0],
	'unusualend:endstone_golem': [2500, 40, 0],
	'unusualend:dragling': [75, 15, 0],
	'unusualend:bolok': [30, 5, 0],
	'unusualend:enderblob_queen': [2500, 50, 0],
	'unusualend:block_updater': [50, 15, 0],
	'unusualend:spunkler': [150, 0, 0],
	'unusualend:void_crack': [50, 0, 0],
	'unusualend:warped_balloon': [50, 0, 0],
	'unusualend:glub': [100, 5, 8],
	'unusualend:void_bomb': [400, 5, 0],
	'unusualend:enderbulb': [240, 20, 4],
	'unusualend:small_enderbulb': [60, 15, 0],
	'unusualend:bluk': [20, 5, 0],
	'unusualend:summoned_dragling': [100, 15, 1],
	'moresnifferflowers:bobling': [50, 15, 0],
	'ecologics:coconut_crab': [100, 10, 0],
	'ecologics:penguin': [75, 10, 0],
	'ecologics:squirrel': [50, 15, 0],
	'aquamirae:golden_moth': [8, 15, 0],
	'aquamirae:maw': [160, 20, 4],
	'aquamirae:anglerfish': [200, 17, 8],
	'aquamirae:maze_mother': [750, 40, 20],
	'aquamirae:captain_cornelia': [1000, 10, 20],
	'aquamirae:pillagers_patrol': [100, 15, 0],
	'aquamirae:tortured_soul': [150, 23, 4],
	'aquamirae:eel': [700, 40, 10],
	'aquamirae:maze_rose': [100, 15, 0],
	'aquamirae:poisoned_chakra': [100, 15, 0],
	'aquamirae:spinefish': [100, 15, 0],
	'aquamirae:luminous_jelly': [100, 15, 0],
	'ars_nouveau:ally_vex': [70, 20, 0],
	'ars_nouveau:bookwyrm': [30, 15, 0],
	'ars_nouveau:starbuncle': [100, 15, 0],
	'ars_nouveau:whirlisprig': [100, 15, 0],
	'ars_nouveau:wixie': [100, 15, 0],
	'ars_nouveau:wilden_hunter': [100, 20, 2],
	'ars_nouveau:summon_wolf': [40, 20, 0],
	'ars_nouveau:wilden_stalker': [75, 10, 0],
	'ars_nouveau:summon_horse': [265, 15, 0],
	'ars_nouveau:summon_skeleton': [100, 10, 0],
	'ars_nouveau:wilden_guardian': [125, 20, 2],
	'ars_nouveau:wilden_boss': [3200, 40, 15],
	'ars_nouveau:dummy': [0, 0, 0],
	'ars_nouveau:drygmy': [100, 15, 0],
	'ars_nouveau:familiar_starbuncle': [0, 0, 0],
	'ars_nouveau:familiar_wixie': [0, 0, 0],
	'ars_nouveau:familiar_bookwyrm': [0, 0, 0],
	'ars_nouveau:familiar_drygmy': [0, 0, 0],
	'ars_nouveau:familiar_whirlisprig': [0, 0, 0],
	'ars_nouveau:familiar_amethyst_golem': [0, 0, 0],
	'ars_nouveau:cascading_weald_walker': [300, 50, 0],
	'ars_nouveau:flourishing_weald_walker': [300, 50, 0],
	'ars_nouveau:blazing_weald_walker': [300, 50, 0],
	'ars_nouveau:vexing_weald_walker': [300, 50, 0],
	'ars_nouveau:amethyst_golem': [100, 15, 0],
	'ars_nouveau:gift_starby': [30, 15, 0],
	'ars_nouveau:animated_block': [20, 10, 0],
	'ars_nouveau:animated_head': [20, 10, 0],
	'ars_nouveau:lily': [200, 10, 0],
	'ars_elemental:siren_entity': [50, 15, 0],
	'ars_elemental:siren_familiar': [0, 0, 0],
	'ars_elemental:firenando_entity': [200, 15, 0],
	'ars_elemental:firenando_familiar': [0, 0, 0],
	'ars_elemental:fire_mage': [250, 5, 0],
	'ars_elemental:water_mage': [250, 5, 0],
	'ars_elemental:air_mage': [250, 5, 0],
	'ars_elemental:earth_mage': [250, 5, 0],
	'ars_elemental:flashing_weald_walker': [300, 50, 0],
	'ars_elemental:summon_skelehorse': [265, 15, 0],
	'ars_elemental:summon_camel': [265, 15, 0],
	'ars_elemental:summon_direwolf': [40, 20, 0],
	'ars_elemental:summon_wskeleton': [100, 10, 0],
	'ars_elemental:summon_dolphin': [50, 15, 0],
	'ars_elemental:summon_strider': [100, 15, 0],
	'ars_elemental:summon_vhex': [100, 40, 0],
	'crittersandcompanions:dragonfly': [20, 10, 0],
	'crittersandcompanions:dumbo_octopus': [70, 15, 0],
	'crittersandcompanions:ferret': [80, 15, 0],
	'crittersandcompanions:jumping_spider': [70, 40, 0],
	'crittersandcompanions:koi_fish': [40, 15, 0],
	'crittersandcompanions:leaf_insect': [30, 15, 0],
	'crittersandcompanions:otter': [80, 15, 0],
	'crittersandcompanions:red_panda': [90, 15, 0],
	'crittersandcompanions:sea_bunny': [40, 15, 0],
	'crittersandcompanions:shima_enaga': [50, 15, 0],
	'aether:phyg': [50, 15, 0],
	'aether:flying_cow': [50, 15, 0],
	'aether:sheepuff': [40, 15, 0],
	'aether:moa': [175, 25, 0],
	'aether:aerbunny': [30, 15, 0],
	'aether:aerwhale': [100, 15, 0],
	'aether:blue_swet': [5, 0, 0],
	'aether:golden_swet': [5, 0, 0],
	'aether:whirlwind': [50, 15, 0],
	'aether:evil_whirlwind': [50, 15, 0],
	'aether:aechor_plant': [75, 15, 0],
	'aether:cockatrice': [100, 15, 0],
	'aether:zephyr': [25, 15, 0],
	'aether:mimic': [200, 15, 0],
	'aether:sentry': [50, 10, 0],
	'aether:slider': [900, 15, 10],
	'aether:valkyrie': [220, 50, 0],
	'aether:valkyrie_queen': [2000, 65, 0],
	'aether:fire_minion': [200, 75, 0],
	'aether:sun_spirit': [2500, 15, 0],
	'aether:cloud_minion': [5, 15, 0],
	'lost_aether_content:aerwhale_king': [1500, 50, 15],
	'aether_redux:vanilla_swet': [5, 0, 0],
	'aether_redux:shimmercow': [125, 15, 0],
	'aether_redux:mykapod': [30, 15, 0],
	'aether_redux:blightbunny': [50, 15, 0],
	'aether_redux:cockatrice_spawner': [100, 15, 0],
	'aether_redux:blightbunny_spawner': [100, 15, 0],
	'naturalist:alligator': [150, 30, 0],
	'naturalist:bass': [8, 15, 0],
	'naturalist:bear': [150, 30, 0],
	'naturalist:bluejay': [30, 15, 0],
	'naturalist:boar': [70, 5, 0],
	'naturalist:butterfly': [50, 15, 0],
	'naturalist:canary': [30, 15, 0],
	'naturalist:cardinal': [30, 15, 0],
	'naturalist:caterpillar': [25, 15, 0],
	'naturalist:catfish': [30, 5, 0],
	'naturalist:coral_snake': [50, 30, 0],
	'naturalist:deer': [40, 15, 0],
	'naturalist:dragonfly': [30, 15, 0],
	'naturalist:duck': [20, 15, 0],
	'naturalist:elephant': [400, 50, 0],
	'naturalist:firefly': [30, 15, 0],
	'naturalist:finch': [30, 15, 0],
	'naturalist:giraffe': [175, 15, 0],
	'naturalist:hippo': [200, 30, 0],
	'naturalist:lion': [120, 30, 0],
	'naturalist:lizard': [40, 10, 0],
	'naturalist:lizard_tail': [30, 15, 0],
	'naturalist:moose': [200, 30, 0],
	'naturalist:rattlesnake': [50, 30, 0],
	'naturalist:rhino': [200, 30, 0],
	'naturalist:robin': [30, 15, 0],
	'naturalist:snail': [10, 15, 0],
	'naturalist:snake': [50, 30, 0],
	'naturalist:sparrow': [30, 15, 0],
	'naturalist:tortoise': [100, 10, 0],
	'naturalist:vulture': [50, 20, 0],
	'naturalist:zebra': [265, 15, 0],
	'dummmmmmy:target_dummy': [1500, 0, 0],
	'witherstormmod:wither_storm': [10000, 15, 80],
	'witherstormmod:wither_storm_segment': [1000000, 10, 400],
	'witherstormmod:sickened_zombie': [600, 45, 15],
	'witherstormmod:sickened_skeleton': [500, 30, 10],
	'witherstormmod:sickened_spider': [400, 36, 10],
	'witherstormmod:sickened_creeper': [450, 10, 6],
	'witherstormmod:command_block': [999999, 999, 9999],
	'witherstormmod:withered_symbiont': [800, 50, 30],
	'witherstormmod:wither_storm_head': [250, 80, 30],
	'witherstormmod:tentacle': [400, 40, 40],
	'witherstormmod:sickened_villager': [600, 19, 8],
	'witherstormmod:sickened_phantom': [400, 32, 0],
	'witherstormmod:sickened_chicken': [350, 26, 4],
	'witherstormmod:sickened_parrot': [350, 15, 4],
	'witherstormmod:sickened_wolf': [500, 36, 4],
	'witherstormmod:sickened_cat': [400, 35, 4],
	'witherstormmod:sickened_cow': [500, 32, 4],
	'witherstormmod:sickened_pig': [450, 32, 4],
	'witherstormmod:sickened_mushroom_cow': [600, 40, 10],
	'witherstormmod:sickened_bee': [150, 25, 0],
	'witherstormmod:sickened_pillager': [700, 29, 6],
	'witherstormmod:sickened_vindicator': [800, 36, 10],
	'witherstormmod:sickened_iron_golem': [1000, 70, 20],
	'witherstormmod:sickened_snow_golem': [590, 10, 0],
	'witherstormmod:tainted_slime': [22, 0, 0],
	'create:package': [25, 15, 0],
	'netherdepthsupgrade:lava_pufferfish': [8, 15, 0],
	'netherdepthsupgrade:obsidianfish': [8, 15, 5],
	'netherdepthsupgrade:searing_cod': [8, 15, 0],
	'netherdepthsupgrade:bonefish': [8, 15, 0],
	'netherdepthsupgrade:wither_bonefish': [8, 15, 0],
	'netherdepthsupgrade:blazefish': [8, 15, 0],
	'netherdepthsupgrade:magmacubefish': [8, 15, 0],
	'netherdepthsupgrade:glowdine': [8, 15, 0],
	'netherdepthsupgrade:soulsucker': [8, 15, 0],
	'netherdepthsupgrade:fortressgrouper': [100, 50, 0],
	'netherdepthsupgrade:eyeball_fish': [40, 15, 0],
	'upgrade_aquatic:nautilus': [8, 15, 10],
	'upgrade_aquatic:pike': [8, 15, 0],
	'upgrade_aquatic:perch': [8, 15, 0],
	'upgrade_aquatic:lionfish': [8, 15, 0],
	'upgrade_aquatic:thrasher': [40, 15, 8],
	'upgrade_aquatic:great_thrasher': [150, 25, 6],
	'upgrade_aquatic:flare': [100, 10, 0],
	'upgrade_aquatic:goose': [30, 15, 0],
	'upgrade_aquatic:box_jellyfish': [0, 25, 0],
	'upgrade_aquatic:cassiopea_jellyfish': [0, 5, 0],
	'upgrade_aquatic:immortal_jellyfish': [35, 5, 0],
	// 'buzzier_bees:grizzly_bear': [150, 19, 0],
	// 'buzzier_bees:moobloom': [50, 15, 0],
	'alexscaves:teletor': [90, 10, 0],
	'alexscaves:magnetron': [150, 10, 6],
	'alexscaves:boundroid': [100, 25, 0],
	'alexscaves:boundroid_winch': [100, 25, 0],
	'alexscaves:ferrouslime': [50, 10, 0],
	'alexscaves:notor': [30, 10, 0],
	'alexscaves:subterranodon': [100, 10, 0],
	'alexscaves:vallumraptor': [140, 15, 0],
	'alexscaves:grottoceratops': [250, 50, 8],
	'alexscaves:trilocaris': [50, 5, 0],
	'alexscaves:tremorsaurus': [750, 70, 8],
	'alexscaves:relicheirus': [600, 60, 0],
	'alexscaves:luxtructosaurus': [3000, 60, 0],
	'alexscaves:atlatitan': [2000, 40, 0],
	'alexscaves:nucleeper': [200, 10, 4],
	'alexscaves:radgill': [40, 10, 0],
	'alexscaves:brainiac': [200, 25, 8],
	'alexscaves:gammaroach': [70, 10, 0],
	'alexscaves:raycat': [120, 5, 0],
	'alexscaves:tremorzilla': [2500, 150, 0],
	'alexscaves:lanternfish': [10, 10, 0],
	'alexscaves:sea_pig': [40, 10, 0],
	'alexscaves:hullbreaker': [2000, 80, 0],
	'alexscaves:gossamer_worm': [50, 10, 0],
	'alexscaves:tripodfish': [40, 10, 0],
	'alexscaves:deep_one': [150, 15, 0],
	'alexscaves:deep_one_knight': [300, 25, 0],
	'alexscaves:deep_one_mage': [400, 20, 0],
	'alexscaves:mine_guardian': [100, 5, 0],
	'alexscaves:gloomoth': [20, 10, 0],
	'alexscaves:underzealot': [100, 20, 0],
	'alexscaves:watcher': [150, 20, 0],
	'alexscaves:corrodent': [80, 15, 2],
	'alexscaves:vesper': [80, 15, 0],
	'alexscaves:forsaken': [1250, 50, 0],
	'alexscaves:sweetish_fish': [20, 10, 0],
	'alexscaves:caniac': [190, 10, 0],
	'alexscaves:gumbeeper': [70, 20, 4],
	'alexscaves:candicorn': [150, 30, 0],
	'alexscaves:gum_worm': [750, 45, 0],
	'alexscaves:caramel_cube': [20, 10, 0],
	'alexscaves:gummy_bear': [180, 20, 0],
	'alexscaves:licowitch': [200, 15, 0],
	'alexscaves:gingerbread_man': [50, 10, 0],
	'quark:crab': [100, 15, 3],
	'quark:forgotten': [140, 10, 0],
	'quark:foxhound': [150, 20, 0],
	'quark:shiba': [80, 20, 0],
	'quark:stoneling': [40, 15, 0],
	'quark:toretoise': [400, 15, 0],
	'quark:wraith': [170, 15, 0],
	'supplementaries:hat_stand': [100, 15, 0],
	'supplementaries:red_merchant': [200, 15, 0],
	'rediscovered:fish': [8, 15, 0],
	'rediscovered:pigman': [100, 15, 0],
	'rediscovered:melee_pigman': [200, 10, 5],
	'rediscovered:ranged_pigman': [100, 10, 3],
	'rediscovered:zombie_pigman': [100, 21, 2],
	'rediscovered:steve': [250, 10, 5],
	'rediscovered:rana': [250, 10, 5],
	'rediscovered:black_steve': [250, 10, 5],
	'rediscovered:beast_boy': [250, 10, 0],
	'rediscovered:red_dragon': [2400, 60, 20],
	'rediscovered:red_dragon_offspring': [2400, 60, 20],
	'rediscovered:dragon_pylon': [150, 15, 0],
	'rediscovered:scarecrow': [50, 15, 0],
	'alexsmobs:grizzly_bear': [275, 40, 0],
	'alexsmobs:roadrunner': [40, 5, 0],
	'alexsmobs:bone_serpent': [125, 25, 0],
	'alexsmobs:bone_serpent_part': [50, 10, 0],
	'alexsmobs:gazelle': [40, 10, 0],
	'alexsmobs:crocodile': [150, 50, 8],
	'alexsmobs:fly': [10, 5, 0],
	'alexsmobs:hummingbird': [20, 0, 0],
	'alexsmobs:orca': [300, 50, 0],
	'alexsmobs:sunbird': [100, 10, 0],
	'alexsmobs:gorilla': [150, 35, 0],
	'alexsmobs:crimson_mosquito': [50, 25, 0],
	'alexsmobs:rattlesnake': [40, 10, 0],
	'alexsmobs:endergrade': [100, 10, 0],
	'alexsmobs:hammerhead_shark': [150, 25, 0],
	'alexsmobs:lobster': [25, 10, 2],
	'alexsmobs:komodo_dragon': [150, 20, 0],
	'alexsmobs:capuchin_monkey': [50, 10, 0],
	'alexsmobs:centipede_head': [175, 40, 6],
	'alexsmobs:centipede_body': [50, 40, 6],
	'alexsmobs:centipede_tail': [50, 40, 6],
	'alexsmobs:warped_toad': [150, 10, 0],
	'alexsmobs:moose': [275, 35, 0],
	'alexsmobs:mimicube': [150, 10, 0],
	'alexsmobs:raccoon': [45, 10, 0],
	'alexsmobs:blobfish': [40, 10, 0],
	'alexsmobs:seal': [50, 10, 0],
	'alexsmobs:cockroach': [30, 10, 0],
	'alexsmobs:shoebill': [50, 20, 0],
	'alexsmobs:elephant': [425, 50, 0],
	'alexsmobs:soul_vulture': [60, 20, 0],
	'alexsmobs:snow_leopard': [150, 30, 0],
	'alexsmobs:spectre': [250, 10, 0],
	'alexsmobs:crow': [40, 5, 0],
	'alexsmobs:alligator_snapping_turtle': [90, 20, 8],
	'alexsmobs:mungus': [75, 10, 0],
	'alexsmobs:mantis_shrimp': [100, 15, 8],
	'alexsmobs:guster': [80, 5, 0],
	'alexsmobs:warped_mosco': [500, 50, 10],
	'alexsmobs:straddler': [140, 10, 5],
	'alexsmobs:stradpole': [20, 10, 0],
	'alexsmobs:emu': [100, 15, 0],
	'alexsmobs:platypus': [50, 10, 0],
	'alexsmobs:dropbear': [110, 10, 0],
	'alexsmobs:tasmanian_devil': [70, 10, 0],
	'alexsmobs:kangaroo': [110, 20, 0],
	'alexsmobs:cachalot_whale': [800, 150, 0],
	'alexsmobs:leafcutter_ant': [30, 10, 0],
	'alexsmobs:enderiophage': [100, 10, 0],
	'alexsmobs:bald_eagle': [80, 25, 0],
	'alexsmobs:tiger': [250, 60, 0],
	'alexsmobs:tarantula_hawk': [90, 25, 4],
	'alexsmobs:void_worm': [800, 25, 4],
	'alexsmobs:void_worm_part': [150, 10, 0],
	'alexsmobs:frilled_shark': [100, 15, 0],
	'alexsmobs:mimic_octopus': [80, 10, 0],
	'alexsmobs:seagull': [40, 5, 0],
	'alexsmobs:froststalker': [120, 20, 2],
	'alexsmobs:tusklin': [200, 45, 0],
	'alexsmobs:laviathan': [300, 5, 10],
	'alexsmobs:cosmaw': [100, 5, 0],
	'alexsmobs:toucan': [8, 10, 0],
	'alexsmobs:maned_wolf': [80, 10, 0],
	'alexsmobs:anaconda': [100, 10, 0],
	'alexsmobs:anaconda_part': [50, 10, 0],
	'alexsmobs:anteater': [100, 30, 0],
	'alexsmobs:rocky_roller': [50, 10, 20],
	'alexsmobs:flutter': [40, 5, 0],
	'alexsmobs:gelada_monkey': [90, 20, 0],
	'alexsmobs:jerboa': [20, 10, 0],
	'alexsmobs:terrapin': [50, 10, 10],
	'alexsmobs:comb_jelly': [30, 10, 0],
	'alexsmobs:cosmic_cod': [20, 10, 0],
	'alexsmobs:bunfungus': [400, 35, 0],
	'alexsmobs:bison': [200, 35, 0],
	'alexsmobs:giant_squid': [190, 40, 0],
	'alexsmobs:sea_bear': [600, 30, 0],
	'alexsmobs:devils_hole_pupfish': [10, 10, 0],
	'alexsmobs:catfish': [8, 10, 0],
	'alexsmobs:flying_fish': [8, 10, 0],
	'alexsmobs:skelewag': [100, 15, 0],
	'alexsmobs:rain_frog': [30, 10, 0],
	'alexsmobs:potoo': [40, 5, 0],
	'alexsmobs:mudskipper': [8, 10, 0],
	'alexsmobs:rhinoceros': [200, 25, 12],
	'alexsmobs:sugar_glider': [40, 10, 0],
	'alexsmobs:farseer': [350, 20, 6],
	'alexsmobs:skreecher': [10, 5, 0],
	'alexsmobs:underminer': [100, 15, 0],
	'alexsmobs:murmur': [150, 15, 0],
	'alexsmobs:murmur_head': [150, 15, 0],
	'alexsmobs:skunk': [40, 5, 0],
	'alexsmobs:banana_slug': [20, 5, 0],
	'alexsmobs:blue_jay': [8, 5, 0],
	'alexsmobs:caiman': [100, 15, 8],
	'alexsmobs:triops': [20, 10, 0]
}

global.autoscaleMobs = [
	'minecraft:zombie',
	'minecraft:vindicator',
	'minecraft:evoker',
	'minecraft:illusioner',
	'minecraft:pillager',
	'minecraft:husk',
	'minecraft:skeleton',
	'minecraft:wither_skeleton',
	'minecraft:stray',
	'minecraft:creeper',
	'minecraft:spider',
	'minecraft:cave_spider',
	'minecraft:zombified_piglin',
	'minecraft:piglin',
	'minecraft:phantom',
	'minecraft:silverfish',
	'minecraft:endermite',
	'minecraft:enderman',
	'minecraft:witch',
	'minecraft:ravager',
	'minecraft:drowned',
	'born_in_chaos_v1:decrepit_skeleton',
	'born_in_chaos_v1:skeleton_demoman',
	'born_in_chaos_v1:decaying_zombie',
	'born_in_chaos_v1:decaying_zombie_not_despawn',
	'born_in_chaos_v1:baby_skeleton',
	'born_in_chaos_v1:baby_skeleton_minion',
	'born_in_chaos_v1:controlled_baby_skeleton',
	'born_in_chaos_v1:barrel_zombie',
	'born_in_chaos_v1:phantom_creeper',
	'born_in_chaos_v1:phantom_creeper_copy',
	'born_in_chaos_v1:door_knight',
	'born_in_chaos_v1:door_knight_not_despawn',
	'born_in_chaos_v1:restless_spirit',
	'born_in_chaos_v1:skeleton_thrasher',
	'born_in_chaos_v1:skeleton_thrasher_not_despawn',
	'born_in_chaos_v1:firelight',
	'born_in_chaos_v1:firelight_not_despawn',
	'born_in_chaos_v1:diamond_termite',
	'born_in_chaos_v1:bonescaller',
	'born_in_chaos_v1:bonescaller_not_despawn',
	'born_in_chaos_v1:bone_imp',
	'born_in_chaos_v1:bone_imp_minion',
	'born_in_chaos_v1:dark_vortex',
	'born_in_chaos_v1:dread_hound',
	'born_in_chaos_v1:dread_hound_not_despawn',
	'born_in_chaos_v1:fallen_chaos_knight',
	'born_in_chaos_v1:spirit_guide',
	'born_in_chaos_v1:spirit_guide_assistant',
	'born_in_chaos_v1:zombie_clown',
	'born_in_chaos_v1:zombie_clown_not_despawn',
	'born_in_chaos_v1:corpse_fly',
	'born_in_chaos_v1:bloody_gadfly',
	'born_in_chaos_v1:corpse_fish',
	'born_in_chaos_v1:zombie_fisherman',
	'born_in_chaos_v1:swarmer',
	'born_in_chaos_v1:thornshell_crab',
	'born_in_chaos_v1:glutton_fish',
	'born_in_chaos_v1:zombie_bruiser',
	'born_in_chaos_v1:zombie_lumberjack',
	'born_in_chaos_v1:siamese_skeletons',
	'born_in_chaos_v1:siamese_skeletonsleft',
	'born_in_chaos_v1:siamese_skeletonsright',
	'born_in_chaos_v1:controlled_spiritual_assistant',
	'born_in_chaos_v1:spiritof_chaos',
	'born_in_chaos_v1:baby_spider',
	'born_in_chaos_v1:baby_spider_controlled',
	'netherexp:apparition',
	'netherexp:vessel',
	'minecraft:slime',
	'minecraft:magma_cube'
]

global.scaleThroughChapters = [
	'minecraft:wandering_trader',
	'minecraft:villager',
	'minecraft:wolf',
	'minecraft:iron_golem',
	'minecraft:snow_golem'
]
