/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.villagercomfort.core.mixin;

import dev.ghen.villagercomfort.comfort.BedroomComfortValues;
import dev.ghen.villagercomfort.comfort.ComfortHelper;
import dev.ghen.villagercomfort.comfort.WorkplaceComfortValues;
import dev.ghen.villagercomfort.common.capabilty.ModCapabilities;
import dev.ghen.villagercomfort.core.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.LightLayer;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public class VillagerMixin {
    @Shadow
    @Final
    private static Logger f_201976_;

    @Inject(method={"startSleeping"}, at={@At(value="HEAD")})
    private void scanBedroomComfortValues(BlockPos pos, CallbackInfo ci) {
        Villager villager = (Villager)this;
        villager.getCapability(ModCapabilities.COMFORT_VALUES_CAP).ifPresent(cap -> {
            int current_day = (int)(villager.m_9236_().m_46468_() / 24000L);
            BedroomComfortValues.setValuesToCap(villager, pos, cap);
            cap.setLastSleepDay(current_day);
        });
    }

    @Inject(method={"playWorkSound"}, at={@At(value="HEAD")})
    private void scanWorkstationComfortValues(CallbackInfo ci) {
        Villager villager = (Villager)this;
        villager.getCapability(ModCapabilities.COMFORT_VALUES_CAP).ifPresent(cap -> WorkplaceComfortValues.setValuesToCap(villager, cap));
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void checkSunlightTick(CallbackInfo ci) {
        Villager villager = (Villager)this;
        if (!villager.m_9236_().m_5776_() && villager.f_19797_ % 100 == 0) {
            villager.getCapability(ModCapabilities.COMFORT_VALUES_CAP).ifPresent(cap -> {
                int current_day = (int)(villager.m_9236_().m_46468_() / 24000L);
                if (cap.current_day_for_measuring_outside_ticks != current_day) {
                    cap.today_outside_ticks = 0;
                    cap.current_day_for_measuring_outside_ticks = current_day;
                }
                if (villager.m_9236_().m_45517_(LightLayer.SKY, villager.m_20183_()) > 12) {
                    cap.today_outside_ticks += 100;
                    if (cap.today_outside_ticks >= ((Number)CommonConfig.MINIMUM_TICKS_OUTSIDE.get()).intValue()) {
                        cap.last_day_outside = current_day;
                    }
                }
                if (villager.m_6274_().m_21954_(Activity.f_37984_)) {
                    cap.setLastZombieDay(current_day);
                }
            });
        }
    }

    @Inject(method={"updateSpecialPrices"}, at={@At(value="TAIL")})
    private void setComfortModifiers(Player player, CallbackInfo ci) {
        Villager villager = (Villager)this;
        villager.getCapability(ModCapabilities.COMFORT_VALUES_CAP).ifPresent(cap -> {
            for (MerchantOffer merchantOffer : villager.m_6616_()) {
                merchantOffer.m_45353_(ComfortHelper.calculatePriceModifier(villager, cap, merchantOffer.m_45352_().m_41613_()));
            }
        });
    }
}

