/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.villagercomfort.core.math;

public class MathHelper {
    public static int scale(int value, int prevScale, int newScale) {
        return (int)((float)value / (float)prevScale * (float)newScale);
    }

    public static int interpolate(int point, int minPoint, int maxPoint, int minValue, int maxValue) {
        int avgValue = (minValue + maxValue) / 2;
        if (maxPoint < minPoint) {
            int swap = minPoint;
            minPoint = maxPoint;
            maxPoint = swap;
            swap = minValue;
            minValue = maxValue;
            maxValue = swap;
        }
        if (point >= maxPoint) {
            return maxValue;
        }
        if (point <= minPoint) {
            return minValue;
        }
        int pointDistance = maxPoint - minPoint;
        int valueDistance = maxValue - minValue;
        if (pointDistance == 0) {
            return avgValue;
        }
        int value = minValue + (int)((float)((point - minPoint) * valueDistance) / (float)pointDistance);
        return value;
    }
}

