/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.villagercomfort.core.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class CommonConfig {
    private static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.ConfigValue<Number> MAX_COMFORT_RANGE;
    public static final ForgeConfigSpec.ConfigValue<Number> MIN_COMFORT_PRICE_REDUCTION;
    public static final ForgeConfigSpec.ConfigValue<Number> MAX_COMFORT_PRICE_INCREASE;
    public static final ForgeConfigSpec.ConfigValue<Number> MAX_BEDROOM_VOLUME;
    public static final ForgeConfigSpec.ConfigValue<Number> MAX_WORKPLACE_VOLUME;
    public static final ForgeConfigSpec.ConfigValue<Number> MIN_BEDROOM_SIZE_COMFORT;
    public static final ForgeConfigSpec.ConfigValue<Number> MAX_BEDROOM_SIZE_COMFORT;
    public static final ForgeConfigSpec.ConfigValue<Number> PREFERRED_BEDROOM_SIZE;
    public static final ForgeConfigSpec.ConfigValue<Number> MIN_BEDROOM_SIZE;
    public static final ForgeConfigSpec.ConfigValue<Number> MAX_BEDROOM_SIZE;
    public static final ForgeConfigSpec.ConfigValue<Number> BEDS_THRESHOLD;
    public static final ForgeConfigSpec.ConfigValue<Number> COMFORT_PER_BED;
    public static final ForgeConfigSpec.ConfigValue<Number> PREFERRED_BEDROOM_LIGHT;
    public static final ForgeConfigSpec.ConfigValue<Number> COMFORT_PER_LESS_BEDROOM_LIGHT;
    public static final ForgeConfigSpec.ConfigValue<Number> COMFORT_PER_MORE_BEDROOM_LIGHT;
    public static final ForgeConfigSpec.ConfigValue<Number> WORKSTATION_IN_BEDROOM_COMFORT;
    public static final ForgeConfigSpec.ConfigValue<Number> MIN_WORKPLACE_SIZE_COMFORT;
    public static final ForgeConfigSpec.ConfigValue<Number> MAX_WORKPLACE_SIZE_COMFORT;
    public static final ForgeConfigSpec.ConfigValue<Number> PREFERRED_WORKPLACE_SIZE;
    public static final ForgeConfigSpec.ConfigValue<Number> MIN_WORKPLACE_SIZE;
    public static final ForgeConfigSpec.ConfigValue<Number> MAX_WORKPLACE_SIZE;
    public static final ForgeConfigSpec.ConfigValue<Number> WORKSTATIONS_THRESHOLD;
    public static final ForgeConfigSpec.ConfigValue<Number> COMFORT_PER_WORKSTATION;
    public static final ForgeConfigSpec.ConfigValue<Number> PREFERRED_WORKPLACE_LIGHT;
    public static final ForgeConfigSpec.ConfigValue<Number> COMFORT_PER_LESS_WORKPLACE_LIGHT;
    public static final ForgeConfigSpec.ConfigValue<Number> COMFORT_PER_MORE_WORKPLACE_LIGHT;
    public static final ForgeConfigSpec.ConfigValue<Number> PREFERRED_BED_WORKPLACE_DISTANCE;
    public static final ForgeConfigSpec.ConfigValue<Number> MIN_BED_WORKPLACE_DISTANCE;
    public static final ForgeConfigSpec.ConfigValue<Number> MAX_BED_WORKPLACE_DISTANCE;
    public static final ForgeConfigSpec.ConfigValue<Number> MIN_BED_WORKPLACE_DISTANCE_COMFORT;
    public static final ForgeConfigSpec.ConfigValue<Number> MAX_BED_WORKPLACE_DISTANCE_COMFORT;
    public static final ForgeConfigSpec.ConfigValue<Number> MINIMUM_TICKS_OUTSIDE;
    public static final ForgeConfigSpec.ConfigValue<Number> COMFORT_PER_DAY_WITHOUT_OUTSIDE;
    public static final ForgeConfigSpec.ConfigValue<Number> COMFORT_PER_DAY_WITHOUT_PANIC;
    public static final ForgeConfigSpec.ConfigValue<Number> MAX_DAYS_WITHOUT_OUTSIDE;
    public static final ForgeConfigSpec.ConfigValue<Number> MAX_DAYS_WITHOUT_PANIC;
    public static final ForgeConfigSpec.ConfigValue<Number> COMFORT_PER_DAY_WITHOUT_SLEEP;

    public static void setup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "villager-comfort.toml");
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.push("Prices");
        MAX_COMFORT_RANGE = BUILDER.comment("Set the comfort value boundaries to be -maxComfortRange to maxComfortRange. Allows for more precise customizability! Impact on price is linear between 0 and maxComfortRange").define("maxComfortRange", (Object)1000);
        MIN_COMFORT_PRICE_REDUCTION = BUILDER.comment("Min percentage of original price that an item can be reduced to. For example, a value of 70 means items can at most be reduced to 70% of their original price. A value of 0 means all items can reach 1 emerald in price. A value of 100 means items cannot go down in price. Only positive comfort values reduce item prices, and maxium comfort means lowest prices! :D").define("minComfortPriceReduction", (Object)10);
        MAX_COMFORT_PRICE_INCREASE = BUILDER.comment("Max percentage of original price that an item can go up in price. For example, a value of 0 means items cannot go up in price, and a value of 100 means items can at most double in price. 200 means tripling, etc.").define("maxComfortPriceIncrease", (Object)300);
        BUILDER.pop();
        BUILDER.push("Bedroom comfort values").comment("Various parameters relative to how comfortable a villager's bedroom is. A bedroom is defined by the room centered around a villager's last-slept-in bed, with a max radius of maxBedroomRadius.");
        PREFERRED_BEDROOM_SIZE = BUILDER.comment("How much empty space (measured in air blocks) the villager would like to have in their bedroom. Building a bigger room will increase comfort, and a smaller room will decrease comfort.").define("preferredBedroomSize", (Object)27);
        MIN_BEDROOM_SIZE = BUILDER.comment("Minimum bedroom size, at which comfort is the worst and can't decrease further").define("minBedroomSize", (Object)1);
        MAX_BEDROOM_SIZE = BUILDER.comment("Maximum bedroom size, at which comfort is the highest and can't increase further").define("maxBedroomSize", (Object)150);
        MIN_BEDROOM_SIZE_COMFORT = BUILDER.comment("Comfort value for when the bedroom is at minBedroomSize").define("minBedroomSizeComfort", (Object)-400);
        MAX_BEDROOM_SIZE_COMFORT = BUILDER.comment("Comfort value for when the bedroom is at maxBedroomSize").define("maxBedroomSizeComfort", (Object)400);
        BEDS_THRESHOLD = BUILDER.comment("Max number of beds that the villager is okay with having in their bedroom. Going above this number affects comfort according to comfortPerExtraBed").define("bedsThreshold", (Object)2);
        COMFORT_PER_BED = BUILDER.comment("Comfort impact from each bed above bedsThreshold").define("comfortPerExtraBed", (Object)-20);
        PREFERRED_BEDROOM_LIGHT = BUILDER.comment("The sky light level the villager would like in their room (measured at the brightest air block in the room)").define("preferredBedroomLight", (Object)12);
        COMFORT_PER_LESS_BEDROOM_LIGHT = BUILDER.comment("Comfort impact for each light level the brightest air block in the bedroom has below preferredBedroomLight").define("comfortPerLessBedroomLight", (Object)-25);
        COMFORT_PER_MORE_BEDROOM_LIGHT = BUILDER.comment("Comfort impact for each light level the brightest air block in the bedroom has above preferredBedroomLight").define("comfortPerMoreBedroomLight", (Object)0);
        WORKSTATION_IN_BEDROOM_COMFORT = BUILDER.comment("Comfort impact if the villager's workstation is in their bedroom").define("workstationInBedroomComfort", (Object)-20);
        BUILDER.pop();
        BUILDER.push("Workplace comfort values").comment("Various parameters relative to how comfortable a villager's workplace is. A workplace is defined as the room centered around a villager's last-worked-in workstation, with a max radius of maxWorkplaceRadius.");
        PREFERRED_WORKPLACE_SIZE = BUILDER.comment("How much empty space (measured in air blocks) the villager would like to have at their workplace. Building a bigger room will increase comfort, and a smaller room will decrease comfort.").define("averageWorkplaceSize", (Object)18);
        MIN_WORKPLACE_SIZE = BUILDER.comment("Minimum workplace size, at which comfort is the worst and can't decrease further").define("minWorkplaceSize", (Object)1);
        MAX_WORKPLACE_SIZE = BUILDER.comment("Maximum workplace size, at which comfort is the highest and can't increase further").define("maxWorkplaceSize", (Object)150);
        MIN_WORKPLACE_SIZE_COMFORT = BUILDER.comment("Comfort value for when the workplace is at minWorkplaceSize").define("minWorkplaceSizeComfort", (Object)-300);
        MAX_WORKPLACE_SIZE_COMFORT = BUILDER.comment("Comfort value for when the workplace is at maxWorkplaceSize").define("maxWorkplaceSizeComfort", (Object)350);
        WORKSTATIONS_THRESHOLD = BUILDER.comment("Max number of workstations that the villager is okay with having present at their workplace (of the same type). Going above this number affects comfort according to comfortPerExtraWorkstation").define("workstationsThreshold", (Object)6);
        COMFORT_PER_WORKSTATION = BUILDER.comment("Comfort impact from each workstation above workstationsThreshold").define("comfortPerExtraWorkstation", (Object)-20);
        PREFERRED_WORKPLACE_LIGHT = BUILDER.comment("The sky light level the villager would like at their workplace (measured at the brightest air block in the room)").define("preferredWorkplaceLight", (Object)12);
        COMFORT_PER_LESS_WORKPLACE_LIGHT = BUILDER.comment("Comfort impact for each light level the brightest air block in the workplace has below preferredWorkplaceLight").define("comfortPerLessWorkplaceLight", (Object)-50);
        COMFORT_PER_MORE_WORKPLACE_LIGHT = BUILDER.comment("Comfort impact for each light level the brightest air block in the workplace has above preferredWorkplaceLight").define("comfortPerMoreWorkplaceLight", (Object)0);
        BUILDER.pop();
        BUILDER.push("Other comfort values");
        PREFERRED_BED_WORKPLACE_DISTANCE = BUILDER.comment("The distance the villager prefers between their bed and workplace (distance is measured in blocks, and is a straight lines that ignores walls). A longer distance will increase comfort, and a shorter distance will decrease comfort.").define("preferredDistanceBetweenBedAndWorkplace", (Object)6);
        MIN_BED_WORKPLACE_DISTANCE = BUILDER.comment("Minimum distance between bed and workplace, at which comfort is the lowest and can't decrease further").define("minBedWorkplaceDistance", (Object)1);
        MAX_BED_WORKPLACE_DISTANCE = BUILDER.comment("Maximum  distance between bed and workplace, at which comfort is the highest and can't increase further").define("maxBedWorkplaceDistance", (Object)6);
        MIN_BED_WORKPLACE_DISTANCE_COMFORT = BUILDER.comment("Comfort value for when the bed-workplace distance is at minBedWorkplaceDistance").define("minBedWorkplaceDistanceComfort", (Object)-50);
        MAX_BED_WORKPLACE_DISTANCE_COMFORT = BUILDER.comment("Comfort value for when the bed-workplace distance is at maxBedWorkplaceDistance").define("maxBedWorkplaceDistanceComfort", (Object)0);
        MINIMUM_TICKS_OUTSIDE = BUILDER.comment("Minimum time (measured in ticks) a villager would like to spend outside each day (in multiples of 100)").define("minimumTicksOutside", (Object)1200);
        COMFORT_PER_DAY_WITHOUT_OUTSIDE = BUILDER.comment("Comfort impact per each consecutive day the villager spends less than minimumTicksOutside time outside").define("comfortPerDayWithoutOutside", (Object)-50);
        COMFORT_PER_DAY_WITHOUT_PANIC = BUILDER.comment("Comfort impact per each consecutive day the villager isn't panicking (usually from zombies, but other hostile mobs can cause panic too! Including being hit by players)").define("comfortPerDayWithoutPanic", (Object)10);
        MAX_DAYS_WITHOUT_OUTSIDE = BUILDER.comment("Max number of consecutive days for which comfortPerDayWithoutOutside can apply").define("maxDaysWithoutOutside", (Object)6);
        MAX_DAYS_WITHOUT_PANIC = BUILDER.comment("Max number of consecutive days for which comfortPerDayWithoutPanic can apply").define("maxDaysWithoutPanic", (Object)25);
        COMFORT_PER_DAY_WITHOUT_SLEEP = BUILDER.comment("Comfort impact per each consecutive day a villager spends without sleeping").define("comfortPerDayWithoutSleep", (Object)-100);
        BUILDER.pop();
        BUILDER.push("Max volumes").comment("bedroom/workplace calculations are done by starting at the villager's bed / workspace, then doing a Flood fill outwards from that position!");
        MAX_BEDROOM_VOLUME = BUILDER.comment("Max room volume to take into account when during bedroom calculations (includes air, objects in room and the walls themselves)").define("maxBedroomVolume", (Object)3000);
        MAX_WORKPLACE_VOLUME = BUILDER.comment("Max room volume to take into account when during workplace calculations (includes air, objects in room and the walls themselves)").define("maxWorkplaceVolume", (Object)3000);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

