/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.villagercomfort.comfort;

import com.mojang.logging.LogUtils;
import dev.ghen.villagercomfort.common.capabilty.ComfortValuesCap;
import dev.ghen.villagercomfort.core.config.CommonConfig;
import dev.ghen.villagercomfort.room.RoomHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class WorkplaceComfortValues {
    private static Logger LOGGER = LogUtils.getLogger();

    public static void setValuesToCap(Villager villager, ComfortValuesCap comfortValuesCap) {
        villager.m_6274_().m_21952_(MemoryModuleType.f_26360_).ifPresent(workstation -> {
            ServerLevel level = (ServerLevel)villager.m_9236_();
            BlockPos workstationPos = workstation.m_122646_();
            BlockState workstationBlock = level.m_8055_(workstationPos);
            AtomicInteger workstationsCount = new AtomicInteger(0);
            AtomicInteger roomSize = new AtomicInteger(0);
            AtomicInteger maxLightValue = new AtomicInteger(0);
            RoomHelper.runForEveryBlock(villager.m_9236_(), workstationPos, ((Number)CommonConfig.MAX_WORKPLACE_VOLUME.get()).intValue(), pos -> {
                if (!workstationBlock.m_60713_(Blocks.f_50016_) && level.m_8055_(pos).m_60713_(workstationBlock.m_60734_())) {
                    workstationsCount.getAndIncrement();
                } else if (level.m_8055_(pos).m_60713_(Blocks.f_50016_)) {
                    if (level.m_45517_(LightLayer.SKY, pos) > maxLightValue.get()) {
                        maxLightValue.set(level.m_45517_(LightLayer.SKY, pos));
                    }
                    roomSize.getAndIncrement();
                }
            });
            comfortValuesCap.setWorkplaceSize(roomSize.get());
            comfortValuesCap.setWorkstationsCount(workstationsCount.get());
            comfortValuesCap.setWorkplaceLight(maxLightValue.get());
        });
    }
}

