/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.villagercomfort.comfort;

import com.mojang.logging.LogUtils;
import dev.ghen.villagercomfort.common.capabilty.ComfortValuesCap;
import dev.ghen.villagercomfort.core.config.CommonConfig;
import dev.ghen.villagercomfort.room.RoomHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;

public class BedroomComfortValues {
    private static Logger LOGGER = LogUtils.getLogger();

    public static void setValuesToCap(Villager villager, BlockPos bedPos, ComfortValuesCap comfortValuesCap) {
        Level level = villager.m_9236_();
        GlobalPos workstation = villager.m_6274_().m_21952_(MemoryModuleType.f_26360_).orElse(null);
        AtomicInteger bedsCount = new AtomicInteger(0);
        AtomicInteger roomSize = new AtomicInteger(0);
        AtomicInteger maxLightValue = new AtomicInteger(0);
        AtomicBoolean isWorkstationInBedroom = new AtomicBoolean(false);
        RoomHelper.runForEveryBlock(villager.m_9236_(), bedPos, ((Number)CommonConfig.MAX_BEDROOM_VOLUME.get()).intValue(), pos -> {
            if (workstation != null && pos.equals((Object)workstation.m_122646_())) {
                isWorkstationInBedroom.set(true);
            } else if (level.m_8055_(pos).m_204336_(BlockTags.f_13038_)) {
                bedsCount.getAndIncrement();
            } else if (level.m_8055_(pos).m_60713_(Blocks.f_50016_)) {
                if (level.m_45517_(LightLayer.SKY, pos) > maxLightValue.get()) {
                    maxLightValue.set(level.m_45517_(LightLayer.SKY, pos));
                }
                roomSize.getAndIncrement();
            }
        });
        if (workstation != null) {
            int blockDistance = (int)Math.sqrt(bedPos.m_123331_((Vec3i)workstation.m_122646_()));
            comfortValuesCap.setBedWorkstationDistance(blockDistance);
        }
        comfortValuesCap.setBedroomSize(roomSize.get());
        comfortValuesCap.setBedsCount(bedsCount.get() / 2);
        comfortValuesCap.setBedroomLight(maxLightValue.get());
        comfortValuesCap.setIsWorkstationInBedroom(isWorkstationInBedroom.get());
    }
}

