/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import me.timvinci.terrastorage.api.ItemFavoritingUtils;
import me.timvinci.terrastorage.config.ConfigManager;
import me.timvinci.terrastorage.config.TerrastorageConfig;
import me.timvinci.terrastorage.inventory.CompactInventoryState;
import me.timvinci.terrastorage.inventory.CompleteInventoryState;
import me.timvinci.terrastorage.inventory.ExpandedInventoryState;
import me.timvinci.terrastorage.inventory.InventoryState;
import me.timvinci.terrastorage.inventory.InventoryUtils;
import me.timvinci.terrastorage.item.StackIdentifier;
import me.timvinci.terrastorage.item.StackProcessor;
import me.timvinci.terrastorage.mixin.DoubleInventoryAccessor;
import me.timvinci.terrastorage.mixin.EntityAccessor;
import me.timvinci.terrastorage.mixin.LockableContainerBlockEntityAccessor;
import me.timvinci.terrastorage.network.NetworkHandler;
import me.timvinci.terrastorage.util.SortType;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2624;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3908;
import net.minecraft.class_7265;

public class TerrastorageCore {
    public static void lootAll(class_1661 playerInventory, class_1263 storageInventory, boolean hotbarProtection) {
        CompleteInventoryState playerInventoryState = new CompleteInventoryState(playerInventory, hotbarProtection);
        for (int i = 0; i < storageInventory.method_5439(); ++i) {
            class_1799 storageStack = storageInventory.method_5438(i);
            if (storageStack.method_7960()) continue;
            InventoryUtils.transferStack((class_1263)playerInventory, playerInventoryState, storageStack);
        }
        if (playerInventoryState.wasModified()) {
            playerInventory.method_5431();
            storageInventory.method_5431();
        }
    }

    public static void depositAll(class_1661 playerInventory, class_1263 storageInventory, class_1735 firstSlot, boolean hotbarProtection) {
        class_1799 playerStack;
        int i;
        CompleteInventoryState storageInventoryState = new CompleteInventoryState(storageInventory);
        for (i = class_1661.method_7368(); i < playerInventory.field_7547.size(); ++i) {
            playerStack = playerInventory.method_5438(i);
            if (playerStack.method_7960() || ItemFavoritingUtils.isFavorite(playerStack) || !firstSlot.method_7680(playerStack)) continue;
            InventoryUtils.transferStack(storageInventory, storageInventoryState, playerStack);
        }
        if (!hotbarProtection) {
            for (i = 0; i < class_1661.method_7368(); ++i) {
                playerStack = playerInventory.method_5438(i);
                if (playerStack.method_7960() || ItemFavoritingUtils.isFavorite(playerStack) || !firstSlot.method_7680(playerStack)) continue;
                InventoryUtils.transferStack(storageInventory, storageInventoryState, playerStack);
            }
        }
        if (storageInventoryState.wasModified()) {
            playerInventory.method_5431();
            storageInventory.method_5431();
        }
    }

    public static void quickStack(class_1661 playerInventory, class_1263 storageInventory, boolean hotbarProtection, boolean smartDepositMode) {
        int startIndex;
        InventoryState storageInventoryState = smartDepositMode ? new ExpandedInventoryState(storageInventory) : new CompactInventoryState(storageInventory);
        StackProcessor processor = InventoryUtils.createStackProcessor(storageInventoryState, storageInventory, smartDepositMode);
        for (int i = startIndex = hotbarProtection ? class_1661.method_7368() : 0; i < playerInventory.field_7547.size(); ++i) {
            processor.tryProcess(playerInventory.method_5438(i));
        }
        if (storageInventoryState.wasModified()) {
            playerInventory.method_5431();
            storageInventory.method_5431();
        }
    }

    public static void restock(class_1661 playerInventory, class_1263 storageInventory, boolean hotbarProtection) {
        CompactInventoryState playerInventoryState = new CompactInventoryState(playerInventory, hotbarProtection);
        for (int i = 0; i < storageInventory.method_5439(); ++i) {
            class_1799 storageStack = storageInventory.method_5438(i);
            if (storageStack.method_7960() || !playerInventoryState.getNonFullItemSlots().containsKey(new StackIdentifier(storageStack))) continue;
            InventoryUtils.transferToExistingStack((class_1263)playerInventory, playerInventoryState, storageStack);
        }
        if (playerInventoryState.wasModified()) {
            playerInventory.method_5431();
            storageInventory.method_5431();
        }
    }

    public static void sortStorageItems(class_1263 storageInventory, SortType type) {
        List<class_1799> sortedStacks = InventoryUtils.combineAndSortInventory(storageInventory, type, 0, storageInventory.method_5439(), false);
        int slotIndex = 0;
        for (class_1799 stack : sortedStacks) {
            storageInventory.method_5447(slotIndex++, stack);
        }
        storageInventory.method_5431();
    }

    /*
     * Unable to fully structure code
     */
    public static void renameStorage(class_3222 player, String newName) {
        block8: {
            block7: {
                newCustomName = newName.isEmpty() != false ? null : class_2561.method_43470((String)newName);
                containerInventory = ((class_1735)player.field_7512.field_7761.get((int)0)).field_7871;
                if (!(containerInventory instanceof class_7265)) break block7;
                vehicleInventory = (class_7265)containerInventory;
                entity = (class_1297)vehicleInventory;
                if (newName.equals(((EntityAccessor)entity).invokeGetDefaultName().getString())) {
                    newCustomName = null;
                }
                entity.method_5665((class_2561)newCustomName);
                factory = (class_3908)entity;
                break block8;
            }
            if (!(containerInventory instanceof DoubleInventoryAccessor)) ** GOTO lbl34
            accessor = (DoubleInventoryAccessor)containerInventory;
            var10_10 = accessor.first();
            if (!(var10_10 instanceof class_2624)) ** GOTO lbl-1000
            firstPart = (class_2624)var10_10;
            var10_10 = accessor.second();
            if (var10_10 instanceof class_2624) {
                secondPart = (class_2624)var10_10;
                containerName = ((LockableContainerBlockEntityAccessor)firstPart).invokeGetContainerName().getString();
                doubleContainerName = class_2561.method_43471((String)"container.chestDouble").getString().replace(class_2561.method_43471((String)"container.chest").getString(), containerName);
                if (newName.equals(doubleContainerName)) {
                    newCustomName = null;
                }
                ((LockableContainerBlockEntityAccessor)firstPart).setCustomName((class_2561)newCustomName);
                ((LockableContainerBlockEntityAccessor)secondPart).setCustomName((class_2561)newCustomName);
                firstPart.method_5431();
                secondPart.method_5431();
                NetworkHandler.sendGlobalBlockRenamedPacket(player.method_51469(), firstPart.method_11016(), newCustomName == null ? "" : newCustomName.getString());
                NetworkHandler.sendGlobalBlockRenamedPacket(player.method_51469(), secondPart.method_11016(), newCustomName == null ? "" : newCustomName.getString());
                factory = firstPart.method_11010().method_26196(player.method_37908(), firstPart.method_11016());
            } else lbl-1000:
            // 2 sources

            {
                player.method_43496((class_2561)class_2561.method_43470((String)"The storage you tried to rename is currently unsupported by Terrastorage."));
                return;
lbl34:
                // 1 sources

                if (containerInventory instanceof class_2624) {
                    lockableContainerBlockEntity = (class_2624)containerInventory;
                    accessor = (LockableContainerBlockEntityAccessor)lockableContainerBlockEntity;
                    if (newName.equals(accessor.invokeGetContainerName().getString())) {
                        newCustomName = null;
                    }
                    accessor.setCustomName((class_2561)newCustomName);
                    lockableContainerBlockEntity.method_5431();
                    NetworkHandler.sendGlobalBlockRenamedPacket(player.method_51469(), lockableContainerBlockEntity.method_11016(), newCustomName == null ? "" : newCustomName.getString());
                    factory = lockableContainerBlockEntity.method_11010().method_26196(player.method_37908(), lockableContainerBlockEntity.method_11016());
                } else {
                    player.method_43496((class_2561)class_2561.method_43470((String)"The storage you tried to rename is currently unsupported by Terrastorage."));
                    return;
                }
            }
        }
        player.method_7346();
        player.method_17355(factory);
    }

    public static void sortPlayerItems(class_1661 playerInventory, SortType type, boolean hotbarProtection) {
        int slotIndex;
        List<class_1799> sortedList = InventoryUtils.combineAndSortInventory((class_1263)playerInventory, type, hotbarProtection ? class_1661.method_7368() : 0, playerInventory.field_7547.size(), true);
        ArrayDeque<class_1799> sortedStacks = new ArrayDeque<class_1799>(sortedList);
        for (slotIndex = class_1661.method_7368(); !sortedStacks.isEmpty() && slotIndex < 36; ++slotIndex) {
            if (!((class_1799)playerInventory.field_7547.get(slotIndex)).method_7960()) continue;
            playerInventory.field_7547.set(slotIndex, (Object)sortedStacks.pollFirst());
        }
        if (!hotbarProtection && !sortedStacks.isEmpty()) {
            slotIndex = 0;
            do {
                if (((class_1799)playerInventory.field_7547.get(slotIndex)).method_7960()) {
                    playerInventory.field_7547.set(slotIndex, (Object)sortedStacks.pollFirst());
                }
                ++slotIndex;
            } while (!sortedStacks.isEmpty());
        }
        playerInventory.method_5431();
    }

    public static void quickStackToNearbyStorages(class_3222 player, boolean hotbarProtection, boolean smartDepositMode) {
        int itemAnimationLength;
        List<class_3545<class_1263, class_243>> nearbyStorages = InventoryUtils.getNearbyStorages(player);
        if (nearbyStorages.isEmpty()) {
            return;
        }
        Function<class_1263, InventoryState> stateFactory = InventoryUtils.getInventoryStateFactory(smartDepositMode);
        HashMap<class_243, ArrayList<class_1792>> animationMap = new HashMap<class_243, ArrayList<class_1792>>();
        class_1661 playerInventory = player.method_31548();
        int startIndex = hotbarProtection ? class_1661.method_7368() : 0;
        boolean playerInventoryModified = false;
        for (class_3545<class_1263, class_243> storagePair : nearbyStorages) {
            class_1263 storage = (class_1263)storagePair.method_15442();
            class_243 storagePos = (class_243)storagePair.method_15441();
            InventoryState storageState = stateFactory.apply(storage);
            StackProcessor processor = InventoryUtils.createStackProcessor(storageState, storage, smartDepositMode);
            for (int i = startIndex; i < playerInventory.field_7547.size(); ++i) {
                class_1799 playerStack = playerInventory.method_5438(i);
                class_1792 playerItem = playerStack.method_7909();
                if (!processor.tryProcess(playerStack)) continue;
                animationMap.computeIfAbsent(storagePos, k -> new ArrayList()).add(playerItem);
            }
            if (!storageState.wasModified()) continue;
            storage.method_5431();
            playerInventoryModified = true;
        }
        if (playerInventoryModified) {
            playerInventory.method_5431();
        }
        if ((itemAnimationLength = ((TerrastorageConfig)ConfigManager.getInstance().getConfig()).getItemAnimationLength()) != 0) {
            InventoryUtils.triggerFlyOutAnimation(player.method_51469(), player.method_33571(), itemAnimationLength, animationMap);
        }
    }
}

