/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.network;

import java.util.List;
import java.util.Optional;
import me.timvinci.terrastorage.api.ItemFavoritingUtils;
import me.timvinci.terrastorage.inventory.SlotBackedInventory;
import me.timvinci.terrastorage.util.SortType;
import me.timvinci.terrastorage.util.StorageAction;
import me.timvinci.terrastorage.util.TerrastorageCore;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PacketRegistry {
    public static final class_2960 storageActionIdentifier = new class_2960("terrastorage", "storage_action");
    public static final class_2960 sortIdentifier = new class_2960("terrastorage", "sort_action");
    public static final class_2960 renameIdentifier = new class_2960("terrastorage", "rename_action");
    public static final class_2960 itemFavoriteIdentifier = new class_2960("terrastorage", "item_favorite_action");
    public static final class_2960 blockRenamedIdentifier = new class_2960("terrastorage", "block_renamed_update");
    public static final class_2960 serverConfigIdentifier = new class_2960("terrastorage", "server_config_update");

    public static void registerPacketReceivers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)storageActionIdentifier, (server, player, handler, buf, responseSender) -> {
            Optional syncId = buf.method_37436(class_2540::readInt);
            StorageAction action = (StorageAction)buf.method_10818(StorageAction.class);
            boolean hotbarProtection = buf.readBoolean();
            Optional smartDepositMode = buf.method_37436(class_2540::readBoolean);
            server.execute(() -> PacketRegistry.processStorageActionPacket(player, syncId, action, hotbarProtection, smartDepositMode));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)sortIdentifier, (server, player, handler, buf, responseSender) -> {
            Optional syncId = buf.method_37436(class_2540::readInt);
            SortType type = (SortType)buf.method_10818(SortType.class);
            Optional hotbarProtection = buf.method_37436(class_2540::readBoolean);
            server.execute(() -> PacketRegistry.processSortPacket(player, syncId, type, hotbarProtection));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)renameIdentifier, (server, player, handler, buf, responseSender) -> {
            int syncId = buf.readInt();
            String newName = buf.method_19772();
            server.execute(() -> PacketRegistry.processRenamePacket(player, syncId, newName));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)itemFavoriteIdentifier, (server, player, handler, buf, responseSender) -> {
            int slotId = buf.readInt();
            boolean value = buf.readBoolean();
            server.execute(() -> PacketRegistry.processItemFavoritePacket(player, slotId, value));
        });
    }

    private static void processStorageActionPacket(class_3222 player, Optional<Integer> syncId, StorageAction action, boolean hotbarProtection, Optional<Boolean> smartDepositMode) {
        if (action != StorageAction.QUICK_STACK_TO_NEARBY) {
            class_1263 storageInventory;
            if (player.field_7512 == null || player.field_7512.field_7763 != syncId.get()) {
                return;
            }
            class_1735 firstSlot = (class_1735)player.field_7512.field_7761.get(0);
            if (firstSlot.field_7871.method_5439() != 0) {
                if (!firstSlot.method_7674((class_1657)player)) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"terrastorage.message.restricted_inventory"));
                    return;
                }
                storageInventory = firstSlot.field_7871;
            } else {
                List<class_1735> nonPlayerSlots = player.field_7512.field_7761.stream().filter(slot -> !(slot.field_7871 instanceof class_1661)).toList();
                storageInventory = new SlotBackedInventory(nonPlayerSlots);
            }
            switch (action) {
                case LOOT_ALL: {
                    TerrastorageCore.lootAll(player.method_31548(), storageInventory, hotbarProtection);
                    break;
                }
                case DEPOSIT_ALL: {
                    TerrastorageCore.depositAll(player.method_31548(), storageInventory, firstSlot, hotbarProtection);
                    break;
                }
                case QUICK_STACK: {
                    TerrastorageCore.quickStack(player.method_31548(), storageInventory, hotbarProtection, smartDepositMode.get());
                    break;
                }
                case RESTOCK: {
                    TerrastorageCore.restock(player.method_31548(), storageInventory, hotbarProtection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown storage action: " + String.valueOf((Object)action));
                }
            }
        } else {
            TerrastorageCore.quickStackToNearbyStorages(player, hotbarProtection, smartDepositMode.get());
        }
    }

    private static void processSortPacket(class_3222 player, Optional<Integer> syncId, SortType type, Optional<Boolean> hotbarProtection) {
        if (hotbarProtection.isPresent()) {
            TerrastorageCore.sortPlayerItems(player.method_31548(), type, hotbarProtection.get());
        } else {
            class_1263 storageInventory;
            if (player.field_7512 == null || player.field_7512.field_7763 != syncId.get()) {
                return;
            }
            class_1735 firstSlot = (class_1735)player.field_7512.field_7761.get(0);
            if (firstSlot.field_7871.method_5439() != 0) {
                if (!firstSlot.method_7674((class_1657)player)) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"terrastorage.message.restricted_inventory"));
                    return;
                }
                storageInventory = firstSlot.field_7871;
            } else {
                List<class_1735> nonPlayerSlots = player.field_7512.field_7761.stream().filter(slot -> !(slot.field_7871 instanceof class_1661)).toList();
                storageInventory = new SlotBackedInventory(nonPlayerSlots);
            }
            TerrastorageCore.sortStorageItems(storageInventory, type);
        }
    }

    private static void processRenamePacket(class_3222 player, int syncId, String newName) {
        if (player.field_7512 == null || player.field_7512.field_7763 != syncId) {
            return;
        }
        if (!((class_1735)player.field_7512.field_7761.get(0)).method_7674((class_1657)player)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"terrastorage.message.restricted_inventory"));
            return;
        }
        TerrastorageCore.renameStorage(player, newName);
    }

    private static void processItemFavoritePacket(class_3222 player, int slotId, boolean value) {
        if (player.field_7512 == null) {
            return;
        }
        class_1703 playerScreenHandler = player.field_7512;
        if (slotId < 0 || slotId >= playerScreenHandler.field_7761.size()) {
            return;
        }
        class_1799 slotStack = playerScreenHandler.method_7611(slotId).method_7677();
        if (!slotStack.method_7960()) {
            ItemFavoritingUtils.setFavorite(slotStack, value);
        }
    }
}

