/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.network;

import java.util.Optional;
import me.timvinci.terrastorage.config.ClientConfigManager;
import me.timvinci.terrastorage.config.TerrastorageClientConfig;
import me.timvinci.terrastorage.network.PacketRegistry;
import me.timvinci.terrastorage.util.LocalizedTextProvider;
import me.timvinci.terrastorage.util.QuickStackMode;
import me.timvinci.terrastorage.util.StorageAction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class ClientNetworkHandler {
    public static int actionCooldown = 10;
    private static long lastActionWorldTime = 0L;
    private static class_1937 lastWorld = null;

    public static void sendActionPacket(StorageAction action) {
        if (!ClientNetworkHandler.canSendPacket(PacketRegistry.storageActionIdentifier) || action != StorageAction.QUICK_STACK_TO_NEARBY && class_310.method_1551().field_1724.field_7512 == null) {
            return;
        }
        if (ClientNetworkHandler.canPerformAction()) {
            class_2540 buf = PacketByteBufs.create();
            switch (action) {
                case QUICK_STACK: {
                    buf.method_37435(Optional.of(ClientNetworkHandler.getSyncId()), class_2540::writeInt);
                    buf.method_10817((Enum)action);
                    buf.writeBoolean(((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getHotbarProtection());
                    buf.method_37435(Optional.of(((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getStorageQuickStackMode() == QuickStackMode.SMART_DEPOSIT), class_2540::writeBoolean);
                    break;
                }
                case QUICK_STACK_TO_NEARBY: {
                    buf.method_37435(Optional.empty(), class_2540::writeInt);
                    buf.method_10817((Enum)action);
                    buf.writeBoolean(((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getHotbarProtection());
                    buf.method_37435(Optional.of(((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getNearbyQuickStackMode() == QuickStackMode.SMART_DEPOSIT), class_2540::writeBoolean);
                    break;
                }
                default: {
                    buf.method_37435(Optional.of(ClientNetworkHandler.getSyncId()), class_2540::writeInt);
                    buf.method_10817((Enum)action);
                    buf.writeBoolean(((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getHotbarProtection());
                    buf.method_37435(Optional.empty(), class_2540::writeBoolean);
                }
            }
            ClientPlayNetworking.send((class_2960)PacketRegistry.storageActionIdentifier, (class_2540)buf);
        } else {
            LocalizedTextProvider.sendCooldownMessage();
        }
    }

    public static void sendSortPacket(boolean playerInventory) {
        if (!ClientNetworkHandler.canSendPacket(PacketRegistry.sortIdentifier) || !playerInventory && class_310.method_1551().field_1724.field_7512 == null) {
            return;
        }
        if (ClientNetworkHandler.canPerformAction()) {
            class_2540 buf = PacketByteBufs.create();
            if (playerInventory) {
                buf.method_37435(Optional.empty(), class_2540::writeInt);
                buf.method_10817((Enum)((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getSortType());
                buf.method_37435(Optional.of(((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getHotbarProtection()), class_2540::writeBoolean);
            } else {
                buf.method_37435(Optional.of(ClientNetworkHandler.getSyncId()), class_2540::writeInt);
                buf.method_10817((Enum)((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getSortType());
                buf.method_37435(Optional.empty(), class_2540::writeBoolean);
            }
            ClientPlayNetworking.send((class_2960)PacketRegistry.sortIdentifier, (class_2540)buf);
        } else {
            LocalizedTextProvider.sendCooldownMessage();
        }
    }

    public static void sendRenamePacket(String newName) {
        if (!ClientNetworkHandler.canSendPacket(PacketRegistry.renameIdentifier) || class_310.method_1551().field_1724.field_7512 == null) {
            return;
        }
        if (ClientNetworkHandler.canPerformAction()) {
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(ClientNetworkHandler.getSyncId());
            buf.method_10814(newName);
            ClientPlayNetworking.send((class_2960)PacketRegistry.renameIdentifier, (class_2540)buf);
        } else {
            LocalizedTextProvider.sendCooldownMessage();
        }
    }

    public static boolean sendItemFavoritedPacket(int slotId, boolean value) {
        if (!ClientNetworkHandler.canSendPacket(PacketRegistry.itemFavoriteIdentifier)) {
            return false;
        }
        if (ClientNetworkHandler.canPerformAction()) {
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(slotId);
            buf.writeBoolean(value);
            ClientPlayNetworking.send((class_2960)PacketRegistry.itemFavoriteIdentifier, (class_2540)buf);
            return true;
        }
        LocalizedTextProvider.sendCooldownMessage();
        return false;
    }

    private static boolean canSendPacket(class_2960 channelName) {
        if (!ClientPlayNetworking.canSend((class_2960)channelName)) {
            LocalizedTextProvider.sendUnsupportedMessage();
            return false;
        }
        return true;
    }

    private static boolean canPerformAction() {
        if (actionCooldown == 0) {
            return true;
        }
        class_310 client = class_310.method_1551();
        class_638 currentWorld = client.field_1687;
        long currentWorldTime = currentWorld.method_8510();
        if (lastWorld != currentWorld) {
            lastActionWorldTime = 0L;
            lastWorld = currentWorld;
        }
        if (currentWorldTime - lastActionWorldTime >= (long)actionCooldown) {
            lastActionWorldTime = currentWorldTime;
            return true;
        }
        return false;
    }

    private static int getSyncId() {
        return class_310.method_1551().field_1724.field_7512.field_7763;
    }
}

