/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.mixin.client;

import java.util.Objects;
import me.timvinci.terrastorage.TerrastorageClient;
import me.timvinci.terrastorage.api.ItemFavoritingUtils;
import me.timvinci.terrastorage.gui.widget.StorageButtonCreator;
import me.timvinci.terrastorage.util.ScreenInteractionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_344;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_481;
import net.minecraft.class_485;
import net.minecraft.class_636;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_481.class})
public abstract class CreativeInventoryScreenMixin
extends class_485<class_481.class_483> {
    @Unique
    private class_344 quickStackButton;
    @Unique
    private class_344 sortInventoryButton;
    @Shadow
    @Nullable
    private class_1735 field_2889;

    public CreativeInventoryScreenMixin(class_481.class_483 screenHandler, class_1661 playerInventory, class_2561 text) {
        super((class_1703)screenHandler, playerInventory, text);
    }

    @Inject(method={"onMouseClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseClick(@Nullable class_1735 slot, int slotId, int button, class_1713 actionType, CallbackInfo ci) {
        class_1799 cursorStack = ((class_481.class_483)this.field_2797).method_34255();
        if (Objects.equals(slot, this.field_2889) && !cursorStack.method_7960() && ItemFavoritingUtils.isFavorite(cursorStack)) {
            ci.cancel();
            return;
        }
        ScreenInteractionUtils.processSlotClick(this.field_22787, cursorStack, slot, slotId, button, actionType, ci);
    }

    @Redirect(method={"onMouseClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;clickCreativeStack(Lnet/minecraft/item/ItemStack;I)V"))
    private void redirectClickCreativeStack(class_636 interactionManager, class_1799 stack, int i, @Nullable class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (actionType != class_1713.field_7794) {
            interactionManager.method_2909(stack, i);
            return;
        }
        if (i < 0 || i >= this.field_22787.field_1724.field_7498.method_7602().size()) {
            this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43471((String)"terrastorage.message.general_error"));
            return;
        }
        try {
            class_1799 playerStack = (class_1799)this.field_22787.field_1724.field_7498.method_7602().get(i);
            if (playerStack.method_7960() || ItemFavoritingUtils.isFavorite(playerStack)) {
                return;
            }
            interactionManager.method_2909(stack, i);
        }
        catch (Exception e) {
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"terrastorage.message.general_error"), false);
            TerrastorageClient.CLIENT_LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/CreativeInventoryScreen;setSelectedTab(Lnet/minecraft/item/ItemGroup;)V")})
    private void onInit(CallbackInfo ci) {
        int buttonX = this.field_2776 + 138;
        int buttonY = this.field_2800 + 19;
        class_3545<class_344, class_344> buttons = StorageButtonCreator.createInventoryButtons(buttonX, buttonY);
        this.quickStackButton = (class_344)buttons.method_15442();
        this.method_37063((class_364)this.quickStackButton);
        this.sortInventoryButton = (class_344)buttons.method_15441();
        this.method_37063((class_364)this.sortInventoryButton);
    }

    @Inject(method={"setSelectedTab"}, at={@At(value="TAIL")})
    private void onSetSelectedTab(class_1761 group, CallbackInfo ci) {
        if (class_7923.field_44687.method_47983((Object)group).method_40225(class_7706.field_40206)) {
            this.quickStackButton.field_22764 = true;
            this.sortInventoryButton.field_22764 = true;
        } else {
            this.quickStackButton.field_22764 = false;
            this.sortInventoryButton.field_22764 = false;
        }
    }
}

