/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import me.timvinci.terrastorage.config.ClientConfigManager;
import me.timvinci.terrastorage.config.TerrastorageClientConfig;
import me.timvinci.terrastorage.gui.widget.StorageButtonCreator;
import me.timvinci.terrastorage.gui.widget.StorageButtonWidget;
import me.timvinci.terrastorage.mixin.client.GenericContainerScreenAccessor;
import me.timvinci.terrastorage.mixin.client.SliderWidgetAccessor;
import me.timvinci.terrastorage.util.ButtonsPlacement;
import me.timvinci.terrastorage.util.ButtonsStyle;
import me.timvinci.terrastorage.util.LocalizedTextProvider;
import me.timvinci.terrastorage.util.StorageAction;
import me.timvinci.terrastorage.util.TextStyler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4892;
import net.minecraft.class_5348;
import net.minecraft.class_7172;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class ButtonsCustomizationScreen
extends class_437 {
    private static final class_2960 TEXTURE = GenericContainerScreenAccessor.TEXTURE();
    private final class_437 parent;
    private final class_2561 storagePreviewTitle = class_2561.method_43471((String)"terrastorage.title.buttons_customization_screen.storage");
    private int x;
    private int y;
    private final int backgroundWidth = 176;
    private int backgroundHeight = 166;
    private final int storagePreviewTitleX = 8;
    private final int storagePreviewTitleY = 6;
    private final class_2561 playerInventoryTitle = class_2561.method_43471((String)"container.inventory");
    protected int playerInventoryTitleX = 8;
    protected int playerInventoryTitleY = this.backgroundHeight - 94;
    private int rows = 6;
    private boolean widgetsInitialized = false;
    private int buttonActionsLength;
    private final List<class_339> customizationWidgets;
    private final int customizationWidgetsWidth = 150;
    private final int customizationWidgetsHeight = 20;
    private final int customizationWidgetsSpacing = 5;
    private final List<class_4185> actionWidgets;
    private final List<StorageButtonWidget> storageOptionsButtons;
    private boolean storageOptionsEnabled;
    private boolean storageOptionsTooltip;
    private ButtonsStyle storageOptionsStyle;
    private ButtonsPlacement storageOptionsPlacement;
    private int storageOptionsXOffset;
    private int storageOptionsYOffset;
    private int storageOptionsWidth;
    private int storageOptionsHeight;
    private int storageOptionsSpacing;

    public ButtonsCustomizationScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"terrastorage.title.buttons_customization_screen"));
        this.parent = parent;
        this.updateBackgroundHeight();
        this.customizationWidgets = new ArrayList<class_339>();
        this.actionWidgets = new ArrayList<class_4185>();
        this.storageOptionsButtons = new ArrayList<StorageButtonWidget>();
        TerrastorageClientConfig config = (TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig();
        this.storageOptionsEnabled = config.getButtonsEnabled();
        this.storageOptionsTooltip = config.getButtonsTooltip();
        this.storageOptionsStyle = config.getButtonsStyle();
        this.storageOptionsPlacement = config.getButtonsPlacement();
        this.storageOptionsXOffset = config.getButtonsXOffset();
        this.storageOptionsYOffset = config.getButtonsYOffset();
        this.storageOptionsWidth = config.getButtonsWidth();
        this.storageOptionsHeight = config.getButtonsHeight();
        this.storageOptionsSpacing = config.getButtonsSpacing();
    }

    private void updateBackgroundHeight() {
        this.backgroundHeight = 114 + this.rows * 18;
        this.playerInventoryTitleY = this.backgroundHeight - 94;
    }

    private void updateXAndY() {
        this.x = (this.field_22789 - this.backgroundWidth) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
    }

    protected void method_25426() {
        int i;
        this.updateXAndY();
        if (!this.widgetsInitialized) {
            this.initializeWidgets();
            this.widgetsInitialized = true;
        }
        if (this.storageOptionsEnabled) {
            this.updateStorageOptionsEnabled();
        }
        int buttonX = this.storageOptionsPlacement == ButtonsPlacement.RIGHT ? (this.x - 150) / 2 : this.x + this.backgroundWidth + (this.field_22789 - (this.x + 176) - 150) / 2;
        int buttonSectionHeight = this.customizationWidgets.size() * 20 + (this.customizationWidgets.size() - 1) * 5;
        int buttonY = (this.field_22790 - (buttonSectionHeight += 10)) / 2;
        for (i = 0; i < this.customizationWidgets.size(); ++i) {
            this.customizationWidgets.get(i).method_48229(buttonX, buttonY);
            this.method_37063((class_364)this.customizationWidgets.get(i));
            buttonY += 20 + (i == 0 ? 3 : 1) * 5;
        }
        buttonX = (this.field_22789 - 150) / 2;
        buttonSectionHeight = this.actionWidgets.size() * 20 + (this.actionWidgets.size() - 1) * 5;
        buttonY = this.field_22790 - 7 - buttonSectionHeight;
        for (i = 0; i < this.actionWidgets.size() - 1; ++i) {
            this.actionWidgets.get(i).method_48229(buttonX, buttonY);
            this.method_37063((class_364)this.actionWidgets.get(i));
            buttonY += 25;
        }
        this.actionWidgets.get(this.actionWidgets.size() - 1).method_48229(this.field_22789 / 2 - 100, buttonY);
        this.method_37063((class_364)this.actionWidgets.get(this.actionWidgets.size() - 1));
    }

    private void initializeWidgets() {
        StorageAction[] buttonActions = StorageAction.getButtonsActions(false);
        this.buttonActionsLength = buttonActions.length;
        if (this.storageOptionsTooltip) {
            for (StorageAction storageAction : buttonActions) {
                class_2561 buttonText = LocalizedTextProvider.buttonTextCache.get((Object)storageAction);
                class_7919 buttonTooltip = LocalizedTextProvider.buttonTooltipCache.get((Object)storageAction);
                StorageButtonWidget storageButton = StorageButtonCreator.createDummyStorageButton(this.storageOptionsWidth, this.storageOptionsHeight, buttonText, this.storageOptionsStyle);
                storageButton.method_47400(buttonTooltip);
                this.storageOptionsButtons.add(storageButton);
            }
        } else {
            for (StorageAction storageAction : buttonActions) {
                class_2561 buttonText = LocalizedTextProvider.buttonTextCache.get((Object)storageAction);
                StorageButtonWidget storageButton = StorageButtonCreator.createDummyStorageButton(this.storageOptionsWidth, this.storageOptionsHeight, buttonText, this.storageOptionsStyle);
                this.storageOptionsButtons.add(storageButton);
            }
        }
        this.customizationWidgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"terrastorage.option.preview_row_count").method_27693(": " + this.rows), onPress -> {
            this.rows = this.rows == 6 ? 3 : 6;
            this.customizationWidgets.get(0).method_25355((class_2561)class_2561.method_43471((String)"terrastorage.option.preview_row_count").method_27693(": " + this.rows));
            this.updateBackgroundHeight();
            this.x = (this.field_22789 - this.backgroundWidth) / 2;
            this.y = (this.field_22790 - this.backgroundHeight) / 2;
        }).method_46437(150, 20).method_46431());
        this.customizationWidgets.add((class_339)class_4185.method_46430((class_2561)LocalizedTextProvider.getBooleanOptionText("buttons_enabled", this.storageOptionsEnabled), onPress -> {
            this.storageOptionsEnabled = !this.storageOptionsEnabled;
            this.customizationWidgets.get(1).method_25355(LocalizedTextProvider.getBooleanOptionText("buttons_enabled", this.storageOptionsEnabled));
            this.updateStorageOptionsEnabled();
        }).method_46437(150, 20).method_46431());
        this.customizationWidgets.add((class_339)class_4185.method_46430((class_2561)LocalizedTextProvider.getBooleanOptionText("buttons_tooltip", this.storageOptionsTooltip), onPress -> {
            this.storageOptionsTooltip = !this.storageOptionsTooltip;
            this.customizationWidgets.get(2).method_25355(LocalizedTextProvider.getBooleanOptionText("buttons_tooltip", this.storageOptionsTooltip));
            this.updateStorageOptionsTooltip();
        }).method_46437(150, 20).method_46431());
        this.customizationWidgets.add((class_339)class_4185.method_46430((class_2561)LocalizedTextProvider.getEnumOptionText("buttons_style", this.storageOptionsStyle), onPress -> {
            this.storageOptionsStyle = ButtonsStyle.next(this.storageOptionsStyle);
            this.customizationWidgets.get(3).method_25355(LocalizedTextProvider.getEnumOptionText("buttons_style", this.storageOptionsStyle));
            this.updateStorageOptionsStyle();
        }).method_46437(150, 20).method_46431());
        this.customizationWidgets.add((class_339)class_4185.method_46430((class_2561)LocalizedTextProvider.getEnumOptionText("buttons_placement", this.storageOptionsPlacement), onPress -> {
            this.storageOptionsPlacement = ButtonsPlacement.next(this.storageOptionsPlacement);
            this.customizationWidgets.get(4).method_25355(LocalizedTextProvider.getEnumOptionText("buttons_placement", this.storageOptionsPlacement));
            this.updateStorageOptionsX();
            this.updateCustomizationWidgetsX();
        }).method_46437(150, 20).method_46431());
        this.customizationWidgets.add(new class_7172("terrastorage.option.buttons_x_offset", class_7172.method_42399(), (text, value) -> class_2561.method_30163((String)(text.getString() + ": " + value)), (class_7172.class_7178)new class_7172.class_7174(-100, 100), (Codec)Codec.INT, (Object)this.storageOptionsXOffset, newValue -> {
            this.storageOptionsXOffset = newValue;
            this.updateStorageOptionsX();
        }).method_18520(this.field_22787.field_1690, 0, 0, 150));
        this.customizationWidgets.add(new class_7172("terrastorage.option.buttons_y_offset", class_7172.method_42399(), (text, value) -> class_2561.method_30163((String)(text.getString() + ": " + value)), (class_7172.class_7178)new class_7172.class_7174(-100, 100), (Codec)Codec.INT, (Object)this.storageOptionsYOffset, newValue -> {
            this.storageOptionsYOffset = newValue;
            this.updateStorageOptionsY();
        }).method_18520(this.field_22787.field_1690, 0, 0, 150));
        this.customizationWidgets.add(new class_7172("terrastorage.option.buttons_width", class_7172.method_42399(), (text, value) -> class_2561.method_30163((String)(text.getString() + ": " + value)), (class_7172.class_7178)new class_7172.class_7174(20, 150), (Codec)Codec.INT, (Object)this.storageOptionsWidth, newValue -> {
            this.storageOptionsWidth = newValue;
            this.updateStorageOptionsWidth();
        }).method_18520(this.field_22787.field_1690, 0, 0, 150));
        if (this.storageOptionsStyle == ButtonsStyle.TEXT_ONLY) {
            this.setWidthCustomizationEnabled(false);
        }
        this.customizationWidgets.add(new class_7172("terrastorage.option.buttons_height", class_7172.method_42399(), (text, value) -> class_2561.method_30163((String)(text.getString() + ": " + value)), (class_7172.class_7178)new class_7172.class_7174(5, 50), (Codec)Codec.INT, (Object)this.storageOptionsHeight, newValue -> {
            this.storageOptionsHeight = newValue;
            this.updateStorageOptionsHeight();
        }).method_18520(this.field_22787.field_1690, 0, 0, 150));
        this.customizationWidgets.add(new class_7172("terrastorage.option.buttons_spacing", class_7172.method_42399(), (text, value) -> class_2561.method_30163((String)(text.getString() + ": " + value)), (class_7172.class_7178)new class_7172.class_7174(0, 20), (Codec)Codec.INT, (Object)this.storageOptionsSpacing, newValue -> {
            this.storageOptionsSpacing = newValue;
            this.updateStorageOptionsY();
        }).method_18520(this.field_22787.field_1690, 0, 0, 150));
        this.actionWidgets.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"terrastorage.option.reset_to_default"), onPress -> this.applyFromConfig(ClientConfigManager.getInstance().getDefaultConfig())).method_46437(150, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"terrastorage.option.tooltip.reset_to_default"))).method_46431());
        this.actionWidgets.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"terrastorage.option.undo_changes"), onPress -> this.applyFromConfig((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig())).method_46437(150, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"terrastorage.option.tooltip.undo_changes"))).method_46431());
        this.actionWidgets.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"terrastorage.option.save_and_exit"), onPress -> {
            TerrastorageClientConfig config = (TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig();
            config.setButtonsEnabled(this.storageOptionsEnabled);
            config.setButtonsTooltip(this.storageOptionsTooltip);
            config.setButtonsStyle(this.storageOptionsStyle);
            config.setButtonsPlacement(this.storageOptionsPlacement);
            config.setButtonsXOffset(this.storageOptionsXOffset);
            config.setButtonsYOffset(this.storageOptionsYOffset);
            config.setButtonsWidth(this.storageOptionsWidth);
            config.setButtonsHeight(this.storageOptionsHeight);
            config.setButtonsSpacing(this.storageOptionsSpacing);
            if (!ClientConfigManager.getInstance().saveConfig() && class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7353((class_2561)TextStyler.error("terrastorage.message.client_saving_error"), false);
            }
            this.method_25419();
        }).method_46437(200, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"terrastorage.option.tooltip.save_and_exit"))).method_46431());
    }

    private void updateCustomizationWidgetsX() {
        int customizationWidgetsX = this.storageOptionsPlacement == ButtonsPlacement.RIGHT ? (this.x - 150) / 2 : this.x + this.backgroundWidth + (this.field_22789 - (this.x + 176) - 150) / 2;
        this.customizationWidgets.forEach(button -> button.method_46421(customizationWidgetsX));
    }

    private void updateStorageOptionsEnabled() {
        if (this.storageOptionsEnabled) {
            int buttonX = this.storageOptionsPlacement == ButtonsPlacement.RIGHT ? this.x + this.backgroundWidth + 5 + this.storageOptionsXOffset : this.x - ((this.storageOptionsStyle == ButtonsStyle.DEFAULT ? this.storageOptionsWidth : 70) + 5) + this.storageOptionsXOffset;
            int n = this.buttonActionsLength * this.storageOptionsHeight + (this.buttonActionsLength - 1) * this.storageOptionsSpacing;
            int buttonY = this.y - (n - this.playerInventoryTitleY) / 2 + this.storageOptionsYOffset;
            for (class_4185 class_41852 : this.storageOptionsButtons) {
                class_41852.method_48229(buttonX, buttonY);
                this.method_37063((class_364)class_41852);
                buttonY += this.storageOptionsHeight + this.storageOptionsSpacing;
            }
        } else {
            for (class_4185 class_41853 : this.storageOptionsButtons) {
                this.method_37066((class_364)class_41853);
            }
        }
    }

    private void updateStorageOptionsTooltip() {
        if (this.storageOptionsTooltip) {
            StorageAction[] buttonActions = StorageAction.getButtonsActions(false);
            for (int i = 0; i < buttonActions.length; ++i) {
                this.storageOptionsButtons.get(i).method_47400(LocalizedTextProvider.buttonTooltipCache.get((Object)buttonActions[i]));
            }
        } else {
            this.storageOptionsButtons.forEach(button -> button.method_47400(class_7919.method_47407((class_2561)class_2561.method_43473())));
        }
    }

    private void updateStorageOptionsStyle() {
        boolean isTextOnly = this.storageOptionsStyle == ButtonsStyle.TEXT_ONLY;
        this.storageOptionsButtons.forEach(button -> {
            if (isTextOnly) {
                button.method_25358(class_310.method_1551().field_1772.method_27525((class_5348)button.method_25369()) + 6);
            } else {
                button.method_25358(this.storageOptionsWidth);
            }
            button.setButtonStyle(this.storageOptionsStyle);
        });
        this.setWidthCustomizationEnabled(!isTextOnly);
        if (this.storageOptionsPlacement == ButtonsPlacement.LEFT && this.storageOptionsWidth != 70) {
            this.updateStorageOptionsX();
        }
    }

    private void updateStorageOptionsX() {
        int newX = this.storageOptionsPlacement == ButtonsPlacement.RIGHT ? this.x + this.backgroundWidth + 5 + this.storageOptionsXOffset : this.x - ((this.storageOptionsStyle == ButtonsStyle.DEFAULT ? this.storageOptionsWidth : 70) + 5) + this.storageOptionsXOffset;
        this.storageOptionsButtons.forEach(button -> button.method_46421(newX));
    }

    private void updateStorageOptionsY() {
        int buttonSectionHeight = this.buttonActionsLength * this.storageOptionsHeight + (this.buttonActionsLength - 1) * this.storageOptionsSpacing;
        int buttonY = this.y - (buttonSectionHeight - this.playerInventoryTitleY) / 2 + this.storageOptionsYOffset;
        for (StorageButtonWidget storageOptionButton : this.storageOptionsButtons) {
            storageOptionButton.method_46419(buttonY);
            buttonY += this.storageOptionsHeight + this.storageOptionsSpacing;
        }
    }

    private void updateStorageOptionsWidth() {
        this.storageOptionsButtons.forEach(button -> button.method_25358(this.storageOptionsWidth));
        if (this.storageOptionsPlacement == ButtonsPlacement.LEFT) {
            this.updateStorageOptionsX();
        }
    }

    private void updateStorageOptionsHeight() {
        this.storageOptionsButtons.forEach(button -> button.setHeight(this.storageOptionsHeight));
        this.updateStorageOptionsY();
    }

    private void setWidthCustomizationEnabled(boolean enabled) {
        this.customizationWidgets.get((int)7).field_22763 = enabled;
        this.customizationWidgets.get(7).method_47400(class_7919.method_47407((class_2561)(enabled ? class_2561.method_43473() : class_2561.method_43471((String)"terrastorage.option.tooltip.button_width_disabled"))));
    }

    private void applyFromConfig(TerrastorageClientConfig config) {
        class_4892 optionSliderWidget;
        if (this.storageOptionsEnabled != config.getButtonsEnabled()) {
            this.storageOptionsEnabled = config.getButtonsEnabled();
            this.updateStorageOptionsEnabled();
            this.customizationWidgets.get(1).method_25355(LocalizedTextProvider.getBooleanOptionText("buttons_enabled", this.storageOptionsEnabled));
        }
        if (this.storageOptionsTooltip != config.getButtonsTooltip()) {
            this.storageOptionsTooltip = config.getButtonsTooltip();
            this.updateStorageOptionsTooltip();
            this.customizationWidgets.get(2).method_25355(LocalizedTextProvider.getBooleanOptionText("buttons_tooltip", this.storageOptionsTooltip));
        }
        if (this.storageOptionsStyle != config.getButtonsStyle()) {
            this.storageOptionsStyle = config.getButtonsStyle();
            this.updateStorageOptionsStyle();
            this.customizationWidgets.get(3).method_25355(LocalizedTextProvider.getEnumOptionText("buttons_style", this.storageOptionsStyle));
        }
        if (this.storageOptionsPlacement != config.getButtonsPlacement()) {
            this.storageOptionsPlacement = config.getButtonsPlacement();
            this.updateStorageOptionsX();
            this.updateCustomizationWidgetsX();
            this.customizationWidgets.get(4).method_25355(LocalizedTextProvider.getEnumOptionText("buttons_placement", this.storageOptionsPlacement));
        }
        if (this.storageOptionsXOffset != config.getButtonsXOffset()) {
            this.storageOptionsXOffset = config.getButtonsXOffset();
            this.updateStorageOptionsX();
            class_339 class_3392 = this.customizationWidgets.get(5);
            if (class_3392 instanceof class_4892) {
                optionSliderWidget = (class_4892)class_3392;
                double normalizedValue = (double)(this.storageOptionsXOffset + 100) / 200.0;
                ((SliderWidgetAccessor)optionSliderWidget).invokeSetValue(normalizedValue);
            }
        }
        if (this.storageOptionsYOffset != config.getButtonsYOffset()) {
            this.storageOptionsYOffset = config.getButtonsYOffset();
            this.updateStorageOptionsY();
            class_339 normalizedValue = this.customizationWidgets.get(6);
            if (normalizedValue instanceof class_4892) {
                optionSliderWidget = (class_4892)normalizedValue;
                double normalizedValue2 = (double)(this.storageOptionsYOffset + 100) / 200.0;
                ((SliderWidgetAccessor)optionSliderWidget).invokeSetValue(normalizedValue2);
            }
        }
        if (this.storageOptionsWidth != config.getButtonsWidth()) {
            class_339 normalizedValue2;
            this.storageOptionsWidth = config.getButtonsWidth();
            if (this.storageOptionsStyle == ButtonsStyle.DEFAULT) {
                this.updateStorageOptionsWidth();
            }
            if ((normalizedValue2 = this.customizationWidgets.get(7)) instanceof class_4892) {
                optionSliderWidget = (class_4892)normalizedValue2;
                double normalizedValue = (double)(this.storageOptionsWidth - 20) / 130.0;
                ((SliderWidgetAccessor)optionSliderWidget).invokeSetValue(normalizedValue);
            }
        }
        if (this.storageOptionsHeight != config.getButtonsHeight()) {
            this.storageOptionsHeight = config.getButtonsHeight();
            this.updateStorageOptionsHeight();
            class_339 normalizedValue = this.customizationWidgets.get(8);
            if (normalizedValue instanceof class_4892) {
                optionSliderWidget = (class_4892)normalizedValue;
                double normalizedValue3 = (double)(this.storageOptionsHeight - 5) / 45.0;
                ((SliderWidgetAccessor)optionSliderWidget).invokeSetValue(normalizedValue3);
            }
        }
        if (this.storageOptionsSpacing != config.getButtonsSpacing()) {
            this.storageOptionsSpacing = config.getButtonsSpacing();
            this.updateStorageOptionsHeight();
            class_339 normalizedValue3 = this.customizationWidgets.get(9);
            if (normalizedValue3 instanceof class_4892) {
                optionSliderWidget = (class_4892)normalizedValue3;
                double normalizedValue = (double)this.storageOptionsSpacing / 20.0;
                ((SliderWidgetAccessor)optionSliderWidget).invokeSetValue(normalizedValue);
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 5, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 context) {
        super.method_25420(context);
        int i = (this.field_22789 - 176) / 2;
        int j = (this.field_22790 - this.backgroundHeight) / 2;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        context.method_25302(TEXTURE, i, j, 0, 0, 176, this.rows * 18 + 17);
        context.method_25302(TEXTURE, i, j + this.rows * 18 + 17, 0, 126, 176, 96);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_51439(this.field_22793, this.storagePreviewTitle, this.x + 8, this.y + 6, 0x404040, false);
        context.method_51439(this.field_22793, this.playerInventoryTitle, this.x + this.playerInventoryTitleX, this.y + this.playerInventoryTitleY, 0x404040, false);
    }

    public boolean method_25421() {
        return true;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }
}

