/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.config;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import me.timvinci.terrastorage.TerrastorageClient;
import me.timvinci.terrastorage.config.BaseConfigManager;
import me.timvinci.terrastorage.config.ConfigProperty;
import me.timvinci.terrastorage.config.SingleOption;
import me.timvinci.terrastorage.config.SubProperty;
import me.timvinci.terrastorage.config.TerrastorageClientConfig;
import me.timvinci.terrastorage.util.LocalizedTextProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_3545;
import net.minecraft.class_4185;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class ClientConfigManager
extends BaseConfigManager<TerrastorageClientConfig> {
    private static ClientConfigManager instance;

    public ClientConfigManager() {
        super("terrastorage_client.toml", TerrastorageClient.CLIENT_LOGGER);
    }

    public static void init() {
        instance = new ClientConfigManager();
        instance.loadConfig();
    }

    public static ClientConfigManager getInstance() {
        return instance;
    }

    @Override
    public TerrastorageClientConfig getDefaultConfig() {
        return new TerrastorageClientConfig();
    }

    public List<class_3545<class_339, Boolean>> asOptions() {
        ArrayList<class_4185> options = new ArrayList<class_4185>();
        ArrayList<Boolean> singleOptionOrder = new ArrayList<Boolean>();
        int i = 0;
        for (Field field : ((TerrastorageClientConfig)this.config).getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigProperty.class) || field.isAnnotationPresent(SubProperty.class)) continue;
            if (field.trySetAccessible()) {
                ConfigProperty property = field.getAnnotation(ConfigProperty.class);
                String propertyKey = property.key();
                boolean singleOption = field.isAnnotationPresent(SingleOption.class);
                Object fieldValue = this.getFieldValue(field, (TerrastorageClientConfig)this.config, propertyKey);
                if (fieldValue == null) continue;
                class_4185 optionButton = null;
                int finalI = i;
                if (fieldValue.getClass().equals(Boolean.class)) {
                    optionButton = class_4185.method_46430((class_2561)LocalizedTextProvider.getBooleanOptionText(propertyKey, (Boolean)fieldValue), onPress -> {
                        boolean currentValue = (Boolean)this.getFieldValue(field, (TerrastorageClientConfig)this.config, propertyKey);
                        currentValue = !currentValue;
                        this.setFieldValue(field, currentValue, propertyKey);
                        ((class_339)options.get(finalI)).method_25355(LocalizedTextProvider.getBooleanOptionText(propertyKey, currentValue));
                    }).method_46431();
                } else if (fieldValue.getClass().isEnum()) {
                    optionButton = class_4185.method_46430((class_2561)LocalizedTextProvider.getEnumOptionText(propertyKey, (Enum)fieldValue), onPress -> {
                        Enum currentValue = (Enum)this.getFieldValue(field, (TerrastorageClientConfig)this.config, propertyKey);
                        try {
                            Method nextMethod = currentValue.getClass().getMethod("next", currentValue.getClass());
                            currentValue = (Enum)nextMethod.invoke(currentValue.getClass(), currentValue);
                            this.setFieldValue(field, currentValue, propertyKey);
                            ((class_339)options.get(finalI)).method_25355(LocalizedTextProvider.getEnumOptionText(propertyKey, currentValue));
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            this.logger.error("Failed to find or invoke the next method for the '{}' enum class.", (Object)currentValue.getClass().getName(), (Object)e);
                        }
                    }).method_46431();
                }
                if (optionButton == null) continue;
                optionButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)("terrastorage.option.tooltip." + propertyKey))));
                options.add(i, optionButton);
                singleOptionOrder.add(i++, singleOption);
                continue;
            }
            this.logger.error("Failed to set field '{}' as accessible.", (Object)field.getName());
        }
        ArrayList<class_3545<class_339, Boolean>> result = new ArrayList<class_3545<class_339, Boolean>>();
        for (int j = 0; j < options.size(); ++j) {
            result.add((class_3545<class_339, Boolean>)new class_3545((Object)((class_339)options.get(j)), (Object)((Boolean)singleOptionOrder.get(j))));
        }
        return result;
    }
}

