/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.timvinci.terrastorage.config.ConfigManager;
import me.timvinci.terrastorage.config.TerrastorageConfig;
import me.timvinci.terrastorage.network.NetworkHandler;
import me.timvinci.terrastorage.util.TextStyler;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class TerrastorageCommands {
    public static void registerCommands() {
        TerrastorageConfig config = (TerrastorageConfig)ConfigManager.getInstance().getConfig();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"terrastorage").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"action-cooldown").executes(context -> TerrastorageCommands.executeGetValue((CommandContext<class_2168>)context, config::getActionCooldown, "Action Cooldown", " ticks"))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> TerrastorageCommands.executeSetValue((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), config::setActionCooldown, "Action Cooldown", " ticks"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"line-of-sight-check").executes(context -> TerrastorageCommands.executeGetValue((CommandContext<class_2168>)context, config::getLineOfSightCheck, "Line Of Sight Check", ""))).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> TerrastorageCommands.executeSetValue((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"value"), config::setLineOfSightCheck, "Line Of Sight Check", ""))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"quick-stack-range").executes(context -> TerrastorageCommands.executeGetValue((CommandContext<class_2168>)context, config::getQuickStackRange, "Quick Stack Range", " blocks"))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)3, (int)48)).executes(context -> TerrastorageCommands.executeSetValue((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), config::setQuickStackRange, "Quick Stack Range", " blocks"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"item-animation-length").executes(context -> TerrastorageCommands.executeGetValue((CommandContext<class_2168>)context, config::getItemAnimationLength, "Item Animation Length", " ticks"))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)200)).executes(context -> TerrastorageCommands.executeSetValue((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), config::setItemAnimationLength, "Item Animation Length", " ticks"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"item-animation-interval").executes(context -> TerrastorageCommands.executeGetValue((CommandContext<class_2168>)context, config::getItemAnimationInterval, "Item Animation Interval", " ticks"))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(context -> TerrastorageCommands.executeSetValue((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), config::setItemAnimationInterval, "Item Animation Interval", " ticks"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"keep-favorites-on-drop").executes(context -> TerrastorageCommands.executeGetValue((CommandContext<class_2168>)context, config::getKeepFavoritesOnDrop, "Keep Favorites On Drop", ""))).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> TerrastorageCommands.executeSetValue((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"value"), config::setKeepFavoritesOnDrop, "Keep Favorites On Drop", ""))))));
    }

    private static <T> int executeGetValue(CommandContext<class_2168> context, Supplier<T> getter, String propertyName, String valueUnit) {
        Object currentValue = getter.get();
        ((class_2168)context.getSource()).method_9226(() -> TextStyler.styleGetProperty(propertyName, currentValue, valueUnit), false);
        return 1;
    }

    private static <T> int executeSetValue(CommandContext<class_2168> context, T value, Consumer<T> setter, String propertyName, String valueUnit) {
        setter.accept(value);
        if (ConfigManager.getInstance().saveConfig()) {
            ((class_2168)context.getSource()).method_9226(() -> TextStyler.stylePropertyUpdated(propertyName, value, valueUnit), true);
            if (propertyName.equals("Action Cooldown")) {
                NetworkHandler.sendGlobalServerConfigPacket(((class_2168)context.getSource()).method_9211());
            } else if (propertyName.equals("Quick Stack Range") && (Integer)value > 16) {
                ((class_2168)context.getSource()).method_9226(() -> TextStyler.warning("terrastorage.message.high_quick_stack_range"), false);
            }
        } else {
            ((class_2168)context.getSource()).method_9226(() -> TextStyler.error("terrastorage.message.server_saving_error"), false);
        }
        return 1;
    }
}

