/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.analysis;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.sinytra.adapter.patch.analysis.InsnComparator;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;

public record InstructionMatcher(AbstractInsnNode insn, List<AbstractInsnNode> before, List<AbstractInsnNode> after) {
    @Nullable
    public String findReplacement(List<String> cleanCallOrder, List<String> dirtyCallOrder) {
        MethodInsnNode previousMethodCall = MethodCallAnalyzer.findFirstInsn(this.before.get(0), MethodInsnNode.class, MethodCallAnalyzer.BACKWARDS);
        if (previousMethodCall == null) {
            return null;
        }
        String previousCallQualifier = MethodCallAnalyzer.getCallQualifier(previousMethodCall);
        int previousCallIndex = dirtyCallOrder.indexOf(previousCallQualifier);
        if (previousCallIndex == -1) {
            return null;
        }
        int previousDirtyCount = InstructionMatcher.count(dirtyCallOrder, previousCallQualifier);
        if (previousDirtyCount < 1 || previousDirtyCount != InstructionMatcher.count(cleanCallOrder, previousCallQualifier)) {
            return null;
        }
        MethodInsnNode nextMethodCall = MethodCallAnalyzer.findFirstInsn(this.after.get(0), MethodInsnNode.class, MethodCallAnalyzer.FORWARD);
        if (nextMethodCall == null) {
            return null;
        }
        String nextCallQualifier = MethodCallAnalyzer.getCallQualifier(nextMethodCall);
        int nextCallIndex = dirtyCallOrder.indexOf(nextCallQualifier);
        if (nextCallIndex == -1) {
            return null;
        }
        int nextDirtyCount = InstructionMatcher.count(dirtyCallOrder, nextCallQualifier);
        if (nextDirtyCount < 1 || nextDirtyCount != InstructionMatcher.count(cleanCallOrder, nextCallQualifier)) {
            return null;
        }
        int diff = nextCallIndex - previousCallIndex;
        if (diff == 2) {
            return dirtyCallOrder.get(previousCallIndex + 1);
        }
        return null;
    }

    public boolean test(InstructionMatcher other) {
        return this.test(other, 0);
    }

    public boolean test(InstructionMatcher other, int flags) {
        if (this.before.size() == other.before.size() && this.after.size() == other.after.size()) {
            AbstractInsnNode otherInsn;
            AbstractInsnNode insn;
            int i;
            for (i = 0; i < this.before.size(); ++i) {
                insn = this.before.get(i);
                if (InsnComparator.instructionsEqual(insn, otherInsn = other.before.get(i), flags)) continue;
                return false;
            }
            for (i = 0; i < this.after.size(); ++i) {
                insn = this.after.get(i);
                if (InsnComparator.instructionsEqual(insn, otherInsn = other.after.get(i), flags)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean test(InsnList first, InsnList second) {
        if (first.size() == second.size()) {
            for (int i = 0; i < first.size(); ++i) {
                AbstractInsnNode otherInsn;
                AbstractInsnNode insn = first.get(i);
                if (InsnComparator.instructionsEqual(insn, otherInsn = second.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T> int count(List<T> list, T item) {
        return (int)list.stream().filter(item::equals).count();
    }
}

