/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.world.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.lyof.phantasm.block.ModBlocks;
import net.lyof.phantasm.utils.BlockHelper;
import net.lyof.phantasm.world.feature.config.PurpurCabinFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class PurpurCabinFeature
extends Feature<PurpurCabinFeatureConfig> {
    public static final Feature<PurpurCabinFeatureConfig> INSTANCE = new PurpurCabinFeature(PurpurCabinFeatureConfig.CODEC);

    public PurpurCabinFeature(Codec<PurpurCabinFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<PurpurCabinFeatureConfig> context) {
        RandomSource random = context.m_225041_();
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        int width = ((PurpurCabinFeatureConfig)context.m_159778_()).width().m_214085_(random) / 2;
        int length = ((PurpurCabinFeatureConfig)context.m_159778_()).length().m_214085_(random) / 2;
        if (world.m_8055_(origin.m_175288_(38)).m_60713_((Block)ModBlocks.RAW_PURPUR.get())) {
            origin = origin.m_175288_(38);
        } else if (world.m_8055_(origin.m_175288_(30)).m_60713_((Block)ModBlocks.RAW_PURPUR.get())) {
            origin = origin.m_175288_(30);
        } else if (world.m_8055_(origin.m_175288_(22)).m_60713_((Block)ModBlocks.RAW_PURPUR.get())) {
            origin = origin.m_175288_(22);
        } else {
            return false;
        }
        origin.m_7918_(-(origin.m_123341_() % 16), 0, -(origin.m_123343_() % 16));
        for (int sx = -width; sx <= width; ++sx) {
            for (int sz = -length; sz <= length; ++sz) {
                BlockHelper.placeColumn((LevelAccessor)world, origin.m_122030_(sx).m_122013_(sz), 2, Blocks.f_50016_.m_49966_());
            }
        }
        PurpurCabinFeature.decorate(world, origin, width, length);
        return true;
    }

    static void decorate(WorldGenLevel level, BlockPos origin, int width, int length) {
        int i;
        BiPredicate<BlockGetter, BlockPos> condition = (a, b) -> a.m_8055_(b.m_7495_()).m_60713_((Block)ModBlocks.RAW_PURPUR.get()) || a.m_8055_(b.m_6625_(2)).m_60713_((Block)ModBlocks.RAW_PURPUR.get());
        BlockHelper.placeColumn((LevelAccessor)level, origin.m_122030_(-width).m_122013_(-length), 2, ((Block)ModBlocks.RAW_PURPUR_PILLAR.get()).m_49966_(), condition);
        BlockHelper.placeColumn((LevelAccessor)level, origin.m_122030_(width).m_122013_(-length), 2, ((Block)ModBlocks.RAW_PURPUR_PILLAR.get()).m_49966_(), condition);
        BlockHelper.placeColumn((LevelAccessor)level, origin.m_122030_(-width).m_122013_(length), 2, ((Block)ModBlocks.RAW_PURPUR_PILLAR.get()).m_49966_(), condition);
        BlockHelper.placeColumn((LevelAccessor)level, origin.m_122030_(width).m_122013_(length), 2, ((Block)ModBlocks.RAW_PURPUR_PILLAR.get()).m_49966_(), condition);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (i = 1 - width; i < width; ++i) {
            positions.add(origin.m_122013_(length).m_122030_(i));
            positions.add(origin.m_122013_(-length).m_122030_(i));
        }
        for (i = 1 - length; i < length; ++i) {
            positions.add(origin.m_122030_(width).m_122013_(i));
            positions.add(origin.m_122030_(-width).m_122013_(i));
        }
        ArrayList<BlockState> states = new ArrayList<BlockState>(List.of(Blocks.f_50091_.m_49966_(), Blocks.f_50679_.m_49966_(), Blocks.f_50094_.m_49966_(), Blocks.f_50094_.m_49966_().m_60717_(Rotation.CLOCKWISE_90), Blocks.f_50094_.m_49966_().m_60717_(Rotation.CLOCKWISE_180), Blocks.f_50094_.m_49966_().m_60717_(Rotation.COUNTERCLOCKWISE_90), (BlockState)Blocks.f_50618_.m_49966_().m_61124_((Property)BarrelBlock.f_49042_, (Comparable)Direction.UP), (BlockState)Blocks.f_50618_.m_49966_().m_61124_((Property)BarrelBlock.f_49042_, (Comparable)Direction.UP)));
        RandomSource rnd = RandomSource.m_216327_();
        for (int j = 0; j < rnd.m_216332_(3, 6); ++j) {
            BlockPos pos = (BlockPos)positions.remove(rnd.m_216332_(0, positions.size()));
            if (!level.m_8055_(pos.m_7495_()).m_60713_((Block)ModBlocks.RAW_PURPUR.get())) continue;
            level.m_7731_(pos, (BlockState)states.remove(rnd.m_216339_(0, states.size())), 3);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof BarrelBlockEntity)) continue;
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            PurpurCabinFeature.setLootBarrel(barrel);
        }
        for (Direction direction : List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST)) {
            for (int i2 = 0; i2 < rnd.m_216332_(12, 20); ++i2) {
                BlockHelper.placeColumn((LevelAccessor)level, BlockPos.m_122022_((long)BlockPos.m_121915_((long)i2, (Direction)direction)), 2, Blocks.f_50016_.m_49966_(), (a, b) -> a.m_8055_(b).m_60713_((Block)ModBlocks.RAW_PURPUR.get()));
            }
        }
    }

    static int closestY(int base) {
        if (base >= 37) {
            return 38;
        }
        if (base >= 29) {
            return 30;
        }
        return 22;
    }

    static void setLootBarrel(BarrelBlockEntity barrel) {
        barrel.m_59626_(new ResourceLocation("minecraft", "chests/end_city_treasure"), RandomSupport.m_224599_());
    }
}

