/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.world.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.lyof.phantasm.block.ModBlocks;
import net.lyof.phantasm.block.custom.DirectionalBlock;
import net.lyof.phantasm.setup.ModTags;
import net.lyof.phantasm.world.feature.config.BoulderFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class CeilingBoulderFeature
extends Feature<BoulderFeatureConfig> {
    public static final Feature<BoulderFeatureConfig> INSTANCE = new CeilingBoulderFeature(BoulderFeatureConfig.CODEC);

    public CeilingBoulderFeature(Codec<BoulderFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<BoulderFeatureConfig> context) {
        FeaturePlaceContext contextnext;
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        BoulderFeatureConfig config = (BoulderFeatureConfig)context.m_159778_();
        ArrayList<BlockPos> toPlace = new ArrayList<BlockPos>();
        ArrayList<BlockPos> fans = new ArrayList<BlockPos>();
        int size = config.size().m_214085_(random);
        Direction primary = Direction.m_122407_((int)random.m_188503_(4));
        Direction secondary = random.m_188499_() ? primary.m_122427_() : primary.m_122428_();
        BlockPos pos = new BlockPos((Vec3i)origin).m_175288_(0);
        while (!(pos.m_123342_() >= world.m_141928_() || world.m_8055_(pos.m_7494_()).m_204336_(ModTags.Blocks.END_PLANTS_GROWABLE_ON) && world.m_8055_(pos).m_60713_(Blocks.f_50016_))) {
            pos = pos.m_7494_();
        }
        if (pos.m_123342_() >= world.m_141928_() - 2) {
            return false;
        }
        this.spike(toPlace, pos, 1);
        this.spike(fans, pos, 2);
        pos = this.move(pos, primary, secondary, random, world);
        for (int i = 0; i < size; ++i) {
            this.spike(toPlace, pos, 2);
            this.spike(fans, pos, 3);
            pos = this.move(pos, primary, secondary, random, world);
        }
        this.spike(toPlace, pos, 1);
        this.spike(fans, pos, 2);
        for (BlockPos place : toPlace) {
            this.m_159742_(world, place, config.block().m_213972_(random, place), block -> size > 0 && block.m_60631_((BlockGetter)world, place));
        }
        for (BlockPos place : fans) {
            this.m_159742_(world, place, ((DirectionalBlock)((Object)ModBlocks.CHORAL_FAN.get())).getPlacementState((LevelReader)world, place), block -> random.m_188503_(5) == 0 && block.m_60631_((BlockGetter)world, place));
        }
        if (size == 0 && Math.random() < 0.7 && world.m_46805_((contextnext = new FeaturePlaceContext(context.m_190935_(), context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_().m_122030_(random.m_216332_(-5, 5)).m_122013_(random.m_216332_(-5, 5)), (FeatureConfiguration)config)).m_159777_())) {
            this.m_142674_((FeaturePlaceContext<BoulderFeatureConfig>)contextnext);
        }
        return true;
    }

    public BlockPos move(BlockPos pos, Direction primary, Direction secondary, RandomSource random, WorldGenLevel world) {
        pos = pos.m_121945_(primary);
        if (random.m_188503_(4) == 0) {
            pos = pos.m_121945_(primary.m_122427_());
        } else if (random.m_188503_(4) == 0) {
            pos = pos.m_121945_(primary.m_122428_());
        } else if (random.m_188503_(4) == 0) {
            pos = pos.m_121945_(secondary);
        }
        if (!world.m_8055_(pos).m_60631_((BlockGetter)world, pos)) {
            pos = pos.m_7495_();
        }
        if (world.m_8055_(pos.m_7494_()).m_60631_((BlockGetter)world, pos)) {
            pos = pos.m_7494_();
        }
        return pos;
    }

    public void spike(List<BlockPos> world, BlockPos pos, int layer) {
        if (layer <= 0) {
            if (!world.contains(pos)) {
                world.add(pos);
            }
            return;
        }
        for (Direction dir : Direction.values()) {
            this.spike(world, pos.m_121945_(dir), layer - 1);
        }
    }
}

