/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.entities.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.lyof.phantasm.block.custom.SubwooferBlock;
import net.lyof.phantasm.config.ConfigEntries;
import net.lyof.phantasm.effect.ModEffects;
import net.lyof.phantasm.entities.ModEntities;
import net.lyof.phantasm.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChoralArrowEntity
extends Arrow {
    public int lifetime = 0;
    public boolean shotByCrossbow = false;

    public ChoralArrowEntity(EntityType<? extends Arrow> type, Level level) {
        super(type, level);
    }

    public static ChoralArrowEntity create(Level level, LivingEntity shooter) {
        ChoralArrowEntity arrow = ChoralArrowEntity.create(level, shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
        arrow.m_5602_((Entity)shooter);
        return arrow;
    }

    public static ChoralArrowEntity create(Level level, double x, double y, double z) {
        ChoralArrowEntity arrow = new ChoralArrowEntity((EntityType<? extends Arrow>)((EntityType)ModEntities.CHORAL_ARROW.get()), level);
        arrow.m_6034_(x, y, z);
        return arrow;
    }

    protected void m_7761_(LivingEntity entity) {
        if (!this.shotByCrossbow) {
            super.m_7761_(entity);
            entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.CHARM.get(), 40, 0));
        }
    }

    public ItemStack m_7941_() {
        return ((Item)ModItems.CHORAL_ARROW.get()).m_7968_();
    }

    protected float m_6882_() {
        return 0.2f;
    }

    public void m_6686_(double x, double y, double z, float speed, float divergence) {
        super.m_6686_(x, y, z, speed * 0.75f, divergence * 4.0f);
    }

    public boolean m_36792_() {
        return false;
    }

    public static boolean isUsingCrossbow(LivingEntity shooter) {
        return shooter.m_21205_().m_41720_() instanceof CrossbowItem || shooter.m_21206_().m_41720_() instanceof CrossbowItem && !(shooter.m_21205_().m_41720_() instanceof BowItem);
    }

    public void m_8119_() {
        if (this.lifetime == 0) {
            LivingEntity living;
            Entity entity;
            boolean bl = this.shotByCrossbow = this.m_19749_() != null && (entity = this.m_19749_()) instanceof LivingEntity && ChoralArrowEntity.isUsingCrossbow(living = (LivingEntity)entity);
        }
        if (this.shotByCrossbow && this.lifetime > 0) {
            this.m_146870_();
        }
        if (this.shotByCrossbow && this.m_19749_() != null && this.lifetime == 0) {
            Level level = this.m_9236_();
            Entity shooter = this.m_19749_();
            Vec3 direction = this.m_20184_().m_82541_();
            Vec3 position = this.m_20182_();
            int range = ConfigEntries.subwooferRange * 2;
            ArrayList<UUID> affected = new ArrayList<UUID>();
            if (!shooter.m_6047_()) {
                shooter.m_20256_(direction.m_82490_(-1.5).m_82520_(0.0, 0.1, 0.0));
                shooter.f_19864_ = true;
                shooter.f_19789_ = 0.0f;
                affected.add(shooter.m_20148_());
            }
            for (int i = 0; i < range; ++i) {
                BlockPos pos = new BlockPos((int)Math.round(position.f_82479_ - 0.5), (int)Math.round(position.f_82480_ - 0.5), (int)Math.round(position.f_82481_ - 0.5));
                List entities = level.m_6249_(shooter, new AABB(pos).m_82400_(1.0), SubwooferBlock::canPush);
                level.m_7107_((ParticleOptions)ParticleTypes.f_235902_, position.f_82479_, position.f_82480_, position.f_82481_, 0.0, 0.0, 0.0);
                level.m_5594_(null, pos, SoundEvents.f_215771_, SoundSource.PLAYERS, 0.2f, 1.5f);
                for (Entity e : entities) {
                    if (affected.contains(e.m_20148_())) continue;
                    affected.add(e.m_20148_());
                    e.m_6469_(shooter.m_269291_().m_269418_((AbstractArrow)this, shooter), 6.0f);
                    e.m_20256_(direction.m_82490_(2.5).m_82520_(0.0, 0.4, 0.0));
                    e.f_19864_ = true;
                }
                if (level.m_8055_(pos).m_204336_(BlockTags.f_144272_)) break;
                position = position.m_82549_(direction);
            }
        }
        if (!this.shotByCrossbow) {
            super.m_8119_();
        }
        if (!this.shotByCrossbow && this.m_9236_().m_5776_() && !this.f_36703_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), (double)((float)this.lifetime / 20.0f), 0.0, 0.0);
        }
        ++this.lifetime;
    }
}

