/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_totem_of_undying.util;

import com.cerbon.better_totem_of_undying.BetterTotemOfUndying;
import com.cerbon.better_totem_of_undying.config.BTUConfigs;
import com.cerbon.better_totem_of_undying.config.custom.Blacklists;
import com.cerbon.better_totem_of_undying.config.custom.DefaultTotemFeatures;
import com.cerbon.better_totem_of_undying.config.custom.NewTotemFeatures;
import com.cerbon.better_totem_of_undying.platform.BTUServices;
import com.cerbon.better_totem_of_undying.util.BTUConstants;
import com.cerbon.better_totem_of_undying.util.mixin.ILivingEntityMixin;
import com.cerbon.cerbons_api.api.static_utilities.MiscUtils;
import com.cerbon.cerbons_api.api.static_utilities.RegistryUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kotlin.jvm.functions.Function1;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BTUUtils {
    private static final BTUConfigs btuConfigs = BetterTotemOfUndying.config;

    public static boolean canSaveFromDeath(@NotNull LivingEntity livingEntity, DamageSource damageSource) {
        ServerPlayer player;
        ItemStack itemStack = BTUUtils.getTotemItemStack(livingEntity);
        BlockPos entityPos = livingEntity.m_20183_();
        Level level = livingEntity.m_9236_();
        boolean isTotemOnCooldown = livingEntity instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).m_36335_().m_41519_(Items.f_42747_);
        boolean isTeleportOutOfVoidEnabled = BTUUtils.btuConfigs.newTotemFeatures.teleportOutOfVoid.enabled;
        if (itemStack == null || BTUUtils.isDimensionBlacklisted(level) || BTUUtils.isStructureBlacklisted(entityPos, (ServerLevel)level) || BTUUtils.damageBypassInvulnerability(damageSource, livingEntity) || !isTeleportOutOfVoidEnabled && BTUUtils.isInVoid(livingEntity, damageSource) || isTotemOnCooldown) {
            return false;
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)livingEntity;
            BTUUtils.giveUseStatAndCriterion(itemStack, player2);
            BTUUtils.addCooldown(itemStack, player2, BTUUtils.btuConfigs.newTotemFeatures.cooldown.cooldown);
        }
        if (!BTUUtils.btuConfigs.newTotemFeatures.totemResistanceType.infinity || !EnchantmentHelper.m_44831_((ItemStack)itemStack).containsKey(Enchantments.f_44952_)) {
            itemStack.m_41774_(1);
        }
        if (BTUUtils.btuConfigs.defaultTotemFeatures.clearEffectsUponUse) {
            livingEntity.m_21219_();
        }
        livingEntity.m_21153_((float)BTUUtils.btuConfigs.defaultTotemFeatures.healthUponUse);
        BTUUtils.applyTotemEffects(livingEntity, damageSource);
        BTUUtils.destroyBlocksWhenSuffocatingOrFullyFrozen(livingEntity, level);
        BTUUtils.knockbackMobsAway(livingEntity, level);
        BTUUtils.teleportOutOfVoid(livingEntity, level, damageSource);
        level.m_7605_((Entity)livingEntity, (byte)35);
        return true;
    }

    public static boolean isDimensionBlacklisted(@NotNull Level level) {
        for (Blacklists.Dimension blackListedDimension : BTUUtils.btuConfigs.blacklists.blacklistedDimensions) {
            if (!level.m_46472_().m_135782_().toString().equals(blackListedDimension.name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStructureBlacklisted(BlockPos pos, @NotNull ServerLevel level) {
        for (Blacklists.Structure blackListedStructure : BTUUtils.btuConfigs.blacklists.blacklistedStructures) {
            Structure structure = RegistryUtils.getStructureByKey((String)blackListedStructure.name, (ServerLevel)level);
            if (structure == null || !level.m_215010_().m_220494_(pos, structure).m_73603_()) continue;
            return true;
        }
        return false;
    }

    public static boolean damageBypassInvulnerability(@NotNull DamageSource damageSource, LivingEntity livingEntity) {
        return damageSource.m_269533_(DamageTypeTags.f_268738_) && !(livingEntity.m_20186_() < (double)livingEntity.m_9236_().m_141937_());
    }

    public static boolean isInVoid(LivingEntity livingEntity, @NotNull DamageSource damageSource) {
        return damageSource.m_276093_(DamageTypes.f_268724_) && livingEntity.m_20186_() < (double)livingEntity.m_9236_().m_141937_();
    }

    public static ItemStack getTotemItemStack(LivingEntity livingEntity) {
        List<ItemStack> possibleTotemStacks = BTUUtils.filterPossibleTotemStacks(BTUUtils.getTotemFromCharmSlot(livingEntity), BTUUtils.getTotemFromUtilityBar(livingEntity), BTUUtils.getTotemFromInventory(livingEntity), BTUUtils.getTotemFromHands(livingEntity));
        return possibleTotemStacks.stream().findFirst().orElse(null);
    }

    @Nullable
    public static ItemStack getTotemFromUtilityBar(LivingEntity livingEntity) {
        if (MiscUtils.isModLoaded((String)"inventorio") && BTUUtils.isTotemFromUtilityBeltEnabled() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            try {
                Class<?> mixinHelpersClass = Class.forName("de.rubixdev.inventorio.util.MixinHelpers");
                Method withAddonMethod = mixinHelpersClass.getMethod("withInventoryAddonReturning", Player.class, Function1.class);
                Function1 consumer = addon -> {
                    try {
                        Field utilityBeltField = addon.getClass().getField("utilityBelt");
                        Object utilityBeltObj = utilityBeltField.get(addon);
                        if (utilityBeltObj instanceof Iterable) {
                            for (Object stack : (Iterable)utilityBeltObj) {
                                ItemStack itemStack;
                                if (!(stack instanceof ItemStack) || !(itemStack = (ItemStack)stack).m_150930_(Items.f_42747_)) continue;
                                return itemStack;
                            }
                        }
                    }
                    catch (Exception e) {
                        BTUConstants.LOGGER.error("Error while getting totem from utility belt", (Throwable)e);
                    }
                    return null;
                };
                Object result = withAddonMethod.invoke(null, player, consumer);
                if (result instanceof ItemStack) {
                    return (ItemStack)result;
                }
            }
            catch (Exception e) {
                BTUConstants.LOGGER.error("Error while getting totem from utility belt", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isTotemFromUtilityBeltEnabled() {
        try {
            Class<?> globalSettingsClass = Class.forName("de.rubixdev.inventorio.config.GlobalSettings");
            Field totemField = globalSettingsClass.getField("totemFromUtilityBelt");
            Object totemConfigEntry = totemField.get(null);
            Method getBoolValueMethod = totemConfigEntry.getClass().getMethod("getBoolValue", new Class[0]);
            Object result = getBoolValueMethod.invoke(totemConfigEntry, new Object[0]);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (Exception e) {
            BTUConstants.LOGGER.error("Error while getting totem from utility belt config", (Throwable)e);
        }
        return false;
    }

    public static List<ItemStack> filterPossibleTotemStacks(ItemStack ... stacks) {
        return Arrays.stream(stacks).filter(Objects::nonNull).toList();
    }

    @Nullable
    public static ItemStack getTotemFromCharmSlot(LivingEntity livingEntity) {
        return BTUServices.PLATFORM_CHARM_HELPER.getTotemFromCharmSlot(livingEntity);
    }

    @Nullable
    public static ItemStack getTotemFromInventory(LivingEntity livingEntity) {
        if (BTUUtils.btuConfigs.newTotemFeatures.canUseTotemFromInventory && livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            for (ItemStack itemStack : player.m_150109_().f_35974_) {
                if (!itemStack.m_150930_(Items.f_42747_)) continue;
                return itemStack;
            }
        }
        return null;
    }

    @Nullable
    public static ItemStack getTotemFromHands(LivingEntity livingEntity) {
        for (InteractionHand interactionHand : InteractionHand.values()) {
            ItemStack itemStack = livingEntity.m_21120_(interactionHand);
            if (!itemStack.m_150930_(Items.f_42747_)) continue;
            return itemStack;
        }
        return null;
    }

    public static void giveUseStatAndCriterion(@NotNull ItemStack itemStack, ServerPlayer player) {
        if (!itemStack.m_41619_()) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
            CriteriaTriggers.f_10551_.m_74431_(player, itemStack);
        }
    }

    public static void addCooldown(ItemStack itemStack, ServerPlayer player, int cooldown) {
        if (BTUUtils.btuConfigs.newTotemFeatures.cooldown.enabled) {
            player.m_36335_().m_41524_(itemStack.m_41720_(), cooldown);
        }
    }

    public static void applyTotemEffects(LivingEntity livingEntity, DamageSource damageSource) {
        DefaultTotemFeatures defaultTotemFeatures = BTUUtils.btuConfigs.defaultTotemFeatures;
        NewTotemFeatures newTotemFeatures = BTUUtils.btuConfigs.newTotemFeatures;
        int fireResistanceEffectDuration = defaultTotemFeatures.fireResistance.duration;
        int regenerationEffectDuration = defaultTotemFeatures.regeneration.duration;
        int regenerationEffectAmplifier = defaultTotemFeatures.regeneration.amplifier;
        int absorptionEffectDuration = defaultTotemFeatures.absorption.duration;
        int absorptionEffectAmplifier = defaultTotemFeatures.absorption.amplifier;
        int waterBreathingEffectDuration = newTotemFeatures.waterBreathing.duration;
        if (newTotemFeatures.applyEffectsOnlyWhenNecessary) {
            if (livingEntity.m_6060_() && defaultTotemFeatures.fireResistance.enabled) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, fireResistanceEffectDuration, 0));
            }
            if (livingEntity.m_20072_() && newTotemFeatures.waterBreathing.enabled) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19608_, waterBreathingEffectDuration, 0));
            }
        } else {
            if (defaultTotemFeatures.fireResistance.enabled) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, fireResistanceEffectDuration, 0));
            }
            if (newTotemFeatures.waterBreathing.enabled) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19608_, waterBreathingEffectDuration, 0));
            }
        }
        if (defaultTotemFeatures.regeneration.enabled) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, regenerationEffectDuration, regenerationEffectAmplifier));
        }
        if (defaultTotemFeatures.absorption.enabled) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, absorptionEffectDuration, absorptionEffectAmplifier));
        }
        newTotemFeatures.customEffects.forEach(customEffect -> {
            try {
                ResourceKey<DamageType> damageType = BTUUtils.getDamageTypeByKey(customEffect.damageType, (ServerLevel)livingEntity.m_9236_());
                MobEffect mobEffect = RegistryUtils.getMobEffectByKey((String)customEffect.effect);
                if ("any".equals(customEffect.damageType) || damageType != null && damageSource.m_276093_(damageType)) {
                    livingEntity.m_7292_(new MobEffectInstance(mobEffect, customEffect.duration, customEffect.amplifier));
                }
            }
            catch (Exception e) {
                BTUConstants.LOGGER.error("Better Totem of Undying error: Couldn't apply custom effect: {}", customEffect, (Object)e);
            }
        });
    }

    public static ResourceKey<DamageType> getDamageTypeByKey(String key, ServerLevel level) {
        if (!key.equals("any")) {
            Registry damageTypeRegistry = level.m_9598_().m_175515_(Registries.f_268580_);
            return damageTypeRegistry.m_7854_((Object)Objects.requireNonNull((DamageType)damageTypeRegistry.m_7745_(new ResourceLocation(key)))).orElse(null);
        }
        return null;
    }

    public static void destroyBlocksWhenSuffocatingOrFullyFrozen(@NotNull LivingEntity livingEntity, Level level) {
        if (BTUUtils.isInWallOrFullyFrozen(livingEntity)) {
            BlockPos blockPos = livingEntity.m_20183_();
            BlockState blockAtEntityPos = level.m_8055_(blockPos);
            BlockState blockAboveEntityPos = level.m_8055_(blockPos.m_7494_());
            if (BTUUtils.canDestroy(blockAtEntityPos)) {
                level.m_46961_(blockPos, true);
            }
            if (BTUUtils.canDestroy(blockAboveEntityPos)) {
                level.m_46961_(blockPos.m_7494_(), true);
            }
            int distance = 2;
            while (BTUUtils.isInstanceOfFallingBlock(blockPos, level, distance) && BTUUtils.canDestroy(level.m_8055_(blockPos.m_6630_(distance)))) {
                level.m_46961_(blockPos.m_6630_(distance), true);
                ++distance;
            }
        }
    }

    public static boolean isInWallOrFullyFrozen(@NotNull LivingEntity livingEntity) {
        return livingEntity.m_5830_() && BTUUtils.btuConfigs.newTotemFeatures.destroyBlocks.whenSuffocating || livingEntity.m_146890_() && BTUUtils.btuConfigs.newTotemFeatures.destroyBlocks.whenFullyFrozen;
    }

    public static boolean canDestroy(@NotNull BlockState block) {
        return BTUUtils.btuConfigs.newTotemFeatures.destroyBlocks.totemCantDestroy.stream().noneMatch(block1 -> block1.block.equals(BuiltInRegistries.f_256975_.m_7981_((Object)block.m_60734_()).toString())) && !block.m_60713_(Blocks.f_50752_) && !block.m_60713_(Blocks.f_50258_);
    }

    public static boolean isInstanceOfFallingBlock(@NotNull BlockPos pos, @NotNull Level level, int distance) {
        return level.m_8055_(pos.m_6630_(distance)).m_60734_() instanceof FallingBlock;
    }

    public static void knockbackMobsAway(LivingEntity livingEntity, Level level) {
        if (BTUUtils.btuConfigs.newTotemFeatures.knockbackMobs.enabled) {
            List<LivingEntity> nearbyEntities = BTUUtils.getNearbyEntities(livingEntity, level, BTUUtils.btuConfigs.newTotemFeatures.knockbackMobs.radius);
            double strength = BTUUtils.btuConfigs.newTotemFeatures.knockbackMobs.strength;
            for (LivingEntity entity : nearbyEntities) {
                entity.m_147240_(strength, livingEntity.m_20185_() - entity.m_20185_(), livingEntity.m_20189_() - entity.m_20189_());
            }
        }
    }

    @NotNull
    public static List<LivingEntity> getNearbyEntities(@NotNull LivingEntity livingEntity, @NotNull Level level, double radius) {
        return level.m_6443_(LivingEntity.class, livingEntity.m_20191_().m_82400_(radius), livingEntity1 -> livingEntity1 != livingEntity);
    }

    public static void teleportOutOfVoid(LivingEntity livingEntity, Level level, DamageSource damageSource) {
        if (BTUUtils.isInVoid(livingEntity, damageSource)) {
            BlockPos lastBlockPos = ((ILivingEntityMixin)livingEntity).btu_getLastBlockPos();
            BlockPos positionNearby = BTUUtils.randomTeleportNearby(livingEntity, level, lastBlockPos);
            if (positionNearby == null) {
                livingEntity.m_6021_((double)lastBlockPos.m_123341_(), (double)(level.m_151558_() + BTUUtils.btuConfigs.newTotemFeatures.teleportOutOfVoid.teleportHeightOffset), (double)lastBlockPos.m_123343_());
            }
            BTUUtils.setFallDamageImmune(livingEntity);
        }
    }

    public static BlockPos randomTeleportNearby(LivingEntity livingEntity, Level level, BlockPos blockPos) {
        BlockPos teleportPos = null;
        for (int i = 0; i < 16; ++i) {
            double x = (double)blockPos.m_123341_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 16.0;
            double y = Mth.m_14008_((double)((double)blockPos.m_123342_() + (double)(livingEntity.m_217043_().m_188503_(16) - 8)), (double)level.m_141937_(), (double)(level.m_151558_() - 1));
            double z = (double)blockPos.m_123343_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 16.0;
            BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
            if (!livingEntity.m_20984_(x, y, z, true)) continue;
            teleportPos = pos;
            break;
        }
        return teleportPos;
    }

    public static void setFallDamageImmune(LivingEntity livingEntity) {
        ((ILivingEntityMixin)livingEntity).btu_setFallDamageImmune(true);
    }

    public static void resetFallDamageImmune(LivingEntity livingEntity) {
        if (((ILivingEntityMixin)livingEntity).btu_isFallDamageImmune()) {
            boolean canPlayerFly = false;
            boolean isInWater = livingEntity.m_20069_();
            boolean isInCobweb = livingEntity.m_9236_().m_8055_(livingEntity.m_20183_()).m_60734_().equals(Blocks.f_50033_);
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                if (player.m_150110_().f_35935_ || player.m_150110_().f_35936_) {
                    canPlayerFly = true;
                }
            }
            if (canPlayerFly || isInWater || isInCobweb) {
                ((ILivingEntityMixin)livingEntity).btu_setFallDamageImmune(false);
            }
        }
    }
}

