/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.forge.gametest;

import com.almostreliable.lootjs.core.ILootContextData;
import com.almostreliable.lootjs.core.LootEntry;
import com.almostreliable.lootjs.forge.gametest.GameTestUtils;
import com.almostreliable.lootjs.loot.action.AddLootAction;
import com.almostreliable.lootjs.loot.action.RemoveLootAction;
import com.almostreliable.lootjs.loot.action.ReplaceLootAction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.PrefixGameTestTemplate;

@GameTestHolder(value="lootjs")
@PrefixGameTestTemplate(value=false)
public class LootActionGameTests {
    @GameTest(m_177046_="empty_test_structure")
    public void addLootAction(GameTestHelper helper) {
        helper.m_177279_(() -> {
            Player p = helper.m_177368_();
            LootContext ctx = GameTestUtils.chestContext(helper.m_177100_(), p.m_20182_(), p);
            ILootContextData data = GameTestUtils.fillExampleLoot(ctx);
            GameTestUtils.assertFalse(helper, data.getGeneratedLoot().stream().anyMatch(i -> i.m_41720_().equals(Items.f_42410_)), "Should contains no apples");
            GameTestUtils.assertFalse(helper, data.getGeneratedLoot().stream().anyMatch(i -> i.m_41720_().equals(Items.f_42778_)), "Should contains no lanterns");
            AddLootAction action = new AddLootAction(new LootEntry[]{new LootEntry(Items.f_42410_), new LootEntry(Items.f_42778_)});
            action.applyLootHandler(ctx, data.getGeneratedLoot());
            GameTestUtils.assertTrue(helper, data.getGeneratedLoot().stream().anyMatch(i -> i.m_41720_().equals(Items.f_42410_)), "Should contains apples now");
            GameTestUtils.assertTrue(helper, data.getGeneratedLoot().stream().anyMatch(i -> i.m_41720_().equals(Items.f_42778_)), "Should contains lanterns now");
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void removeLootAction(GameTestHelper helper) {
        helper.m_177279_(() -> {
            Player p = helper.m_177368_();
            LootContext ctx = GameTestUtils.chestContext(helper.m_177100_(), p.m_20182_(), p);
            ILootContextData data = GameTestUtils.fillExampleLoot(ctx);
            RemoveLootAction action = new RemoveLootAction(i -> i.m_41720_().equals(Items.f_42415_));
            action.applyLootHandler(ctx, data.getGeneratedLoot());
            GameTestUtils.assertFalse(helper, data.getGeneratedLoot().stream().anyMatch(i -> i.m_41720_().equals(Items.f_42415_)), "Diamond does not exist anymore");
            GameTestUtils.assertTrue(helper, data.getGeneratedLoot().size() == 2, "2 items in loot pool after removing diamond");
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void replaceLootAction(GameTestHelper helper) {
        helper.m_177279_(() -> {
            Player p = helper.m_177368_();
            LootContext ctx = GameTestUtils.chestContext(helper.m_177100_(), p.m_20182_(), p);
            ILootContextData data = GameTestUtils.fillExampleLoot(ctx);
            GameTestUtils.assertTrue(helper, data.getGeneratedLoot().stream().anyMatch(i -> i.m_41720_().equals(Items.f_42415_)), "Diamond exist");
            GameTestUtils.assertFalse(helper, data.getGeneratedLoot().stream().anyMatch(i -> i.m_41720_().equals(Items.f_42542_)), "Magma cream does not exist currently");
            ReplaceLootAction action = new ReplaceLootAction(i -> i.m_41720_().equals(Items.f_42415_), new LootEntry(Items.f_42542_), false);
            action.applyLootHandler(ctx, data.getGeneratedLoot());
            GameTestUtils.assertFalse(helper, data.getGeneratedLoot().stream().anyMatch(i -> i.m_41720_().equals(Items.f_42415_)), "Diamond does not exist anymore");
            GameTestUtils.assertTrue(helper, data.getGeneratedLoot().stream().anyMatch(i -> i.m_41720_().equals(Items.f_42542_)), "Magma cream exists now");
            GameTestUtils.assertTrue(helper, data.getGeneratedLoot().size() == 3, "still 3 items in loot pool");
        });
    }
}

