/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.botaniacombat.item.ranged;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabric_extras.ranged_weapon.api.CustomCrossbow;
import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3745;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.CustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class CrystalCrossbowItem
extends CustomCrossbow
implements CustomDamageItem {
    private static final int ARROW_COST = 200;

    public CrystalCrossbowItem(class_1792.class_1793 properties, Supplier<class_1856> repairIngredientSupplier, RangedConfig rangedConfig) {
        super(properties, repairIngredientSupplier);
        ((CustomRangedWeapon)this).configure(rangedConfig);
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 crossbowStack = player.method_5998(usedHand);
        if (CrystalCrossbowItem.method_7781((class_1799)crossbowStack)) {
            float shootingPower = CrystalCrossbowItem.method_7772((class_1799)crossbowStack, (class_1792)class_1802.field_8639) ? 1.6f : 3.15f;
            CrystalCrossbowItem.performShooting(level, (class_1309)player, usedHand, crossbowStack, shootingPower, 0.5f);
            class_1764.method_7782((class_1799)crossbowStack, (boolean)false);
            return class_1271.method_22428((Object)crossbowStack);
        }
        if (CrystalCrossbowItem.CanChargeWithMana(crossbowStack, player)) {
            if (!CrystalCrossbowItem.method_7781((class_1799)crossbowStack)) {
                player.method_6019(usedHand);
            }
            return class_1271.method_22428((Object)crossbowStack);
        }
        return class_1271.method_22431((Object)crossbowStack);
    }

    public void method_7840(@NotNull class_1799 crossbowStack, @NotNull class_1937 worldIn, class_1309 livingEntity, int timeCharged) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            int i = this.method_7881(crossbowStack) - timeCharged;
            float f = class_1764.method_7770((int)i, (class_1799)crossbowStack);
            if (f >= 1.0f && !CrystalCrossbowItem.method_7781((class_1799)crossbowStack) && CrystalCrossbowItem.tryLoadProjectiles(livingEntity, crossbowStack)) {
                CrystalCrossbowItem.method_7782((class_1799)crossbowStack, (boolean)true);
                worldIn.method_43128(player, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), class_3417.field_14626, class_3419.field_15248, 1.0f, 1.0f / (worldIn.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f);
            }
        }
    }

    private static boolean tryLoadProjectiles(@NotNull class_1309 itemUser, @NotNull class_1799 crossbowStack) {
        if (itemUser instanceof class_1657) {
            class_1657 playerentity = (class_1657)itemUser;
            int multishotLevel = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)crossbowStack);
            int arrowsToShoot = multishotLevel == 0 ? 1 : 3;
            boolean flag = CrystalCrossbowItem.CanChargeWithMana(crossbowStack, playerentity);
            class_1799 usedProjectileStack = null;
            class_1799 realProjectileStack = playerentity.method_18808(crossbowStack);
            class_1799 fakeProjectileStack = new class_1799((class_1935)class_1802.field_8107);
            if (flag) {
                usedProjectileStack = realProjectileStack.method_7960() || realProjectileStack.method_7909() == class_1802.field_8107 ? fakeProjectileStack : realProjectileStack;
                class_1799 multishotDummyAmmo = usedProjectileStack.method_7972();
                for (int i = 0; i < arrowsToShoot; ++i) {
                    if (i > 0) {
                        usedProjectileStack = multishotDummyAmmo.method_7972();
                    }
                    if (class_1764.method_7765((class_1309)itemUser, (class_1799)crossbowStack, (class_1799)usedProjectileStack, (i > 0 ? 1 : 0) != 0, (boolean)playerentity.method_7337())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static void performShooting(class_1937 level, class_1309 shooter, class_1268 usedHand, class_1799 crossbowStack, float velocity, float inaccuracy) {
        List list = class_1764.method_7785((class_1799)crossbowStack);
        float[] soundPitches = class_1764.method_7780((class_5819)shooter.method_6051());
        for (int i = 0; i < list.size(); ++i) {
            boolean creativeMode;
            class_1799 itemStack = (class_1799)list.get(i);
            boolean bl = creativeMode = shooter instanceof class_1657 && ((class_1657)shooter).method_7337();
            if (itemStack.method_7960()) continue;
            if (i == 0) {
                CrystalCrossbowItem.shootProjectile(level, shooter, usedHand, crossbowStack, itemStack, soundPitches[i], creativeMode, velocity, inaccuracy, 0.0f);
                continue;
            }
            if (i == 1) {
                CrystalCrossbowItem.shootProjectile(level, shooter, usedHand, crossbowStack, itemStack, soundPitches[i], creativeMode, velocity, inaccuracy, -15.0f);
                continue;
            }
            if (i != 2) continue;
            CrystalCrossbowItem.shootProjectile(level, shooter, usedHand, crossbowStack, itemStack, soundPitches[i], creativeMode, velocity, inaccuracy, 15.0f);
        }
        class_1764.method_7769((class_1937)level, (class_1309)shooter, (class_1799)crossbowStack);
    }

    private static void shootProjectile(class_1937 level, class_1309 shooter, class_1268 hand, class_1799 crossbowStack, class_1799 ammoStack, float soundPitch, boolean isCreativeMode, float velocity, float inaccuracy, float projectileAngle) {
        if (!level.method_8608()) {
            class_1665 projectile;
            boolean isFirework = ammoStack.method_31574(class_1802.field_8639);
            if (isFirework) {
                projectile = new class_1671(level, ammoStack, (class_1297)shooter, shooter.method_23317(), shooter.method_23320() - (double)0.15f, shooter.method_23321(), true);
            } else {
                projectile = class_1764.method_18814((class_1937)level, (class_1309)shooter, (class_1799)crossbowStack, (class_1799)ammoStack);
                if (isCreativeMode || projectileAngle != 0.0f || ammoStack.method_31574(class_1802.field_8107)) {
                    projectile.field_7572 = class_1665.class_1666.field_7594;
                }
            }
            if (shooter instanceof class_3745) {
                class_3745 crossbowAttackMob = (class_3745)shooter;
                crossbowAttackMob.method_18811(crossbowAttackMob.method_5968(), crossbowStack, (class_1676)projectile, projectileAngle);
            } else {
                class_243 up = shooter.method_18864(1.0f);
                class_243 view = shooter.method_5828(1.0f);
                Quaternionf angle = new Quaternionf().setAngleAxis((double)(projectileAngle * ((float)Math.PI / 180)), up.field_1352, up.field_1351, up.field_1350);
                Vector3f vector = view.method_46409().rotate((Quaternionfc)angle);
                projectile.method_7485((double)vector.x(), (double)vector.y(), (double)vector.z(), velocity, inaccuracy);
            }
            crossbowStack.method_7956(isFirework ? 3 : 1, shooter, livingEntity -> livingEntity.method_20236(hand));
            level.method_8649((class_1297)projectile);
            level.method_43128(null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), class_3417.field_15187, class_3419.field_15248, 1.0f, soundPitch);
        }
    }

    public <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
        boolean infinity = class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)stack) > 0;
        return ToolCommons.damageItemIfPossible((class_1799)stack, (int)amount, entity, (int)(200 / (infinity ? 2 : 1)));
    }

    private static boolean CanChargeWithMana(class_1799 stack, class_1657 player) {
        boolean infinity;
        boolean bl = infinity = class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)stack) > 0;
        return player.method_7337() || ManaItemHandler.instance().requestManaExactForTool(stack, player, 200 / (infinity ? 2 : 1), false);
    }
}

