/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castlemod.util;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.puffish.castlemod.util.Direction4XZ;
import net.puffish.castlemod.util.PositionXZ;

public class RelationsXZ<T> {
    private final List<List<T>> xAxis;
    private final List<List<T>> zAxis;

    public RelationsXZ(int sizeX, int sizeZ, Supplier<T> supplier) {
        this.xAxis = Stream.generate(() -> Stream.generate(supplier).limit(sizeZ).collect(Collectors.toList())).limit(sizeX + 1).toList();
        this.zAxis = Stream.generate(() -> Stream.generate(supplier).limit(sizeX).collect(Collectors.toList())).limit(sizeZ + 1).toList();
    }

    public T get(PositionXZ pos, Direction4XZ dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction4XZ.POSITIVE_X -> this.xAxis.get(pos.getX() + 1).get(pos.getZ());
            case Direction4XZ.POSITIVE_Z -> this.zAxis.get(pos.getZ() + 1).get(pos.getX());
            case Direction4XZ.NEGATIVE_X -> this.xAxis.get(pos.getX()).get(pos.getZ());
            case Direction4XZ.NEGATIVE_Z -> this.zAxis.get(pos.getZ()).get(pos.getX());
        };
    }

    public void set(PositionXZ pos, Direction4XZ dir, T value) {
        switch (dir) {
            case POSITIVE_X: {
                this.xAxis.get(pos.getX() + 1).set(pos.getZ(), value);
                break;
            }
            case POSITIVE_Z: {
                this.zAxis.get(pos.getZ() + 1).set(pos.getX(), value);
                break;
            }
            case NEGATIVE_X: {
                this.xAxis.get(pos.getX()).set(pos.getZ(), value);
                break;
            }
            case NEGATIVE_Z: {
                this.zAxis.get(pos.getZ()).set(pos.getX(), value);
            }
        }
    }
}

