/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castlemod.structure;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.puffish.castlemod.CastleMod;
import net.puffish.castlemod.generator.CastleRoomDoorsLayer;
import net.puffish.castlemod.generator.CastleRoomTemplate;
import net.puffish.castlemod.structure.RoomTemplate;
import net.puffish.castlemod.util.Direction4XZ;

public class StructureRoomTemplate
extends CastleRoomTemplate {
    private final ResourceLocation structure;

    private StructureRoomTemplate(int sizeX, int sizeY, int sizeZ, RoomTemplate roomTemplate) {
        super(sizeX, sizeY, sizeZ, roomTemplate.weight(), roomTemplate.minCount(), roomTemplate.maxCount());
        this.structure = roomTemplate.structure();
    }

    public static StructureRoomTemplate create(StructureTemplateManager manager, RoomTemplate roomTemplate) {
        StructureTemplate template = manager.m_230359_(roomTemplate.structure());
        StructureRoomTemplate structureRoomTemplate = new StructureRoomTemplate(template.m_163801_().m_123341_() / 6 + 1, template.m_163801_().m_123342_() / 5 + 1, template.m_163801_().m_123343_() / 6 + 1, roomTemplate);
        for (StructureTemplate.StructureBlockInfo sbi : template.m_74603_(BlockPos.f_121853_, new StructurePlaceSettings(), Blocks.f_50678_)) {
            if (!CastleMod.createIdentifier("door").equals((Object)new ResourceLocation(sbi.f_74677_().m_128461_("name")))) continue;
            CastleRoomDoorsLayer layer = structureRoomTemplate.getDoors().getLayer(sbi.f_74675_().m_123342_() / 5);
            switch (JigsawBlock.m_54250_((BlockState)sbi.f_74676_())) {
                case NORTH: {
                    layer.setSide(Direction4XZ.NEGATIVE_Z, sbi.f_74675_().m_123341_() / 6, true);
                    break;
                }
                case SOUTH: {
                    layer.setSide(Direction4XZ.POSITIVE_Z, structureRoomTemplate.getSizeX() - 1 - sbi.f_74675_().m_123341_() / 6, true);
                    break;
                }
                case WEST: {
                    layer.setSide(Direction4XZ.NEGATIVE_X, structureRoomTemplate.getSizeZ() - 1 - sbi.f_74675_().m_123343_() / 6, true);
                    break;
                }
                case EAST: {
                    layer.setSide(Direction4XZ.POSITIVE_X, sbi.f_74675_().m_123343_() / 6, true);
                }
            }
        }
        return structureRoomTemplate;
    }

    public ResourceLocation getStructure() {
        return this.structure;
    }
}

