/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castlemod.structure;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.puffish.castlemod.CastleMod;
import net.puffish.castlemod.util.MirrorXZ;
import net.puffish.castlemod.util.Rotation4XZ;

public class CastlePiece
extends TemplateStructurePiece {
    private final Holder<StructureProcessorList> processors;

    private CastlePiece(StructureTemplateManager manager, ResourceLocation id, StructurePlaceSettings placementData, BlockPos pos, Holder<StructureProcessorList> processors) {
        super(CastleMod.CASTLE_STRUCTURE_PIECE_TYPE, 0, manager, id, id.toString(), placementData, pos);
        this.processors = processors;
        ((StructureProcessorList)this.processors.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)this.f_73657_).m_74383_(arg_0));
    }

    public CastlePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
        super(CastleMod.CASTLE_STRUCTURE_PIECE_TYPE, nbt, context.f_226956_(), identifier -> new StructurePlaceSettings().m_74377_(Mirror.valueOf((String)nbt.m_128461_("Mi"))).m_74379_(Rotation.valueOf((String)nbt.m_128461_("Rot"))));
        this.processors = StructureProcessorType.f_74468_.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)context.f_192763_()), (Object)nbt.m_128469_("Procs")).result().orElseGet(() -> Holder.m_205709_((Object)new StructureProcessorList(List.of())));
        ((StructureProcessorList)this.processors.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)this.f_73657_).m_74383_(arg_0));
    }

    public static CastlePiece create(StructureTemplateManager manager, ResourceLocation id, Holder<StructureProcessorList> processors, BlockPos pos, MirrorXZ mir, Rotation4XZ rot) {
        StructurePlaceSettings placementData = CastlePiece.calculatePlacementData(mir, rot);
        return new CastlePiece(manager, id, placementData, CastlePiece.calculatePos(manager.m_230359_(id), placementData, pos), processors);
    }

    private static StructurePlaceSettings calculatePlacementData(MirrorXZ mir, Rotation4XZ rot) {
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings();
        StructurePlaceSettings structurePlaceSettings2 = structurePlaceSettings.m_74377_(switch (mir) {
            default -> throw new IncompatibleClassChangeError();
            case MirrorXZ.NONE -> Mirror.NONE;
            case MirrorXZ.ALONG_X -> Mirror.LEFT_RIGHT;
            case MirrorXZ.ALONG_Z -> Mirror.FRONT_BACK;
        });
        return structurePlaceSettings2.m_74379_(switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation4XZ.DEGREES_0 -> Rotation.NONE;
            case Rotation4XZ.DEGREES_90 -> Rotation.CLOCKWISE_90;
            case Rotation4XZ.DEGREES_180 -> Rotation.CLOCKWISE_180;
            case Rotation4XZ.DEGREES_270 -> Rotation.COUNTERCLOCKWISE_90;
        });
    }

    private static BlockPos calculatePos(StructureTemplate template, StructurePlaceSettings placementData, BlockPos pos) {
        int x = template.m_163801_().m_123341_() / (placementData.m_74401_() == Mirror.FRONT_BACK ? -2 : 2);
        int z = template.m_163801_().m_123343_() / (placementData.m_74401_() == Mirror.LEFT_RIGHT ? -2 : 2);
        return switch (placementData.m_74404_()) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> new BlockPos(pos.m_123341_() - x, pos.m_123342_(), pos.m_123343_() - z);
            case Rotation.CLOCKWISE_90 -> new BlockPos(pos.m_123341_() + z, pos.m_123342_(), pos.m_123343_() - x);
            case Rotation.CLOCKWISE_180 -> new BlockPos(pos.m_123341_() + x, pos.m_123342_(), pos.m_123343_() + z);
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(pos.m_123341_() - z, pos.m_123342_(), pos.m_123343_() + x);
        };
    }

    public void m_213694_(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
        super.m_213694_(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, pivot);
        for (StructureTemplate.StructureBlockInfo sbi : this.f_73656_.m_74603_(this.f_73658_, this.f_73657_, Blocks.f_50678_)) {
            ServerLevel serverWorld = world.m_6018_();
            StructureTemplateManager manager = serverWorld.m_215082_();
            StructureTemplate st = new StructureTemplate();
            st.f_74482_.clear();
            st.f_74482_.add(new StructureTemplate.Palette(List.of(new StructureTemplate.StructureBlockInfo(BlockPos.f_121853_, sbi.f_74676_(), sbi.f_74677_()))));
            SinglePoolElement spe = new SinglePoolElement(Either.right((Object)st), Holder.m_205709_((Object)new StructureProcessorList(List.of())), StructureTemplatePool.Projection.RIGID);
            PoolElementStructurePiece psp = new PoolElementStructurePiece(manager, (StructurePoolElement)spe, sbi.f_74675_(), 1, Rotation.NONE, new BoundingBox(sbi.f_74675_()));
            ArrayList pieces = new ArrayList();
            JigsawPlacement.m_227210_((RandomState)serverWorld.m_7726_().m_214994_(), (int)7, (boolean)false, (ChunkGenerator)chunkGenerator, (StructureTemplateManager)manager, (LevelHeightAccessor)world, (RandomSource)random, (Registry)world.m_9598_().m_175515_(Registries.f_256948_), (PoolElementStructurePiece)psp, pieces, (VoxelShape)Shapes.f_83036_);
            for (PoolElementStructurePiece piece : pieces) {
                piece.m_226509_(world, structureAccessor, chunkGenerator, random, BoundingBox.m_71044_(), sbi.f_74675_(), false);
            }
        }
    }

    protected void m_213704_(String metadata, BlockPos pos, ServerLevelAccessor world, RandomSource random, BoundingBox boundingBox) {
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
        super.m_183620_(context, nbt);
        nbt.m_128359_("Mi", this.f_73657_.m_74401_().name());
        nbt.m_128359_("Rot", this.f_73657_.m_74404_().name());
        StructureProcessorType.f_74468_.encodeStart((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)context.f_192763_()), this.processors).result().ifPresent(nbtElement -> nbt.m_128365_("Procs", nbtElement));
    }
}

