/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castlemod.generator;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.puffish.castlemod.generator.CastleMetrics;
import net.puffish.castlemod.util.Direction4XZ;
import net.puffish.castlemod.util.PositionXZ;

public class CastleLayerMetrics
extends CastleMetrics {
    private int negativeXCut;
    private int negativeZCut;
    private int positiveXCut;
    private int positiveZCut;

    private CastleLayerMetrics(int sizeX, int sizeZ, int negativeXCut, int negativeZCut, int positiveXCut, int positiveZCut) {
        super(sizeX, sizeZ);
        this.negativeXCut = negativeXCut;
        this.negativeZCut = negativeZCut;
        this.positiveXCut = positiveXCut;
        this.positiveZCut = positiveZCut;
    }

    public CastleLayerMetrics(CastleMetrics metrics) {
        this(metrics.sizeX, metrics.sizeZ, 0, 0, 0, 0);
    }

    public CastleLayerMetrics cut(Direction4XZ dir) {
        switch (dir) {
            case POSITIVE_X: {
                ++this.positiveXCut;
                break;
            }
            case POSITIVE_Z: {
                ++this.positiveZCut;
                break;
            }
            case NEGATIVE_X: {
                ++this.negativeXCut;
                break;
            }
            case NEGATIVE_Z: {
                ++this.negativeZCut;
            }
        }
        return this;
    }

    @Override
    public CastleLayerMetrics copy() {
        return new CastleLayerMetrics(this.sizeX, this.sizeZ, this.negativeXCut, this.negativeZCut, this.positiveXCut, this.positiveZCut);
    }

    public boolean isSmall() {
        return this.getCutSizeX() <= 2 && this.getCutSizeZ() <= 2;
    }

    public boolean isValid() {
        return this.getCutSizeX() >= 2 && this.getCutSizeZ() >= 2;
    }

    public boolean isOutsideCutBounds(PositionXZ pos) {
        return pos.getX() < this.negativeXCut || pos.getZ() < this.negativeZCut || pos.getX() >= this.sizeX - this.positiveXCut || pos.getZ() >= this.sizeZ - this.positiveZCut;
    }

    public boolean isAdjacentToCutBoundsEdges(PositionXZ pos) {
        if (pos.getX() == this.negativeXCut - 1 || pos.getX() == this.sizeX - this.positiveXCut) {
            return pos.getZ() >= this.negativeZCut && pos.getZ() < this.sizeZ - this.positiveZCut;
        }
        if (pos.getZ() == this.negativeZCut - 1 || pos.getZ() == this.sizeZ - this.positiveZCut) {
            return pos.getX() >= this.negativeXCut && pos.getX() < this.sizeX - this.positiveXCut;
        }
        return false;
    }

    public Stream<PositionXZ> streamPositionsInCutBounds() {
        return this.streamPositionsInCustomBounds(this.negativeXCut, this.sizeX - this.positiveXCut, this.negativeZCut, this.sizeZ - this.positiveZCut);
    }

    public Stream<PositionXZ> streamPositionsOnCutEdge(Direction4XZ dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction4XZ.POSITIVE_X -> IntStream.range(this.negativeZCut, this.sizeZ - this.positiveZCut).mapToObj(z -> new PositionXZ(this.sizeX - this.positiveXCut - 1, z));
            case Direction4XZ.POSITIVE_Z -> IntStream.range(this.negativeXCut, this.sizeX - this.positiveXCut).mapToObj(x -> new PositionXZ(x, this.sizeZ - this.positiveZCut - 1));
            case Direction4XZ.NEGATIVE_X -> IntStream.range(this.negativeZCut, this.sizeZ - this.positiveZCut).mapToObj(z -> new PositionXZ(this.negativeXCut, z));
            case Direction4XZ.NEGATIVE_Z -> IntStream.range(this.negativeXCut, this.sizeX - this.positiveXCut).mapToObj(x -> new PositionXZ(x, this.negativeZCut));
        };
    }

    public int getCutSizeX() {
        return this.sizeX - this.positiveXCut - this.negativeXCut;
    }

    public int getCutSizeZ() {
        return this.sizeZ - this.positiveZCut - this.negativeZCut;
    }

    public int getNegativeXCut() {
        return this.negativeXCut;
    }

    public int getNegativeZCut() {
        return this.negativeZCut;
    }

    public int getPositiveXCut() {
        return this.positiveXCut;
    }

    public int getPositiveZCut() {
        return this.positiveZCut;
    }
}

