/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.etl.mixin;

import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.LightTexture;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import xyz.kohara.etl.Config;

@Mixin(value={LightTexture.class})
public abstract class RecolorLigthmapMixin {
    @Unique
    private static final Supplier<Double> etl$undergroundLightAmount = Config.UNDERGROUND_LIGHT_AMOUNT;
    @Unique
    private static final Supplier<Double> etl$fullMoonLightAmount = Config.FULL_MOON;
    @Unique
    private static final Supplier<Double> etl$waningWaxingMoonLightAmount = Config.WANING_WAXING_MOON;
    @Unique
    private static final Supplier<Double> etl$quarterMoonLightAmount = Config.QUARTER_MOON;
    @Unique
    private static final Supplier<Double> etl$crescentMoonLightAmount = Config.CRESCENT_MOON;
    @Unique
    private static final Supplier<Double> etl$newMoonLightAmount = Config.UNDERGROUND_LIGHT_AMOUNT;

    @Shadow
    private static void m_252983_(Vector3f pColor) {
    }

    @Unique
    private int etl$lightLevel(int block, int sky) {
        return Math.max(sky, block);
    }

    @Unique
    private float etl$getSunTransition(int timeOfDay) {
        if (timeOfDay >= 12040 && timeOfDay <= 13670) {
            float t = (float)(timeOfDay - 12040) / 1630.0f;
            return 1.0f - t;
        }
        if (timeOfDay >= 22331 && timeOfDay <= 23961) {
            return (float)(timeOfDay - 22331) / 1630.0f;
        }
        if (timeOfDay > 13670 && timeOfDay < 22331) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Unique
    private boolean etl$isNight(int time) {
        return time >= 12040 && time <= 23961;
    }

    @Unique
    private Vector3f etl$getMoonPhaseMultiplier(int phase) {
        float col = etl$fullMoonLightAmount.get().floatValue();
        switch (phase) {
            case 1: 
            case 7: {
                col = etl$waningWaxingMoonLightAmount.get().floatValue();
                break;
            }
            case 2: 
            case 6: {
                col = etl$quarterMoonLightAmount.get().floatValue();
                break;
            }
            case 3: 
            case 5: {
                col = etl$crescentMoonLightAmount.get().floatValue();
                break;
            }
            case 4: {
                col = etl$newMoonLightAmount.get().floatValue();
            }
        }
        return new Vector3f(col, col, col);
    }

    @Inject(method={"updateLightTexture"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LightTexture;clampColor(Lorg/joml/Vector3f;)V", shift=At.Shift.BEFORE, ordinal=2)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void recolorLight(float pPartialTicks, CallbackInfo ci, ClientLevel clientlevel, float f, float f1, float f2, float f3, float f4, float f6, float f5, Vector3f vector3f, float f7, Vector3f vector3f1, int i, int j, float f8, float f9, float f10, float f11, boolean flag, float f14, Vector3f vector3f5) throws CloneNotSupportedException {
        int blocklight = j;
        int skylight = i;
        float nightVisScale = f5;
        int time = Math.toIntExact(clientlevel.m_46468_() % 24000L);
        Vector3f warmTint = new Vector3f(0.36f, 0.13f, -0.15f);
        float warmness = (float)blocklight / 15.0f * (1.0f - vector3f.x() * (1.0f - (float)skylight / 15.0f)) * Math.min((float)(15 - blocklight) / 9.0f, 1.0f);
        warmTint.mul(warmness);
        warmTint.add(1.0f, 1.0f, 1.0f);
        vector3f1.mul((Vector3fc)warmTint);
        if (blocklight != 15) {
            Vector3f dramaticFactor = (Vector3f)vector3f1.clone();
            dramaticFactor.mul(0.2f);
            dramaticFactor.add(0.8f, 0.8f, 0.8f);
            vector3f1.mul((Vector3fc)dramaticFactor);
            if (this.etl$isNight(time) && clientlevel.m_104583_().m_108883_() == DimensionSpecialEffects.SkyType.NORMAL) {
                Vector3f nightDarkness = new Vector3f(1.0f, 1.0f, 1.0f);
                float darkness = Math.max(Math.max((float)blocklight / 15.0f, this.etl$getSunTransition(time)), nightVisScale);
                nightDarkness.mul(darkness);
                nightDarkness.add((Vector3fc)this.etl$getMoonPhaseMultiplier(clientlevel.m_46941_()));
                RecolorLigthmapMixin.m_252983_(nightDarkness);
                vector3f1.mul((Vector3fc)nightDarkness);
            }
        }
        if (skylight != 15) {
            Vector3f caveDarkness = new Vector3f(1.0f, 1.0f, 1.0f);
            float darkness = Math.max((float)this.etl$lightLevel(blocklight, skylight) / 15.0f, nightVisScale);
            caveDarkness.mul(darkness);
            float undergroundLightAmount = etl$undergroundLightAmount.get().floatValue();
            caveDarkness.add(undergroundLightAmount, undergroundLightAmount, undergroundLightAmount);
            RecolorLigthmapMixin.m_252983_(caveDarkness);
            vector3f1.mul((Vector3fc)caveDarkness);
        }
    }
}

