/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;

public class SerializationUtil {
    public static final int COMPOUND_TAG_TYPE = 10;
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";

    public static ListTag serializeItemList(List<ItemStack> items) {
        ListTag itemList = new ListTag();
        items.forEach(itemstack -> itemList.add((Object)itemstack.serializeNBT()));
        return itemList;
    }

    public static List<ItemStack> deserializeItemList(CompoundTag compoundTag, String tag) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (compoundTag.m_128441_(tag)) {
            ListTag itemList = compoundTag.m_128437_(tag, 10);
            for (int i = 0; i < itemList.size(); ++i) {
                itemStacks.add(ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i)));
            }
            return itemStacks;
        }
        return itemStacks;
    }

    public static ListTag serializeTagList(List<CompoundTag> tags) {
        ListTag tagList = new ListTag();
        tagList.addAll(tags);
        return tagList;
    }

    public static <T> List<T> mapFromTags(ListTag tagList, Function<CompoundTag, T> transformer) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < tagList.size(); ++i) {
            list.add(transformer.apply(tagList.m_128728_(i)));
        }
        return list;
    }

    public static ListTag serializeBlockPosList(List<BlockPos> blockPositions) {
        ListTag serializedBlockPositions = new ListTag();
        blockPositions.forEach(blockPos -> serializedBlockPositions.add((Object)SerializationUtil.serializeBlockPos(blockPos)));
        return serializedBlockPositions;
    }

    public static CompoundTag serializeBlockPos(BlockPos blockPos) {
        CompoundTag serializedBlockPos = new CompoundTag();
        serializedBlockPos.m_128405_(X, blockPos.m_123341_());
        serializedBlockPos.m_128405_(Y, blockPos.m_123342_());
        serializedBlockPos.m_128405_(Z, blockPos.m_123343_());
        return serializedBlockPos;
    }

    public static List<BlockPos> deserializeBlockPosList(CompoundTag tag, String key) {
        ListTag serializedBlockPositions = tag.m_128437_(key, 10);
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int i = 0; i < serializedBlockPositions.size(); ++i) {
            blockPositions.add(SerializationUtil.deserializeBlockPos(serializedBlockPositions.m_128728_(i)));
        }
        return blockPositions;
    }

    public static BlockPos deserializeBlockPos(CompoundTag serializedBlockPosition) {
        return new BlockPos(serializedBlockPosition.m_128451_(X), serializedBlockPosition.m_128451_(Y), serializedBlockPosition.m_128451_(Z));
    }
}

