/*
 * Decompiled with CFR 0.152.
 */
package me.cael.capes.render;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.cael.capes.Capes;
import me.cael.capes.handler.PlayerHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u00106\u001a\u0004\u0018\u00010/J\u0006\u00107\u001a\u00020/J\u0006\u00108\u001a\u00020/J\u0006\u00109\u001a\u00020:R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0011\"\u0004\b\"\u0010\u0013R\u001a\u0010#\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0006\"\u0004\b%\u0010\bR\u001a\u0010&\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0006\"\u0004\b(\u0010\bR\u001a\u0010)\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0006\"\u0004\b+\u0010\bR\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u001d\"\u0004\b2\u0010\u001fR\u001a\u00103\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0011\"\u0004\b5\u0010\u0013\u00a8\u0006;"}, d2={"Lme/cael/capes/render/PlaceholderEntity;", "", "()V", "capeLoaded", "", "getCapeLoaded", "()Z", "setCapeLoaded", "(Z)V", "gameProfile", "Lcom/mojang/authlib/GameProfile;", "kotlin.jvm.PlatformType", "getGameProfile", "()Lcom/mojang/authlib/GameProfile;", "lastLimbDistance", "", "getLastLimbDistance", "()F", "setLastLimbDistance", "(F)V", "limbAngle", "getLimbAngle", "setLimbAngle", "limbDistance", "getLimbDistance", "setLimbDistance", "prevX", "", "getPrevX", "()D", "setPrevX", "(D)V", "prevYaw", "getPrevYaw", "setPrevYaw", "showBody", "getShowBody", "setShowBody", "showElytra", "getShowElytra", "setShowElytra", "slim", "getSlim", "setSlim", "textures", "Ljava/util/EnumMap;", "Lcom/mojang/authlib/minecraft/MinecraftProfileTexture$Type;", "Lnet/minecraft/util/Identifier;", "x", "getX", "setX", "yaw", "getYaw", "setYaw", "getCapeTexture", "getElytraTexture", "getSkinTexture", "updateLimbs", "", "capes"})
public final class PlaceholderEntity {
    @NotNull
    public static final PlaceholderEntity INSTANCE = new PlaceholderEntity();
    @NotNull
    private static final EnumMap<MinecraftProfileTexture.Type, ResourceLocation> textures;
    private static final GameProfile gameProfile;
    private static boolean slim;
    private static boolean showBody;
    private static boolean showElytra;
    private static boolean capeLoaded;
    private static float limbDistance;
    private static float lastLimbDistance;
    private static float limbAngle;
    private static float yaw;
    private static float prevYaw;
    private static double x;
    private static double prevX;

    private PlaceholderEntity() {
    }

    public final GameProfile getGameProfile() {
        return gameProfile;
    }

    public final boolean getSlim() {
        return slim;
    }

    public final void setSlim(boolean bl) {
        slim = bl;
    }

    public final boolean getShowBody() {
        return showBody;
    }

    public final void setShowBody(boolean bl) {
        showBody = bl;
    }

    public final boolean getShowElytra() {
        return showElytra;
    }

    public final void setShowElytra(boolean bl) {
        showElytra = bl;
    }

    public final boolean getCapeLoaded() {
        return capeLoaded;
    }

    public final void setCapeLoaded(boolean bl) {
        capeLoaded = bl;
    }

    public final float getLimbDistance() {
        return limbDistance;
    }

    public final void setLimbDistance(float f) {
        limbDistance = f;
    }

    public final float getLastLimbDistance() {
        return lastLimbDistance;
    }

    public final void setLastLimbDistance(float f) {
        lastLimbDistance = f;
    }

    public final float getLimbAngle() {
        return limbAngle;
    }

    public final void setLimbAngle(float f) {
        limbAngle = f;
    }

    public final float getYaw() {
        return yaw;
    }

    public final void setYaw(float f) {
        yaw = f;
    }

    public final float getPrevYaw() {
        return prevYaw;
    }

    public final void setPrevYaw(float f) {
        prevYaw = f;
    }

    public final double getX() {
        return x;
    }

    public final void setX(double d) {
        x = d;
    }

    public final double getPrevX() {
        return prevX;
    }

    public final void setPrevX(double d) {
        prevX = d;
    }

    public final void updateLimbs() {
        lastLimbDistance = limbDistance;
        double d = x - prevX;
        float g = (float)Math.sqrt(d * d) * 4.0f;
        if (g > 1.0f) {
            g = 1.0f;
        }
        limbDistance += (g - limbDistance) * 0.4f;
        limbAngle += limbDistance;
    }

    @Nullable
    public final ResourceLocation getCapeTexture() {
        if (!capeLoaded) {
            capeLoaded = true;
            GameProfile gameProfile = PlaceholderEntity.gameProfile;
            Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"gameProfile");
            PlayerHandler.Companion.onLoadTexture(gameProfile);
        }
        GameProfile gameProfile = PlaceholderEntity.gameProfile;
        Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"gameProfile");
        PlayerHandler handler = PlayerHandler.Companion.fromProfile(gameProfile);
        return handler.getHasCape() ? handler.getCape() : textures.get(MinecraftProfileTexture.Type.CAPE);
    }

    @NotNull
    public final ResourceLocation getElytraTexture() {
        GameProfile gameProfile = PlaceholderEntity.gameProfile;
        Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"gameProfile");
        PlayerHandler handler = PlayerHandler.Companion.fromProfile(gameProfile);
        ResourceLocation capeTexture = this.getCapeTexture();
        return handler.getHasElytraTexture() && Capes.INSTANCE.getCONFIG().getEnableElytraTexture() && capeTexture != null ? capeTexture : new ResourceLocation("textures/entity/elytra.png");
    }

    @NotNull
    public final ResourceLocation getSkinTexture() {
        ResourceLocation resourceLocation = textures.getOrDefault(MinecraftProfileTexture.Type.SKIN, DefaultPlayerSkin.m_118626_());
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"textures.getOrDefault(Mi\u2026tSkinHelper.getTexture())");
        return resourceLocation;
    }

    private static final void _init_$lambda$0(MinecraftProfileTexture.Type type, ResourceLocation identifier, MinecraftProfileTexture texture) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        ((Map)textures).put(type, identifier);
        if (type == MinecraftProfileTexture.Type.SKIN) {
            slim = Intrinsics.areEqual((Object)texture.getMetadata("model"), (Object)"slim");
        }
    }

    static {
        EnumMap enumMap = Maps.newEnumMap(MinecraftProfileTexture.Type.class);
        Intrinsics.checkNotNullExpressionValue((Object)enumMap, (String)"newEnumMap(MinecraftProf\u2026Texture.Type::class.java)");
        textures = enumMap;
        gameProfile = Minecraft.m_91087_().m_91094_().m_92548_();
        showBody = true;
        Minecraft.m_91087_().m_91109_().m_118817_(gameProfile, PlaceholderEntity::_init_$lambda$0, true);
    }
}

