/*
 * Decompiled with CFR 0.152.
 */
package me.cael.capes.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.cael.capes.render.PlaceholderEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017J\b\u0010!\u001a\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lme/cael/capes/render/DisplayPlayerEntityRenderer;", "Lnet/minecraft/client/render/entity/LivingEntityRenderer;", "Lnet/minecraft/entity/LivingEntity;", "Lnet/minecraft/client/render/entity/model/PlayerEntityModel;", "ctx", "Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;", "slim", "", "(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;Z)V", "getCtx", "()Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;", "elytra", "Lnet/minecraft/client/render/entity/model/ElytraEntityModel;", "getElytra", "()Lnet/minecraft/client/render/entity/model/ElytraEntityModel;", "getTexture", "Lnet/minecraft/util/Identifier;", "entity", "render", "", "livingEntity", "Lme/cael/capes/render/PlaceholderEntity;", "tickDelta", "", "matrixStack", "Lnet/minecraft/client/util/math/MatrixStack;", "vertexConsumerProvider", "Lnet/minecraft/client/render/VertexConsumerProvider;", "light", "", "setAngles", "f", "g", "setModelPose", "capes"})
public final class DisplayPlayerEntityRenderer
extends LivingEntityRenderer<LivingEntity, PlayerModel<LivingEntity>> {
    @NotNull
    private final EntityRendererProvider.Context ctx;
    @NotNull
    private final ElytraModel<LivingEntity> elytra;

    public DisplayPlayerEntityRenderer(@NotNull EntityRendererProvider.Context ctx, boolean slim) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx, (EntityModel)new PlayerModel(ctx.m_174023_(slim ? ModelLayers.f_171166_ : ModelLayers.f_171162_), slim), 0.5f);
        this.ctx = ctx;
        this.elytra = new ElytraModel(this.ctx.m_174027_().m_171103_(ModelLayers.f_171141_));
    }

    @NotNull
    public final EntityRendererProvider.Context getCtx() {
        return this.ctx;
    }

    @NotNull
    public final ElytraModel<LivingEntity> getElytra() {
        return this.elytra;
    }

    public final void render(@NotNull PlaceholderEntity livingEntity, float tickDelta, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource vertexConsumerProvider, int light) {
        VertexConsumer vertexConsumer;
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)vertexConsumerProvider, (String)"vertexConsumerProvider");
        this.setModelPose();
        matrixStack.m_85836_();
        ((PlayerModel)this.f_115290_).f_102610_ = false;
        matrixStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - livingEntity.getYaw()));
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_252880_(0.0f, -1.501f, 0.0f);
        float limbDistance = Mth.m_14179_((float)tickDelta, (float)livingEntity.getLastLimbDistance(), (float)livingEntity.getLimbDistance());
        float limbAngle = livingEntity.getLimbAngle() - livingEntity.getLimbDistance() * (1.0f - tickDelta);
        if (limbDistance > 1.0f) {
            limbDistance = 1.0f;
        }
        this.setAngles(limbAngle, limbDistance);
        if (livingEntity.getShowBody()) {
            RenderType renderLayer = ((PlayerModel)this.f_115290_).m_103119_(PlaceholderEntity.INSTANCE.getSkinTexture());
            vertexConsumer = vertexConsumerProvider.m_6299_(renderLayer);
            int overlay = OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)0.0f), (int)OverlayTexture.m_118096_((boolean)false));
            ((PlayerModel)this.f_115290_).m_7695_(matrixStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!PlaceholderEntity.INSTANCE.getShowElytra()) {
            if (PlaceholderEntity.INSTANCE.getCapeTexture() == null) {
                return;
            }
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, 0.0f, 0.125f);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(3.0f));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            VertexConsumer vertexConsumer2 = vertexConsumerProvider.m_6299_(RenderType.m_110431_((ResourceLocation)PlaceholderEntity.INSTANCE.getCapeTexture()));
            this.ctx.m_174023_(ModelLayers.f_171162_).m_171324_("cloak").m_104301_(matrixStack, vertexConsumer2, light, OverlayTexture.f_118083_);
            matrixStack.m_85849_();
        } else {
            ResourceLocation identifier = PlaceholderEntity.INSTANCE.getElytraTexture();
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, 0.0f, 0.125f);
            ((PlayerModel)this.f_115290_).m_102624_((EntityModel)this.elytra);
            vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)vertexConsumerProvider, (RenderType)RenderType.m_110431_((ResourceLocation)identifier), (boolean)false, (boolean)false);
            this.elytra.m_7695_(matrixStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    public final void setAngles(float f, float g) {
        ((PlayerModel)this.f_115290_).f_102810_.f_104204_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102811_.f_104202_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102811_.f_104200_ = -5.0f;
        ((PlayerModel)this.f_115290_).f_102812_.f_104202_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102812_.f_104200_ = 5.0f;
        ((PlayerModel)this.f_115290_).f_102811_.f_104203_ = Mth.m_14089_((float)(f * 0.6662f + (float)Math.PI)) * 2.0f * g * 0.5f;
        ((PlayerModel)this.f_115290_).f_102812_.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 2.0f * g * 0.5f;
        ((PlayerModel)this.f_115290_).f_102811_.f_104205_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102812_.f_104205_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102813_.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 1.4f * g;
        ((PlayerModel)this.f_115290_).f_102814_.f_104203_ = Mth.m_14089_((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g;
        ((PlayerModel)this.f_115290_).f_102813_.f_104204_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102814_.f_104204_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102813_.f_104205_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102814_.f_104205_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102811_.f_104204_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102812_.f_104204_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102810_.f_104203_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102813_.f_104202_ = 0.1f;
        ((PlayerModel)this.f_115290_).f_102814_.f_104202_ = 0.1f;
        ((PlayerModel)this.f_115290_).f_102813_.f_104201_ = 12.0f;
        ((PlayerModel)this.f_115290_).f_102814_.f_104201_ = 12.0f;
        ((PlayerModel)this.f_115290_).f_102808_.f_104201_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102810_.f_104201_ = 0.0f;
        ((PlayerModel)this.f_115290_).f_102812_.f_104201_ = 2.0f;
        ((PlayerModel)this.f_115290_).f_102811_.f_104201_ = 2.0f;
        ((PlayerModel)this.f_115290_).f_102809_.m_104315_(((PlayerModel)this.f_115290_).f_102808_);
        ((PlayerModel)this.f_115290_).f_103376_.m_104315_(((PlayerModel)this.f_115290_).f_102814_);
        ((PlayerModel)this.f_115290_).f_103377_.m_104315_(((PlayerModel)this.f_115290_).f_102813_);
        ((PlayerModel)this.f_115290_).f_103374_.m_104315_(((PlayerModel)this.f_115290_).f_102812_);
        ((PlayerModel)this.f_115290_).f_103375_.m_104315_(((PlayerModel)this.f_115290_).f_102811_);
        ((PlayerModel)this.f_115290_).f_103378_.m_104315_(((PlayerModel)this.f_115290_).f_102810_);
    }

    private final void setModelPose() {
        Options options = Minecraft.m_91087_().f_91066_;
        PlayerModel playerEntityModel = (PlayerModel)this.m_7200_();
        playerEntityModel.m_8009_(true);
        playerEntityModel.f_102809_.f_104207_ = options.m_168416_(PlayerModelPart.HAT);
        playerEntityModel.f_103378_.f_104207_ = options.m_168416_(PlayerModelPart.JACKET);
        playerEntityModel.f_103376_.f_104207_ = options.m_168416_(PlayerModelPart.LEFT_PANTS_LEG);
        playerEntityModel.f_103377_.f_104207_ = options.m_168416_(PlayerModelPart.RIGHT_PANTS_LEG);
        playerEntityModel.f_103374_.f_104207_ = options.m_168416_(PlayerModelPart.LEFT_SLEEVE);
        playerEntityModel.f_103375_.f_104207_ = options.m_168416_(PlayerModelPart.RIGHT_SLEEVE);
    }

    @NotNull
    public ResourceLocation getTexture(@Nullable LivingEntity entity) {
        ResourceLocation resourceLocation = DefaultPlayerSkin.m_118626_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getTexture()");
        return resourceLocation;
    }
}

