/*
 * Decompiled with CFR 0.152.
 */
package net.zhaiji.kubejscurios.curios;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public interface KubeJSCuriosHelper {
    default public Optional<ISlotType> getCuriosRegistrySlot(String slot) {
        return CuriosApi.getSlot((String)slot, (Level)((LivingEntity)this).m_9236_());
    }

    default public Map<String, ISlotType> getCuriosRegistrySlots() {
        return CuriosApi.getSlots((Level)((LivingEntity)this).m_9236_());
    }

    default public Map<String, ISlotType> getEntityCuriosRegistrySlots() {
        return CuriosApi.getEntitySlots((LivingEntity)((LivingEntity)this));
    }

    default public LazyOptional<ICurio> getCurioCapability(ItemStack stack) {
        return CuriosApi.getCurio((ItemStack)stack);
    }

    default public ICuriosItemHandler getCuriosInventory() {
        return (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)((LivingEntity)this)).orElseThrow(() -> new IllegalStateException("curios inventory not present : KubeJSCuriosHelper"));
    }

    default public Map<String, ICurioStacksHandler> getAllCurios() {
        return this.getCuriosInventory().getCurios();
    }

    default public Map<String, ISlotType> getStackInCuriosSlots(ItemStack stack) {
        return CuriosApi.getItemStackSlots((ItemStack)stack, (Level)((LivingEntity)this).m_9236_());
    }

    default public Optional<ICurioStacksHandler> getCuriosStacksHandler(String slot) {
        return this.getCuriosInventory().getStacksHandler(slot);
    }

    default public IItemHandlerModifiable getEquippedCurios() {
        return this.getCuriosInventory().getEquippedCurios();
    }

    default public void setEquippedCurio(String slot, int index, ItemStack stack) {
        this.getCuriosInventory().setEquippedCurio(slot, index, stack);
    }

    default public boolean isCuriosEquipped(Item item) {
        return this.getCuriosInventory().isEquipped(item);
    }

    default public boolean isCuriosEquipped(Predicate<ItemStack> filter) {
        return this.getCuriosInventory().isEquipped(filter);
    }

    default public Optional<SlotResult> findFirstCurio(Item item) {
        return this.getCuriosInventory().findFirstCurio(item);
    }

    default public Optional<SlotResult> findFirstCurio(Predicate<ItemStack> filter) {
        return this.getCuriosInventory().findFirstCurio(filter);
    }

    default public List<SlotResult> findCurios(Item item) {
        return this.getCuriosInventory().findCurios(item);
    }

    default public List<SlotResult> findCurios(Predicate<ItemStack> filter) {
        return this.getCuriosInventory().findCurios(filter);
    }

    default public List<SlotResult> findCurios(String ... slots) {
        return this.getCuriosInventory().findCurios(slots);
    }

    default public Optional<SlotResult> findCurio(String slot, int index) {
        return this.getCuriosInventory().findCurio(slot, index);
    }

    default public void addCuriosSlotModifier(String slot, UUID uuid, String identifier, double amount, AttributeModifier.Operation operation) {
        this.getCuriosInventory().addPermanentSlotModifier(slot, uuid, identifier, amount, operation);
    }

    default public void addCuriosSlotModifier(String slot, String identifier, double amount, AttributeModifier.Operation operation) {
        this.getCuriosInventory().addPermanentSlotModifier(slot, new UUID(identifier.hashCode(), identifier.hashCode()), identifier, amount, operation);
    }

    default public void removeCuriosSlotModifier(String slot, UUID uuid) {
        this.getCuriosInventory().removeSlotModifier(slot, uuid);
    }

    default public void removeCuriosSlotModifier(String slot, String identifier) {
        this.getCuriosInventory().removeSlotModifier(slot, new UUID(identifier.hashCode(), identifier.hashCode()));
    }

    default public void clearCuriosSlotModifiers() {
        this.getCuriosInventory().clearSlotModifiers();
    }

    default public Multimap<String, AttributeModifier> getCuriosSlotModifiers() {
        return this.getCuriosInventory().getModifiers();
    }
}

