/*
 * Decompiled with CFR 0.152.
 */
package net.zhaiji.kubejscurios.curios;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CapabilityCurios {
    private BiConsumer<SlotContext, ItemStack> curioTick;
    private EquipConsumer onEquip;
    private EquipConsumer onUnequip;
    private BiPredicate<SlotContext, ItemStack> canEquip;
    private BiPredicate<SlotContext, ItemStack> canUnequip;
    private BiFunction<List<Component>, ItemStack, List<Component>> slotsTooltip;
    private final Multimap<ResourceLocation, AttributeModifier> modifiers = HashMultimap.create();
    private final Multimap<Attribute, AttributeModifier> attributes = HashMultimap.create();
    private boolean attributeInit = false;
    private Consumer<AttributeModificationContext> modifyAttribute;
    private BiConsumer<SlotContext, ItemStack> onEquipFromUse;
    private BiFunction<SlotContext, ItemStack, ICurio.SoundInfo> modifyEquipSound;
    private BiPredicate<SlotContext, ItemStack> canEquipFromUse;
    private DropRulePredicate canDrop;
    private BiFunction<List<Component>, ItemStack, List<Component>> attributesTooltip;
    private FortuneFunction modifyFortuneLevel;
    private LootingFunction modifyLootingLevel;
    private BiPredicate<SlotContext, ItemStack> makesPiglinsNeutral;
    private BiPredicate<SlotContext, ItemStack> canWalkOnPowderedSnow;
    private EnderMaskPredicate isEnderMask;

    public CapabilityCurios curioTick(BiConsumer<SlotContext, ItemStack> curioTick) {
        this.curioTick = curioTick;
        return this;
    }

    public CapabilityCurios onEquip(EquipConsumer onEquip) {
        this.onEquip = onEquip;
        return this;
    }

    public CapabilityCurios onUnequip(EquipConsumer onUnequip) {
        this.onUnequip = onUnequip;
        return this;
    }

    public CapabilityCurios canEquip(BiPredicate<SlotContext, ItemStack> canEquip) {
        this.canEquip = canEquip;
        return this;
    }

    public CapabilityCurios canUnequip(BiPredicate<SlotContext, ItemStack> canUnequip) {
        this.canUnequip = canUnequip;
        return this;
    }

    public CapabilityCurios modifySlotsTooltip(BiFunction<List<Component>, ItemStack, List<Component>> slotsTooltip) {
        this.slotsTooltip = slotsTooltip;
        return this;
    }

    public CapabilityCurios addAttribute(ResourceLocation attribute, String identifier, double amount, AttributeModifier.Operation operation) {
        this.modifiers.put((Object)attribute, (Object)new AttributeModifier(new UUID(identifier.hashCode(), identifier.hashCode()), identifier, amount, operation));
        return this;
    }

    public CapabilityCurios modifyAttribute(Consumer<AttributeModificationContext> modifyAttribute) {
        this.modifyAttribute = modifyAttribute;
        return this;
    }

    public CapabilityCurios onEquipFromUse(BiConsumer<SlotContext, ItemStack> onEquipFromUse) {
        this.onEquipFromUse = onEquipFromUse;
        return this;
    }

    public CapabilityCurios modifyEquipSound(BiFunction<SlotContext, ItemStack, ICurio.SoundInfo> modifyEquipSound) {
        this.modifyEquipSound = modifyEquipSound;
        return this;
    }

    public CapabilityCurios canEquipFromUse(BiPredicate<SlotContext, ItemStack> canEquipFromUse) {
        this.canEquipFromUse = canEquipFromUse;
        return this;
    }

    public CapabilityCurios canDrop(DropRulePredicate canDrop) {
        this.canDrop = canDrop;
        return this;
    }

    public CapabilityCurios modifyAttributesTooltip(BiFunction<List<Component>, ItemStack, List<Component>> attributesTooltip) {
        this.attributesTooltip = attributesTooltip;
        return this;
    }

    public CapabilityCurios modifyFortuneLevel(FortuneFunction modifyFortuneLevel) {
        this.modifyFortuneLevel = modifyFortuneLevel;
        return this;
    }

    public CapabilityCurios modifyLootingLevel(LootingFunction modifyLootingLevel) {
        this.modifyLootingLevel = modifyLootingLevel;
        return this;
    }

    public CapabilityCurios makesPiglinsNeutral(BiPredicate<SlotContext, ItemStack> makesPiglinsNeutral) {
        this.makesPiglinsNeutral = makesPiglinsNeutral;
        return this;
    }

    public CapabilityCurios canWalkOnPowderedSnow(BiPredicate<SlotContext, ItemStack> canWalkOnPowderedSnow) {
        this.canWalkOnPowderedSnow = canWalkOnPowderedSnow;
        return this;
    }

    public CapabilityCurios isEnderMask(EnderMaskPredicate isEnderMask) {
        this.isEnderMask = isEnderMask;
        return this;
    }

    @HideFromJS
    public ICurioItem getCapability() {
        return new ICurioItem(){

            public void curioTick(SlotContext slotContext, ItemStack stack) {
                if (CapabilityCurios.this.curioTick != null) {
                    CapabilityCurios.this.curioTick.accept(slotContext, stack);
                } else {
                    super.curioTick(slotContext, stack);
                }
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
                if (CapabilityCurios.this.onEquip != null) {
                    CapabilityCurios.this.onEquip.accept(slotContext, prevStack, stack);
                } else {
                    super.onEquip(slotContext, prevStack, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
                if (CapabilityCurios.this.onUnequip != null) {
                    CapabilityCurios.this.onUnequip.accept(slotContext, stack, newStack);
                } else {
                    super.onUnequip(slotContext, newStack, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext, ItemStack stack) {
                if (CapabilityCurios.this.canEquip != null) {
                    return CapabilityCurios.this.canEquip.test(slotContext, stack);
                }
                return super.canEquip(slotContext, stack);
            }

            public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
                if (CapabilityCurios.this.canUnequip != null) {
                    return CapabilityCurios.this.canUnequip.test(slotContext, stack);
                }
                return super.canUnequip(slotContext, stack);
            }

            public List<Component> getSlotsTooltip(List<Component> tooltips, ItemStack stack) {
                if (CapabilityCurios.this.slotsTooltip != null) {
                    return CapabilityCurios.this.slotsTooltip.apply(tooltips, stack);
                }
                return super.getSlotsTooltip(tooltips, stack);
            }

            public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
                if (!CapabilityCurios.this.attributeInit) {
                    for (Map.Entry entry : CapabilityCurios.this.modifiers.entries()) {
                        ResourceLocation key = (ResourceLocation)entry.getKey();
                        AttributeModifier value = (AttributeModifier)entry.getValue();
                        CapabilityCurios.this.attributes.put((Object)((Attribute)RegistryInfo.ATTRIBUTE.getValue(key)), (Object)value);
                    }
                    CapabilityCurios.this.attributeInit = true;
                }
                if (CapabilityCurios.this.modifyAttribute != null) {
                    HashMultimap tempAttributes = HashMultimap.create(CapabilityCurios.this.attributes);
                    CapabilityCurios.this.modifyAttribute.accept(new AttributeModificationContext(slotContext, uuid, stack, (Multimap<Attribute, AttributeModifier>)tempAttributes));
                    return tempAttributes;
                }
                return CapabilityCurios.this.attributes;
            }

            public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
                if (CapabilityCurios.this.onEquipFromUse != null) {
                    CapabilityCurios.this.onEquipFromUse.accept(slotContext, stack);
                } else {
                    super.onEquipFromUse(slotContext, stack);
                }
            }

            @NotNull
            public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
                if (CapabilityCurios.this.modifyEquipSound != null) {
                    return CapabilityCurios.this.modifyEquipSound.apply(slotContext, stack);
                }
                return super.getEquipSound(slotContext, stack);
            }

            public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
                if (CapabilityCurios.this.canEquipFromUse != null) {
                    return CapabilityCurios.this.canEquipFromUse.test(slotContext, stack);
                }
                return true;
            }

            @NotNull
            public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
                if (CapabilityCurios.this.canDrop != null) {
                    return CapabilityCurios.this.canDrop.test(slotContext, source, lootingLevel, recentlyHit, stack) ? ICurio.DropRule.ALWAYS_DROP : ICurio.DropRule.ALWAYS_KEEP;
                }
                return super.getDropRule(slotContext, source, lootingLevel, recentlyHit, stack);
            }

            public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
                if (CapabilityCurios.this.attributesTooltip != null) {
                    return CapabilityCurios.this.attributesTooltip.apply(tooltips, stack);
                }
                return super.getAttributesTooltip(tooltips, stack);
            }

            public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack stack) {
                if (CapabilityCurios.this.modifyFortuneLevel != null) {
                    return CapabilityCurios.this.modifyFortuneLevel.apply(slotContext, lootContext, stack);
                }
                return super.getFortuneLevel(slotContext, lootContext, stack);
            }

            public int getLootingLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting, ItemStack stack) {
                if (CapabilityCurios.this.modifyLootingLevel != null) {
                    return CapabilityCurios.this.modifyLootingLevel.apply(slotContext, source, target, baseLooting, stack);
                }
                return super.getLootingLevel(slotContext, source, target, baseLooting, stack);
            }

            public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
                if (CapabilityCurios.this.makesPiglinsNeutral != null) {
                    return CapabilityCurios.this.makesPiglinsNeutral.test(slotContext, stack);
                }
                return super.makesPiglinsNeutral(slotContext, stack);
            }

            public boolean canWalkOnPowderedSnow(SlotContext slotContext, ItemStack stack) {
                if (CapabilityCurios.this.canWalkOnPowderedSnow != null) {
                    return CapabilityCurios.this.canWalkOnPowderedSnow.test(slotContext, stack);
                }
                return super.canWalkOnPowderedSnow(slotContext, stack);
            }

            public boolean isEnderMask(SlotContext slotContext, EnderMan enderMan, ItemStack stack) {
                if (CapabilityCurios.this.isEnderMask != null) {
                    return CapabilityCurios.this.isEnderMask.test(slotContext, enderMan, stack);
                }
                return super.isEnderMask(slotContext, enderMan, stack);
            }
        };
    }

    @FunctionalInterface
    public static interface EquipConsumer {
        public void accept(SlotContext var1, ItemStack var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface DropRulePredicate {
        public boolean test(SlotContext var1, DamageSource var2, int var3, boolean var4, ItemStack var5);
    }

    @FunctionalInterface
    public static interface FortuneFunction {
        public int apply(SlotContext var1, LootContext var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface LootingFunction {
        public int apply(SlotContext var1, DamageSource var2, LivingEntity var3, int var4, ItemStack var5);
    }

    @FunctionalInterface
    public static interface EnderMaskPredicate {
        public boolean test(SlotContext var1, EnderMan var2, ItemStack var3);
    }

    public static class CuriosCapabilityBuilder {
        public static CuriosCapabilityBuilder INSTANCE = new CuriosCapabilityBuilder();
        public static final Map<ItemBuilder, ICurioItem> itemBuilders = new HashMap<ItemBuilder, ICurioItem>();
        public static final Map<Item, ICurioItem> items = new HashMap<Item, ICurioItem>();

        public static void load() {
            itemBuilders.forEach((itemBuilder, iCurioItem) -> CuriosApi.registerCurio((Item)((Item)itemBuilder.get()), (ICurioItem)iCurioItem));
            items.forEach((item, iCurioItem) -> CuriosApi.registerCurio((Item)item, (ICurioItem)iCurioItem));
        }

        public CapabilityCurios create() {
            return new CapabilityCurios();
        }
    }

    public static class AttributeModificationContext {
        public final SlotContext slotContext;
        public final UUID uuid;
        public final ItemStack stack;
        public final Multimap<Attribute, AttributeModifier> modifiers;

        public AttributeModificationContext(SlotContext slotContext, UUID uuid, ItemStack stack, Multimap<Attribute, AttributeModifier> modifiers) {
            this.slotContext = slotContext;
            this.uuid = uuid;
            this.stack = stack;
            this.modifiers = modifiers;
        }

        public AttributeModificationContext modify(Attribute attribute, String identifier, double amount, AttributeModifier.Operation operation) {
            this.modifiers.put((Object)attribute, (Object)new AttributeModifier(new UUID(identifier.hashCode(), identifier.hashCode()), identifier, amount, operation));
            return this;
        }

        public AttributeModificationContext modify(Attribute attribute, UUID uuid, String identifier, double amount, AttributeModifier.Operation operation) {
            this.modifiers.put((Object)attribute, (Object)new AttributeModifier(uuid, identifier, amount, operation));
            return this;
        }

        public AttributeModificationContext remove(Attribute attribute, String identifier) {
            this.modifiers.get((Object)attribute).removeIf(modifier -> modifier.m_22214_().equals(identifier));
            return this;
        }
    }
}

