/*
 * Decompiled with CFR 0.152.
 */
package net.moritz_htk.idle_boost.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.moritz_htk.idle_boost.IdleBoost;
import net.moritz_htk.idle_boost.config.IBConfigManager;

public class IBWindowActivityHandler {
    private static int originalRenderDistance = -1;
    private static int originalFramerateLimit = -1;
    private static boolean wasWindowActive = true;

    public static void handleClientTick() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        Minecraft.m_91087_().execute(() -> {
            Options gameSettings = Minecraft.m_91087_().f_91066_;
            if (IBConfigManager.getConfig().modToggle) {
                boolean isWindowActive = Minecraft.m_91087_().m_91302_();
                if (!isWindowActive && wasWindowActive) {
                    IdleBoost.logDebugMode("Window is inactive, applying background settings", new Object[0]);
                    IBWindowActivityHandler.applyBackgroundSettings(gameSettings);
                } else if (isWindowActive && !wasWindowActive) {
                    IdleBoost.logDebugMode("Window is active, restoring foreground settings", new Object[0]);
                    IBWindowActivityHandler.restoreForegroundSettings(gameSettings);
                }
                wasWindowActive = isWindowActive;
            }
        });
    }

    private static void applyBackgroundSettings(Options gameSettings) {
        if (IBConfigManager.getConfig().framerateLimitToggle) {
            int framerateLimit = IBConfigManager.getConfig().framerateLimit;
            if (originalFramerateLimit == -1) {
                originalFramerateLimit = (Integer)gameSettings.m_232035_().m_231551_();
                IdleBoost.logDebugMode("Original framerate limit saved: {}", originalFramerateLimit);
            }
            if ((Integer)gameSettings.m_232035_().m_231551_() != framerateLimit) {
                gameSettings.m_232035_().m_231514_((Object)framerateLimit);
                IdleBoost.logDebugMode("Framerate limit set to: {}", framerateLimit);
            }
        }
        if (IBConfigManager.getConfig().renderDistanceToggle) {
            int renderDistance = IBConfigManager.getConfig().renderDistance;
            if (originalRenderDistance == -1) {
                originalRenderDistance = (Integer)gameSettings.m_231984_().m_231551_();
                IdleBoost.logDebugMode("Original render distance saved: {}", originalRenderDistance);
            }
            if ((Integer)gameSettings.m_231984_().m_231551_() != renderDistance) {
                gameSettings.m_231984_().m_231514_((Object)renderDistance);
                IdleBoost.logDebugMode("Render distance set to: {}", renderDistance);
            }
        }
    }

    private static void restoreForegroundSettings(Options gameSettings) {
        if (IBConfigManager.getConfig().framerateLimitToggle && originalFramerateLimit != -1) {
            if ((Integer)gameSettings.m_232035_().m_231551_() != originalFramerateLimit) {
                gameSettings.m_232035_().m_231514_((Object)originalFramerateLimit);
                IdleBoost.logDebugMode("Framerate limit restored to original value: {}", originalFramerateLimit);
            }
            originalFramerateLimit = -1;
        }
        if (IBConfigManager.getConfig().renderDistanceToggle && originalRenderDistance != -1) {
            if ((Integer)gameSettings.m_231984_().m_231551_() != originalRenderDistance) {
                gameSettings.m_231984_().m_231514_((Object)originalRenderDistance);
                IdleBoost.logDebugMode("Render distance restored to original value: {}", originalRenderDistance);
            }
            originalRenderDistance = -1;
        }
    }
}

