/*
 * Decompiled with CFR 0.152.
 */
package net.moritz_htk.idle_boost.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.moritz_htk.idle_boost.IdleBoost;
import net.moritz_htk.idle_boost.config.IBConfig;

public class IBConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/idle_boost.json");
    private static IBConfig CONFIG;

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                CONFIG = (IBConfig)GSON.fromJson((Reader)reader, IBConfig.class);
                IdleBoost.logDebugMode("Config loaded successfully", new Object[0]);
            }
            catch (IOException e) {
                IdleBoost.LOGGER.error("Failed to load config: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            CONFIG = new IBConfig();
            IdleBoost.LOGGER.warn("Config file not found. Creating new config...");
        }
    }

    public static void saveConfig() {
        IdleBoost.logDebugMode("Saving config...", new Object[0]);
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)CONFIG, (Appendable)writer);
            IdleBoost.logDebugMode("Config saved successfully", new Object[0]);
        }
        catch (IOException e) {
            IdleBoost.LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static IBConfig getConfig() {
        return CONFIG;
    }
}

