/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.forge;

import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.minecraftforge.registries.RegisterEvent;

public class LegacyRemapper {
    private static final Map<ResourceLocation, String> OLD_TO_NEW_NAMES = Map.of(new ResourceLocation("everycomp:sd_full_drawers_1"), "storagedrawers:standard_drawers_1", new ResourceLocation("everycomp:sd_full_drawers_2"), "storagedrawers:standard_drawers_2", new ResourceLocation("everycomp:sd_full_drawers_4"), "storagedrawers:standard_drawers_4", new ResourceLocation("everycomp:sd_half_drawers_1"), "storagedrawers:standard_drawers_1", new ResourceLocation("everycomp:sd_half_drawers_2"), "storagedrawers:standard_drawers_2", new ResourceLocation("everycomp:sd_half_drawers_4"), "storagedrawers:standard_drawers_4");

    public static void init(IEventBus modBus) {
        modBus.addListener(LegacyRemapper::registerEvent);
        MinecraftForge.EVENT_BUS.addListener(LegacyRemapper::remapBlocks);
    }

    public static void remapBlocks(MissingMappingsEvent event) {
        LegacyRemapper.remapInRegistry(event, BuiltInRegistries.f_257049_);
        LegacyRemapper.remapInRegistry(event, BuiltInRegistries.f_256975_);
        LegacyRemapper.remapInRegistry(event, BuiltInRegistries.f_257033_);
    }

    private static <T> void remapInRegistry(MissingMappingsEvent event, Registry<T> reg) {
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(reg.m_123023_(), "everycomp")) {
            String newMap = OLD_TO_NEW_NAMES.get(mapping.getKey());
            if (newMap == null) continue;
            reg.m_6612_(new ResourceLocation(newMap)).ifPresent(arg_0 -> ((MissingMappingsEvent.Mapping)mapping).remap(arg_0));
        }
    }

    public static void registerEvent(RegisterEvent event) {
        IForgeRegistry iForgeRegistry;
        if (event.getRegistryKey().equals((Object)ForgeRegistries.BLOCK_ENTITY_TYPES.getRegistryKey()) && (iForgeRegistry = event.getForgeRegistry()) instanceof ForgeRegistry) {
            ForgeRegistry fr = (ForgeRegistry)iForgeRegistry;
            OLD_TO_NEW_NAMES.forEach((oldKey, newKey) -> fr.addAlias(oldKey, new ResourceLocation(newKey)));
        }
    }
}

