/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.forge;

import com.google.gson.JsonObject;
import java.util.Locale;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ModEntriesConfigs;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public record BlockTypeEnabledCondition(BlockType type) implements ICondition
{
    private static final String CONDITION_NAME = "class";
    private static final String TYPE_NAME = "id";
    public static final ResourceLocation ID = EveryCompat.res("type_enabled");

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        return ModEntriesConfigs.isTypeEnabled(this.type);
    }

    public boolean test() {
        return ModEntriesConfigs.isTypeEnabled(this.type);
    }

    public static class Serializer
    implements IConditionSerializer<BlockTypeEnabledCondition> {
        public void write(JsonObject json, BlockTypeEnabledCondition value) {
            json.addProperty(BlockTypeEnabledCondition.CONDITION_NAME, value.type.getClass().getSimpleName().toLowerCase(Locale.ROOT));
            json.addProperty(BlockTypeEnabledCondition.TYPE_NAME, value.type.id.toString());
        }

        public BlockTypeEnabledCondition read(JsonObject json) {
            String type = json.getAsJsonPrimitive(BlockTypeEnabledCondition.CONDITION_NAME).getAsString();
            String name = json.getAsJsonPrimitive(BlockTypeEnabledCondition.TYPE_NAME).getAsString();
            for (BlockTypeRegistry r : BlockSetAPI.getRegistries()) {
                if (!r.getType().getSimpleName().toLowerCase(Locale.ROOT).equals(type)) continue;
                return new BlockTypeEnabledCondition(r.get(new ResourceLocation(name)));
            }
            EveryCompat.LOGGER.error((Object)new UnsupportedOperationException("Unrecognized block type " + type));
            return new BlockTypeEnabledCondition((BlockType)WoodTypeRegistry.OAK_TYPE);
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

