/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;

public class UnsafeModuleDisabler {
    private final Properties properties;
    private final File propertiesFile;
    private boolean isSafe;

    public UnsafeModuleDisabler() {
        block9: {
            this.isSafe = true;
            this.properties = new Properties();
            Path configPath = PlatHelper.getGamePath().resolve("config");
            this.propertiesFile = configPath.resolve("everycomp-hazardous.properties").toFile();
            try {
                File configDir = configPath.toFile();
                if (!configDir.exists()) {
                    configDir.mkdirs();
                }
                if (this.propertiesFile.exists()) {
                    try (FileInputStream fis = new FileInputStream(this.propertiesFile);){
                        this.properties.load(fis);
                        break block9;
                    }
                }
                this.propertiesFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Error initializing EC properties at path " + this.propertiesFile.getAbsolutePath(), e);
            }
        }
    }

    public void save() {
        try (FileOutputStream output = new FileOutputStream(this.propertiesFile);){
            this.properties.store(output, "Hard disable entire modules. Use at your own risk and don't ask for support if you use this. Write modid = false to disable modules");
        }
        catch (IOException e) {
            EveryCompat.LOGGER.error("Failed to save everycomp-hazardous.properties: ", (Throwable)e);
        }
    }

    public boolean isModuleOn(String modId) {
        try {
            if (this.properties.getProperty(modId) != null) {
                boolean ret = Boolean.parseBoolean(this.properties.getProperty(modId, "true"));
                if (!ret && this.isSafe) {
                    this.isSafe = false;
                    EveryCompat.LOGGER.warn("!!! You are using conditional modules registration. Proceed at your own risk and dont complain if you CANNOT connect to servers !!!");
                }
                return ret;
            }
            this.properties.setProperty(modId, String.valueOf(true));
            this.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

