/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.radiantgear.integration.lucent;

import com.legacy.lucent.api.EntityBrightness;
import com.legacy.lucent.api.plugin.ILucentPlugin;
import com.legacy.lucent.api.plugin.LucentPlugin;
import com.legacy.lucent.api.registry.ItemLightingRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.CuriosApi;

@OnlyIn(value=Dist.CLIENT)
@LucentPlugin
public class LucentModule
implements ILucentPlugin {
    public String ownerModID() {
        return "radiantgear";
    }

    @Nullable
    public List<String> requiredMods() {
        return Collections.singletonList("curios");
    }

    public void getEntityLightLevel(EntityBrightness entityBrightness) {
        Entity entity = entityBrightness.getEntity();
        AtomicInteger curiosLightLevel = new AtomicInteger();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            CuriosApi.getCuriosHelper().getEquippedCurios(livingEntity).ifPresent(curios -> {
                for (int i = 0; i < curios.getSlots(); ++i) {
                    ItemStack stack = curios.getStackInSlot(i);
                    curiosLightLevel.set(Math.max(curiosLightLevel.get(), ItemLightingRegistry.get((ItemStack)stack)));
                }
            });
        }
        entityBrightness.setLightLevel(curiosLightLevel.get());
    }
}

