/*
 * Decompiled with CFR 0.152.
 */
package com.github.raverbury.aggroindicator;

import com.github.raverbury.aggroindicator.config.ClientConfig;
import com.github.raverbury.aggroindicator.util.MathHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class AlertRenderer {
    private static final List<LivingEntity> renderedEntities = new ArrayList<LivingEntity>();
    private static final HashMap<UUID, Tuple<Integer, Long>> entityUuidSet = new HashMap();
    private static ResourceLocation aggroIcon = AlertRenderer.getConfiguredAggroIcon();

    public static void addEntity(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        renderedEntities.add(entity);
    }

    public static void addAggroingMob(UUID mobUuid) {
        if (!entityUuidSet.containsKey(mobUuid)) {
            entityUuidSet.put(mobUuid, (Tuple<Integer, Long>)new Tuple((Object)0, (Object)0L));
        }
    }

    public static void removeAggroingMob(UUID mobUuid) {
        entityUuidSet.remove(mobUuid);
    }

    public static void clearAggroingMobs() {
        entityUuidSet.clear();
    }

    public static boolean shouldDrawThisUuid(UUID uuid) {
        Tuple tuple = entityUuidSet.getOrDefault(uuid, null);
        if (tuple == null) {
            return false;
        }
        int hideAfterTicks = ClientConfig.Cached.hideAfterTicks;
        if (hideAfterTicks <= 0) {
            return true;
        }
        return (Integer)tuple.m_14418_() < ClientConfig.Cached.hideAfterTicks;
    }

    public static void tickSeenEnemy(Entity entity) {
        UUID uuid = entity.m_20148_();
        if (entityUuidSet.containsKey(uuid)) {
            Tuple<Integer, Long> tuple = entityUuidSet.get(uuid);
            long currentTick = entity.m_9236_().m_46467_();
            if ((Long)tuple.m_14419_() < currentTick) {
                tuple.m_145025_((Object)currentTick);
                tuple.m_145023_((Object)Math.min((Integer)tuple.m_14418_() + 1, ClientConfig.Cached.hideAfterTicks));
            }
        }
    }

    public static void renderAlertIcon(float partialTick, PoseStack matrix, Camera camera) {
        Minecraft client = Minecraft.m_91087_();
        if (camera == null) {
            camera = client.m_91290_().f_114358_;
        }
        if (camera == null) {
            renderedEntities.clear();
            return;
        }
        if (renderedEntities.isEmpty()) {
            return;
        }
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        for (LivingEntity entity : renderedEntities) {
            float scaleToGui = 0.025f;
            boolean sneaking = entity.m_6047_();
            float height = entity.m_20206_() + 0.6f - (sneaking ? 0.25f : 0.0f);
            double x = Mth.m_14139_((double)partialTick, (double)entity.f_19854_, (double)entity.m_20185_());
            double y = Mth.m_14139_((double)partialTick, (double)entity.f_19855_, (double)entity.m_20186_());
            double z = Mth.m_14139_((double)partialTick, (double)entity.f_19856_, (double)entity.m_20189_());
            Vec3 camPos = camera.m_90583_();
            double camX = camPos.m_7096_();
            double camY = camPos.m_7098_();
            double camZ = camPos.m_7094_();
            matrix.m_85836_();
            matrix.m_85837_(x - camX, y + (double)height - camY, z - camZ);
            Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);
            matrix.m_252781_(MathHelper.rotationDegrees(YP, -camera.m_90590_()));
            matrix.m_85841_(-scaleToGui, -scaleToGui, scaleToGui);
            if (ClientConfig.Cached.SCALE_WITH_MOB_SIZE) {
                float size;
                matrix.m_85841_(size *= (size = (float)entity.m_20191_().m_82309_()) > 2.0f ? 0.9f : 1.0f, size, size);
            }
            AlertRenderer._render(matrix, ClientConfig.Cached.X_OFFSET, -(7.0 + ClientConfig.Cached.Y_OFFSET), (float)ClientConfig.Cached.ALERT_ICON_SIZE);
            matrix.m_85849_();
        }
        renderedEntities.clear();
    }

    public static void reloadAggroIcon() {
        aggroIcon = AlertRenderer.getConfiguredAggroIcon();
    }

    private static ResourceLocation getConfiguredAggroIcon() {
        return switch (ClientConfig.Cached.CLIENT_AGGRO_ICON_STYLE) {
            case ClientConfig.AggroIconStyle.MGS -> new ResourceLocation("aggroindicator:textures/alert_icon_mgs.png");
            case ClientConfig.AggroIconStyle.BLOCK_BENCH -> new ResourceLocation("aggroindicator:textures/alert_icon_block_bench.png");
            default -> new ResourceLocation("aggroindicator:textures/alert_icon_classic.png");
        };
    }

    private static void _render(PoseStack matrix, double x, double y, float size) {
        float[] rgbValues = ClientConfig.Cached.COLORS;
        RenderSystem.setShaderColor((float)rgbValues[0], (float)rgbValues[1], (float)rgbValues[2], (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)aggroIcon);
        RenderSystem.enableBlend();
        Matrix4f m4f = matrix.m_85850_().m_252922_();
        float halfWidth = size / 2.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(m4f, (float)((double)(-halfWidth) + x), (float)y, 0.25f).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m4f, (float)((double)(-halfWidth) + x), (float)((double)size + y), 0.25f).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(m4f, (float)((double)halfWidth + x), (float)((double)size + y), 0.25f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(m4f, (float)((double)halfWidth + x), (float)y, 0.25f).m_7421_(1.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

