/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.message;

import com.mrcrayfish.backpacked.network.play.ClientPlayHandler;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MessageOpenCustomisation
extends PlayMessage<MessageOpenCustomisation> {
    private Map<ResourceLocation, Component> map;

    public MessageOpenCustomisation() {
    }

    public MessageOpenCustomisation(Map<ResourceLocation, Component> map) {
        this.map = map;
    }

    public void encode(MessageOpenCustomisation message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.map.size());
        message.map.forEach((location, formattedProgress) -> {
            buffer.m_130085_(location);
            buffer.m_130083_(formattedProgress);
        });
    }

    public MessageOpenCustomisation decode(FriendlyByteBuf buffer) {
        HashMap<ResourceLocation, Component> map = new HashMap<ResourceLocation, Component>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buffer.m_130281_();
            Component formattedProgress = buffer.m_130238_();
            map.put(id, formattedProgress);
        }
        return new MessageOpenCustomisation(map);
    }

    public void handle(MessageOpenCustomisation message, MessageContext context) {
        context.execute(() -> ClientPlayHandler.handleOpenCustomisation(message));
        context.setHandled(true);
    }

    public Map<ResourceLocation, Component> progressMap() {
        return this.map;
    }
}

