/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.tracker;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public record ProgressFormatter(ResourceLocation id, BiFunction<Integer, Integer, Component> formatter) {
    public static final BiMap<ResourceLocation, ProgressFormatter> REGISTERED_FORMATTERS = HashBiMap.create();
    public static final Codec<ProgressFormatter> CODEC = ResourceLocation.f_135803_.flatXmap(id -> {
        ProgressFormatter type = (ProgressFormatter)REGISTERED_FORMATTERS.get(id);
        return type != null ? DataResult.success((Object)type) : DataResult.error(() -> "Formatter does not exist: " + id);
    }, type -> {
        ResourceLocation id = (ResourceLocation)REGISTERED_FORMATTERS.inverse().get(type);
        return id != null ? DataResult.success((Object)id) : DataResult.error(() -> "Unregistered formatter");
    });
    public static final ProgressFormatter COMPLETED_X_OF_X = ProgressFormatter.register("completed_x_of_x", (count, maxCount) -> {
        count = Mth.m_14045_((int)count, (int)0, (int)maxCount);
        return Component.m_237110_((String)"backpacked.formatter.completed_x_of_x", (Object[])new Object[]{count, maxCount});
    });
    public static final ProgressFormatter COLLECT_X_OF_X = ProgressFormatter.register("collect_x_of_x", (count, maxCount) -> {
        count = Mth.m_14045_((int)count, (int)0, (int)maxCount);
        return Component.m_237110_((String)"backpacked.formatter.collected_x_of_x", (Object[])new Object[]{count, maxCount});
    });
    public static final ProgressFormatter FED_X_OF_X = ProgressFormatter.register("fed_x_of_x", (count, maxCount) -> {
        count = Mth.m_14045_((int)count, (int)0, (int)maxCount);
        return Component.m_237110_((String)"backpacked.formatter.fed_x_of_x", (Object[])new Object[]{count, maxCount});
    });
    public static final ProgressFormatter FOUND_X_OF_X = ProgressFormatter.register("found_x_of_x", (count, maxCount) -> {
        count = Mth.m_14045_((int)count, (int)0, (int)maxCount);
        return Component.m_237110_((String)"backpacked.formatter.found_x_of_x", (Object[])new Object[]{count, maxCount});
    });
    public static final ProgressFormatter USED_X_TIMES = ProgressFormatter.register("used_x_times", (count, unused) -> Component.m_237110_((String)"backpacked.formatter.used_x_times", (Object[])new Object[]{count}));
    public static final ProgressFormatter BRED_X_OF_X = ProgressFormatter.register("bred_x_of_x", (count, maxCount) -> Component.m_237110_((String)"backpacked.formatter.bred_x_of_x", (Object[])new Object[]{count, maxCount}));
    public static final ProgressFormatter CUT_X_OF_X = ProgressFormatter.register("cut_x_of_x", (count, maxCount) -> Component.m_237110_((String)"backpacked.formatter.cut_x_of_x", (Object[])new Object[]{count, maxCount}));
    public static final ProgressFormatter SHEARED_X_OF_X = ProgressFormatter.register("shear_x_of_x", (count, maxCount) -> Component.m_237110_((String)"backpacked.formatter.shear_x_of_x", (Object[])new Object[]{count, maxCount}));
    public static final ProgressFormatter INT_PERCENT = ProgressFormatter.register("percentage", (numerator, denominator) -> {
        int percent = (int)(100.0 * (double)numerator.intValue() / (double)denominator.intValue());
        return Component.m_237110_((String)"backpacked.formatter.int_percent", (Object[])new Object[]{percent, "%"});
    });
    public static final ProgressFormatter CRAFT_X_OF_X = ProgressFormatter.register("craft_x_of_x", (count, maxCount) -> {
        count = Mth.m_14045_((int)count, (int)0, (int)maxCount);
        return Component.m_237110_((String)"backpacked.formatter.craft_x_of_x", (Object[])new Object[]{count, maxCount});
    });
    public static final ProgressFormatter PICKPOCKETED_X_OF_X = ProgressFormatter.register("pickpocketed_x_of_x", (count, maxCount) -> {
        count = Mth.m_14045_((int)count, (int)0, (int)maxCount);
        return Component.m_237110_((String)"backpacked.formatter.pickpocketed_x_of_x", (Object[])new Object[]{count, maxCount});
    });
    public static final ProgressFormatter EXPLORED_X_OF_X = ProgressFormatter.register("explored_x_of_x", (count, maxCount) -> {
        count = Mth.m_14045_((int)count, (int)0, (int)maxCount);
        return Component.m_237110_((String)"backpacked.formatter.explored_x_of_x", (Object[])new Object[]{count, maxCount});
    });
    public static final ProgressFormatter KILLED_X_OF_X = ProgressFormatter.register("killed_x_of_x", (count, maxCount) -> {
        count = Mth.m_14045_((int)count, (int)0, (int)maxCount);
        return Component.m_237110_((String)"backpacked.formatter.killed_x_of_x", (Object[])new Object[]{count, maxCount});
    });
    public static final ProgressFormatter MINED_X_OF_X = ProgressFormatter.register("mined_x_of_x", (count, maxCount) -> {
        count = Mth.m_14045_((int)count, (int)0, (int)maxCount);
        return Component.m_237110_((String)"backpacked.formatter.mined_x_of_x", (Object[])new Object[]{count, maxCount});
    });
    public static final ProgressFormatter TRADED_X_OF_X = ProgressFormatter.register("traded_x_of_x", (count, maxCount) -> {
        count = Mth.m_14045_((int)count, (int)0, (int)maxCount);
        return Component.m_237110_((String)"backpacked.formatter.traded_x_of_x", (Object[])new Object[]{count, maxCount});
    });
    public static final ProgressFormatter INCOMPLETE_COMPLETE = ProgressFormatter.register("incomplete_complete", (count, maxCount) -> {
        if (count < maxCount) {
            return Component.m_237115_((String)"backpacked.formatter.incomplete");
        }
        return Component.m_237115_((String)"backpacked.formatter.complete");
    });
    public static final ProgressFormatter TRAVELLED_BLOCKS = ProgressFormatter.register("travelled_blocks", (count, maxCount) -> {
        count = Mth.m_14045_((int)count, (int)0, (int)maxCount);
        return Component.m_237110_((String)"backpacked.formatter.travelled_blocks", (Object[])new Object[]{Math.round((float)count.intValue() / 100.0f), Math.round((float)maxCount.intValue() / 100.0f)});
    });

    private static ProgressFormatter register(String name, BiFunction<Integer, Integer, Component> function) {
        ResourceLocation id = new ResourceLocation("backpacked", name);
        ProgressFormatter formatter = new ProgressFormatter(id, function);
        REGISTERED_FORMATTERS.put((Object)id, (Object)formatter);
        return formatter;
    }
}

