/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrcrayfish.backpacked.Constants;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.platform.Services;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class BackpackLoader
extends SimpleJsonResourceReloadListener {
    private static final String DIRECTORY = "backpacked";
    private static final Gson GSON = new GsonBuilder().create();

    public BackpackLoader() {
        super(GSON, DIRECTORY);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller filler) {
        HashMap<ResourceLocation, Backpack> backpacks = new HashMap<ResourceLocation, Backpack>();
        map.forEach((location, element) -> {
            String modId;
            if (location.m_135815_().contains("/")) {
                Constants.LOG.warn("Ignoring backpack '{}' as it was in a sub-directory", location);
                return;
            }
            JsonObject object = element.getAsJsonObject();
            if (object.has("mod_loaded") && object.get("mod_loaded").isJsonPrimitive() && !Services.REGISTRATION.isModLoaded(modId = object.get("mod_loaded").getAsString())) {
                return;
            }
            try {
                Backpack backpack = Backpack.deserialize(object);
                backpack.setup((ResourceLocation)location);
                backpacks.put((ResourceLocation)location, backpack);
            }
            catch (Exception e) {
                throw new JsonParseException("An error occurred when parsing the backpack '%s'".formatted(location), (Throwable)e);
            }
        });
        BackpackManager.instance().updateBackpacks(backpacks);
    }
}

