/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.spelunker.mixin;

import de.leximon.spelunker.SpelunkerMod;
import de.leximon.spelunker.SpelunkerModClient;
import de.leximon.spelunker.core.ChunkOres;
import de.leximon.spelunker.core.SpelunkerConfig;
import de.leximon.spelunker.core.SpelunkerEffectManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309 {
    private int lastCx;
    private int lastCy;
    private int lastCz;
    private boolean forceOreChunkUpdate = true;
    private final HashSet<class_2382> spelunkerEffectChunks = new HashSet();

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void moveEndInject(CallbackInfo ci) {
        class_1937 world = this.method_37908();
        if (!this.method_6059(SpelunkerMod.STATUS_EFFECT_SPELUNKER)) {
            if (!this.spelunkerEffectChunks.isEmpty()) {
                this.spelunkerEffectChunks.clear();
            }
            this.forceOreChunkUpdate = true;
            return;
        }
        if (SpelunkerConfig.serverValidating && world.method_8608()) {
            return;
        }
        int cx = class_4076.method_32204((double)this.method_23317());
        int cy = class_4076.method_32204((double)this.method_23318());
        int cz = class_4076.method_32204((double)this.method_23321());
        if (cx != this.lastCx || cy != this.lastCy || cz != this.lastCz || this.forceOreChunkUpdate) {
            this.forceOreChunkUpdate = false;
            HashMap<class_2382, class_2826> newChunks = SpelunkerEffectManager.getSurroundingChunkSections(world, this.method_19538());
            HashSet<class_2382> remove = new HashSet<class_2382>();
            this.spelunkerEffectChunks.removeIf(p -> {
                if (!newChunks.containsKey(p)) {
                    remove.add((class_2382)p);
                    return true;
                }
                return false;
            });
            ArrayList<ChunkOres> add = new ArrayList<ChunkOres>();
            for (Map.Entry<class_2382, class_2826> section : newChunks.entrySet()) {
                class_2382 pos = section.getKey();
                if (this.spelunkerEffectChunks.contains(pos)) continue;
                add.add(SpelunkerEffectManager.findOresInChunk(world, pos));
                this.spelunkerEffectChunks.add(pos);
            }
            if (world.method_8608()) {
                SpelunkerModClient.spelunkerEffectRenderer.updateChunks(world, remove, add);
            } else if (SpelunkerConfig.serverValidating) {
                class_2540 buf = SpelunkerEffectManager.writePacket(world, true, remove, add);
                ServerPlayNetworking.send((class_3222)((class_3222)this), (class_2960)SpelunkerMod.PACKET_ORE_CHUNKS, (class_2540)buf);
            }
        }
        this.lastCx = cx;
        this.lastCy = cy;
        this.lastCz = cz;
    }
}

