/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.spelunker.core;

import de.leximon.spelunker.SpelunkerMod;
import de.leximon.spelunker.core.ChunkOres;
import de.leximon.spelunker.core.SpelunkerConfig;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4618;
import net.minecraft.class_630;

public class SpelunkerEffectRenderer {
    private final ConcurrentMap<class_2382, ChunkOres> chunkSections = new ConcurrentHashMap<class_2382, ChunkOres>();
    private boolean active = false;
    private static final class_630.class_628 CUBE = new class_630.class_628(0, 0, 0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f, EnumSet.allOf(class_2350.class));
    private static final class_1921 RENDER_LAYER = class_1921.method_23287((class_2960)SpelunkerMod.identifier("textures/none.png"));

    public void render(class_4587 matrices, class_4184 camera, class_4618 vertexConsumers) {
        class_243 pos = camera.method_19326();
        matrices.method_22903();
        matrices.method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
        for (Map.Entry chunkSection : this.chunkSections.entrySet()) {
            this.renderChunk((ChunkOres)chunkSection.getValue(), matrices, pos, vertexConsumers);
        }
        matrices.method_22909();
    }

    public boolean setActive(boolean value) {
        boolean init = value && !this.active;
        this.active = value;
        return init;
    }

    public boolean isActive() {
        return this.active;
    }

    public void clear() {
        this.chunkSections.clear();
    }

    public void updateChunks(class_1937 world, Collection<class_2382> remove, Collection<ChunkOres> add) {
        for (class_2382 v : remove) {
            this.chunkSections.remove(v);
        }
        for (ChunkOres chunk : add) {
            this.chunkSections.put(chunk.getPos(), chunk.remapToBlockCoordinates(world.method_32891()));
        }
    }

    public void removeChunk(class_2382 pos) {
        this.chunkSections.remove(pos);
    }

    public ChunkOres get(class_2382 pos) {
        return (ChunkOres)this.chunkSections.get(pos);
    }

    public void addChunks(int bottomSectionCord, Collection<ChunkOres> chunks) {
        for (ChunkOres chunk : chunks) {
            this.chunkSections.put(chunk.getPos(), chunk.remapToBlockCoordinates(bottomSectionCord));
        }
    }

    public void renderChunk(ChunkOres chunk, class_4587 matrices, class_243 playerPos, class_4618 vertexConsumers) {
        for (Map.Entry ore : chunk.entrySet()) {
            float fade;
            SpelunkerConfig.ChunkBlockConfig block;
            class_2382 pos = (class_2382)ore.getKey();
            double squareDistance = SpelunkerEffectRenderer.toSquaredDistanceFromCenter(pos, playerPos.method_10216(), playerPos.method_10214(), playerPos.method_10215());
            if (squareDistance > (double)(block = (SpelunkerConfig.ChunkBlockConfig)ore.getValue()).getBlockRadiusMax()) continue;
            if (SpelunkerConfig.globalTransition && block.isTransition()) {
                fade = Math.min(1.0f - (float)((squareDistance - (double)block.getBlockRadiusMin()) / (double)(block.getBlockRadiusMax() - block.getBlockRadiusMin())), 1.0f);
                fade = SpelunkerEffectRenderer.easeOutCirc(fade);
            } else {
                fade = 1.0f;
            }
            matrices.method_22903();
            matrices.method_22904((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            matrices.method_22905(fade, fade, fade);
            matrices.method_22903();
            matrices.method_22904(-0.5, -0.5, -0.5);
            CUBE.method_32089(matrices.method_23760(), this.setOutlineColor(block.getColor(), vertexConsumers), 0, class_4608.field_21444, 0.0f, 0.0f, 0.0f, 0.0f);
            matrices.method_22909();
            matrices.method_22909();
        }
    }

    private class_4588 setOutlineColor(int color, class_4618 vertexConsumers) {
        vertexConsumers.method_23286(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        return vertexConsumers.getBuffer(RENDER_LAYER);
    }

    private static float easeOutCirc(float x) {
        return (float)Math.sqrt(1.0 - Math.pow(x - 1.0f, 2.0));
    }

    private static double toSquaredDistanceFromCenter(class_2382 pos, double x, double y, double z) {
        double d = (double)pos.method_10263() + 0.5 - x;
        double e = (double)pos.method_10264() + 0.5 - y;
        double f = (double)pos.method_10260() + 0.5 - z;
        return d * d + e * e + f * f;
    }
}

