/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.client.dialogues;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.DialogueInstance;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.TreeDialogueTypes;
import org.jetbrains.annotations.NotNull;

public interface ITreeDialogue
extends Comparable<ITreeDialogue> {
    public static final Codec<ITreeDialogue> CODEC = Codec.STRING.flatXmap(name -> TreeDialogueTypes.get(name).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown Tree Dialogue type: " + name)), t -> DataResult.success((Object)t.name())).dispatch("type", ITreeDialogue::getType, Type::codec);
    public static final ITreeDialogue NO_OP = new Dummy(1000);

    public Type<? extends ITreeDialogue> getType();

    public int getRequiredTrust();

    @Override
    default public int compareTo(@NotNull ITreeDialogue o) {
        return Integer.compare(this.getRequiredTrust(), o.getRequiredTrust());
    }

    default public DialogueInstance createInstance() {
        return new DialogueInstance(this);
    }

    @NotNull
    public Status getLine(int var1, boolean var2);

    public record Type<T extends ITreeDialogue>(Codec<T> codec, String name, int trustDelta) {
    }

    public record Dummy(int trust) implements ITreeDialogue
    {
        public Type<Dummy> getType() {
            return null;
        }

        @Override
        public int getRequiredTrust() {
            return this.trust;
        }

        @Override
        public Status getLine(int lineIndex, boolean hasBeenInteractedWith) {
            return lineIndex == 0 ? new Status("error") : Status.DONE;
        }
    }

    public record Simple(List<String> text) implements ITreeDialogue
    {
        public Type<ITreeDialogue> getType() {
            return null;
        }

        @Override
        public int getRequiredTrust() {
            return 0;
        }

        @Override
        public Status getLine(int lineIndex, boolean hasBeenInteractedWith) {
            if (lineIndex < this.text.size()) {
                String s = this.text.get(lineIndex);
                return new Status(s);
            }
            return Status.DONE;
        }
    }

    public record Status(String text) {
        public static Status DONE = new Status(null);
        public static Status WAITING = new Status(null);
    }
}

