/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.worldplaytime.common.util;

import java.util.Locale;
import me.khajiitos.worldplaytime.common.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PlayTimeRenderer {
    private static final ResourceLocation TIME_ICON = new ResourceLocation("worldplaytime", "textures/gui/time_icon.png");

    @Nullable
    public static Component getPlayTimeComponent(int ticks) {
        if (ticks <= 0) {
            return null;
        }
        double hours = (double)ticks / 20.0 / 3600.0;
        return Component.m_237110_((String)"worldplaytime.format", (Object[])new Object[]{Component.m_237113_((String)(hours >= 100.0 ? String.valueOf((int)hours) : String.format(Locale.US, "%.1f", hours)))});
    }

    public static int getWholeWidth(int ticks) {
        Component component = PlayTimeRenderer.getPlayTimeComponent(ticks);
        if (component == null) {
            return 0;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        return minecraft.f_91062_.m_92852_((FormattedText)component) + 11;
    }

    public static void render(GuiGraphics guiGraphics, int x, int y, int playTimeTicks, Color color) {
        Minecraft minecraft = Minecraft.m_91087_();
        Component component = PlayTimeRenderer.getPlayTimeComponent(playTimeTicks);
        if (component == null) {
            return;
        }
        guiGraphics.m_280246_((float)color.r / 255.0f, (float)color.g / 255.0f, (float)color.b / 255.0f, (float)color.a / 255.0f);
        guiGraphics.m_280163_(TIME_ICON, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280614_(minecraft.f_91062_, component, x + 11, y + 1, color.toARGB(), false);
    }
}

