/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.worldplaytime.common.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.khajiitos.worldplaytime.common.WorldPlayTime;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;

public class ServerPlayTimeManager {
    private static final File file = new File("data/servers_playtime.dat");
    private static final HashMap<String, Integer> serverPlayTimes = new HashMap();

    public static void save() {
        if (serverPlayTimes.isEmpty()) {
            return;
        }
        if (!file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
            WorldPlayTime.LOGGER.error("Failed to create config/worldplaytime/ directory");
            return;
        }
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<String, Integer> entry : serverPlayTimes.entrySet()) {
            String serverIp = entry.getKey();
            int playTime = entry.getValue();
            compoundTag.m_128405_(serverIp, playTime);
        }
        try {
            NbtIo.m_128955_((CompoundTag)compoundTag, (File)file);
        }
        catch (IOException e) {
            WorldPlayTime.LOGGER.error("Failed to write to servers_playtime.dat");
        }
    }

    public static void load() {
        if (!file.exists()) {
            return;
        }
        try {
            CompoundTag compoundTag = NbtIo.m_128953_((File)file);
            if (compoundTag == null) {
                return;
            }
            for (String serverIp : compoundTag.m_128431_()) {
                int playTime = compoundTag.m_128451_(serverIp);
                if (playTime <= 0) continue;
                serverPlayTimes.put(serverIp, playTime);
            }
        }
        catch (IOException e) {
            WorldPlayTime.LOGGER.error("Failed to read servers_playtime.dat");
        }
    }

    public static void saveAsync() {
        CompletableFuture.runAsync(ServerPlayTimeManager::save);
    }

    public static void onPlayTick(String serverIp) {
        serverPlayTimes.put(serverIp, serverPlayTimes.getOrDefault(serverIp, 0) + 1);
    }

    public static int getPlayTime(String serverIp) {
        return serverPlayTimes.getOrDefault(serverIp, 0);
    }
}

