/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.foundation;

import com.cak.trading_floor.foundation.TFPlatformPackets;
import java.util.Objects;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ParticleEmitter {
    final SimpleParticleType particleType;
    AABB volume = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    Vec3 randomVelocityStrength = Vec3.f_82478_;
    Vec3 emitFromCenterStrength = Vec3.f_82478_;
    int sendPacketRange = 16;

    public ParticleEmitter(SimpleParticleType particleType) {
        this.particleType = particleType;
    }

    public void emitToClients(ServerLevel level, Vec3 origin, int count) {
        TFPlatformPackets.sendEmitParticlesToNear(level, this, origin, count, BlockPos.m_274446_((Position)origin), this.sendPacketRange);
    }

    public void emitParticles(ClientLevel level, Vec3 origin, int count) {
        this.emitWithConsumer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((ClientLevel)level).m_7106_(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), origin, count);
    }

    public void emitWithConsumer(ParticleDataConsumer consumer, Vec3 origin, int count) {
        boolean hasAABB = !this.volume.equals((Object)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        boolean doEmitFromCenter = !this.emitFromCenterStrength.equals((Object)Vec3.f_82478_);
        boolean hasVelocity = !this.randomVelocityStrength.equals((Object)Vec3.f_82478_);
        for (int i = 0; i < count; ++i) {
            Vec3 position = this.generateRandomPosition(hasAABB, origin);
            Vec3 velocity = hasVelocity ? this.generateRandomVelocityOfPosition(doEmitFromCenter, origin, position) : Vec3.f_82478_;
            consumer.addParticle(this.particleType, position.f_82479_, position.f_82480_, position.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    protected Vec3 generateRandomVelocityOfPosition(boolean doEmitFromCenter, Vec3 origin, Vec3 position) {
        Vec3 baseVelocity = new Vec3(this.randomVelocityStrength.f_82479_ * Math.random(), this.randomVelocityStrength.f_82480_ * Math.random(), this.randomVelocityStrength.f_82481_ * Math.random());
        if (!doEmitFromCenter) {
            return baseVelocity;
        }
        Vec3 offset = position.m_82546_(origin).m_82541_();
        if (offset.equals((Object)Vec3.f_82478_)) {
            return baseVelocity;
        }
        baseVelocity = baseVelocity.m_82520_(this.emitFromCenterStrength.f_82479_ * offset.f_82479_, this.emitFromCenterStrength.f_82480_ * offset.f_82480_, this.emitFromCenterStrength.f_82481_ * offset.f_82481_);
        return baseVelocity;
    }

    protected Vec3 generateRandomPosition(boolean hasAABB, Vec3 origin) {
        if (!hasAABB) {
            return origin;
        }
        Vec3 offset = new Vec3(this.volume.f_82288_ + this.volume.m_82362_() * Math.random(), this.volume.f_82289_ + this.volume.m_82376_() * Math.random(), this.volume.f_82290_ + this.volume.m_82385_() * Math.random());
        return origin.m_82549_(offset);
    }

    public ParticleEmitter setVolume(AABB volume) {
        this.volume = volume;
        return this;
    }

    public ParticleEmitter setRandomVelocityStrength(Vec3 randomVelocityStrength) {
        this.randomVelocityStrength = randomVelocityStrength;
        return this;
    }

    public ParticleEmitter setRandomVelocityStrength(float randomVelocityStrength) {
        return this.setRandomVelocityStrength(new Vec3((double)randomVelocityStrength, (double)randomVelocityStrength, (double)randomVelocityStrength));
    }

    public ParticleEmitter setEmitFromCenterStrength(Vec3 emitFromCenterStrength) {
        this.emitFromCenterStrength = emitFromCenterStrength;
        return this;
    }

    public ParticleEmitter setEmitFromCenterStrength(float emitFromCenterStrength) {
        return this.setRandomVelocityStrength(new Vec3((double)emitFromCenterStrength, (double)emitFromCenterStrength, (double)emitFromCenterStrength));
    }

    public ParticleEmitter setSendPacketRange(int sendPacketRange) {
        this.sendPacketRange = sendPacketRange;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParticleEmitter)) {
            return false;
        }
        ParticleEmitter that = (ParticleEmitter)o;
        return Objects.equals(this.emitFromCenterStrength, that.emitFromCenterStrength) && this.sendPacketRange == that.sendPacketRange && Objects.equals(this.particleType, that.particleType) && Objects.equals(this.volume, that.volume) && Objects.equals(this.randomVelocityStrength, that.randomVelocityStrength);
    }

    public int hashCode() {
        return Objects.hash(BuiltInRegistries.f_257034_.m_7981_((Object)this.particleType), this.volume, this.randomVelocityStrength, this.emitFromCenterStrength, this.sendPacketRange);
    }

    public static interface ParticleDataConsumer {
        public void addParticle(SimpleParticleType var1, double var2, double var4, double var6, double var8, double var10, double var12);
    }
}

