/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.treasurebag;

import com.majruszlibrary.client.ClientHelper;
import com.majruszlibrary.events.OnItemTooltip;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.registry.Registries;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.items.TreasureBag;
import com.majruszsdifficulty.treasurebag.TreasureBagHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TreasureBagClient {
    private static final Map<String, List<Component>> COMPONENTS = new HashMap<String, List<Component>>();

    private static void addTooltip(OnItemTooltip data) {
        if (data.isAdvanced()) {
            data.components.add(TextHelper.translatable((String)"majruszsdifficulty.treasure_bag.item_tooltip", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY));
            data.components.add(TextHelper.empty());
        }
        if (ClientHelper.isShiftDown()) {
            List<Component> components = COMPONENTS.get(Registries.ITEMS.getId((Object)data.itemStack.m_41720_()).toString());
            if (components == null) {
                return;
            }
            data.components.addAll(components);
        } else {
            data.components.add(TextHelper.translatable((String)"majruszsdifficulty.treasure_bag.hint_tooltip", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static void onProgressReceived(TreasureBagHelper.Progress data) {
        List components = COMPONENTS.computeIfAbsent(data.id.toString(), id -> new ArrayList());
        components.clear();
        components.add(TreasureBagClient.toProgressComponent(data.bagProgress));
        for (TreasureBagHelper.ItemProgress itemProgress : data.bagProgress.items) {
            components.add(TextHelper.literal((String)" ").m_7220_(TreasureBagClient.toComponent(itemProgress)));
        }
        if (data.unlockedIndices.size() > 0) {
            TreasureBagClient.sendToChat(data);
        }
    }

    private static void sendToChat(TreasureBagHelper.Progress data) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        for (int idx = 0; idx < data.bagProgress.items.size(); ++idx) {
            components.add(TextHelper.literal((String)(data.unlockedIndices.contains(idx) ? "+" : " ")).m_130940_(ChatFormatting.DARK_GREEN).m_7220_(TreasureBagClient.toComponent(data.bagProgress.items.get(idx))));
        }
        Item item = (Item)Registries.ITEMS.get(data.id);
        MutableComponent message = TextHelper.translatable((String)"majruszsdifficulty.treasure_bag.new_items", (Object[])new Object[]{ComponentUtils.m_130748_((Component)item.m_41466_()).m_130940_(item.m_41460_((ItemStack)new ItemStack((ItemLike)item)).f_43022_)});
        MutableComponent description = TreasureBagClient.toProgressComponent(data.bagProgress);
        components.forEach(component -> description.m_7220_((Component)TextHelper.literal((String)"\n").m_7220_(component)));
        Side.getLocalPlayer().m_213846_((Component)message.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)description))));
    }

    private static MutableComponent toProgressComponent(TreasureBagHelper.BagProgress bagProgress) {
        long unlockedItems = bagProgress.items.stream().filter(item -> item.isUnlocked).count();
        int totalItems = bagProgress.items.size();
        return TextHelper.translatable((String)"majruszsdifficulty.treasure_bag.list_tooltip", (Object[])new Object[]{unlockedItems, totalItems}).m_130940_(ChatFormatting.GRAY);
    }

    private static Component toComponent(TreasureBagHelper.ItemProgress itemProgress) {
        if (itemProgress.isUnlocked) {
            return ((Item)Registries.ITEMS.get(itemProgress.id)).m_41466_().m_6881_().m_130940_(TreasureBagClient.getUnlockedFormatting(itemProgress.quality));
        }
        return TextHelper.literal((String)"???").m_130940_(TreasureBagClient.getLockedFormatting(itemProgress.quality));
    }

    private static ChatFormatting getUnlockedFormatting(int quality) {
        return switch (quality) {
            case 4 -> ChatFormatting.GOLD;
            case 3 -> ChatFormatting.LIGHT_PURPLE;
            case 2 -> ChatFormatting.BLUE;
            case 1 -> ChatFormatting.GREEN;
            default -> ChatFormatting.GRAY;
        };
    }

    private static ChatFormatting getLockedFormatting(int quality) {
        return switch (quality) {
            case 4 -> ChatFormatting.GOLD;
            case 3 -> ChatFormatting.DARK_PURPLE;
            case 2 -> ChatFormatting.BLUE;
            case 1 -> ChatFormatting.DARK_GREEN;
            default -> ChatFormatting.DARK_GRAY;
        };
    }

    static {
        OnItemTooltip.listen(TreasureBagClient::addTooltip).addCondition(data -> data.itemStack.m_41720_() instanceof TreasureBag);
        MajruszsDifficulty.TREASURE_BAG_PROGRESS_NETWORK.addClientCallback(TreasureBagClient::onProgressReceived);
    }
}

