/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityDied;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.events.base.CustomCondition;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpawnPlayerZombie {
    private static boolean IS_ENABLED = true;
    private static GameStage REQUIRED_GAME_STAGE = GameStageHelper.find("expert");
    private static float CHANCE = 1.0f;
    private static boolean IS_SCALED_BY_CRD = false;
    private static float HEAD_CHANCE = 1.0f;
    private static float HEAD_DROP_CHANCE = 0.1f;

    private static void spawn(OnEntityDied data) {
        EntityType entityType;
        Player player = (Player)data.target;
        LivingEntity livingEntity = data.attacker;
        if (livingEntity instanceof Zombie) {
            Zombie attacker = (Zombie)livingEntity;
            entityType = attacker.m_6095_();
        } else {
            entityType = EntityType.f_20501_;
        }
        EntityType entityType2 = entityType;
        Entity entity = EntityHelper.createSpawner(() -> entityType2, (Level)data.getLevel()).position(AnyPos.from((Vec3)player.m_20182_()).center().vec3()).mobSpawnType(MobSpawnType.EVENT).spawn();
        if (!(entity instanceof Zombie)) {
            return;
        }
        Zombie zombie = (Zombie)entity;
        if (Random.check((float)HEAD_CHANCE)) {
            ItemStack playerSkull = new ItemStack((ItemLike)Items.f_42680_);
            playerSkull.m_41784_().m_128359_("SkullOwner", player.m_6302_());
            zombie.m_8061_(EquipmentSlot.HEAD, playerSkull);
            zombie.m_21409_(EquipmentSlot.HEAD, HEAD_DROP_CHANCE);
        }
        zombie.m_6593_(player.m_7755_());
        zombie.m_21553_(false);
        zombie.m_21530_();
    }

    private static void giveAdvancement(OnEntityDied data) {
        MajruszsDifficulty.HELPER.triggerAchievement((ServerPlayer)data.attacker, "kill_yourself");
    }

    static {
        OnEntityDied.listen(SpawnPlayerZombie::spawn).addCondition(Condition.isLogicalServer()).addCondition(Condition.chanceCRD(() -> Float.valueOf(CHANCE), () -> IS_SCALED_BY_CRD)).addCondition(data -> IS_ENABLED).addCondition(CustomCondition.check(REQUIRED_GAME_STAGE)).addCondition(data -> data.target instanceof Player).addCondition(data -> data.target.m_21023_((MobEffect)MajruszsDifficulty.BLEEDING_EFFECT.get()) || data.attacker instanceof Zombie);
        OnEntityDied.listen(SpawnPlayerZombie::giveAdvancement).addCondition(data -> data.target instanceof Zombie).addCondition(data -> data.attacker instanceof ServerPlayer).addCondition(data -> data.target.m_7755_().equals(data.attacker.m_7755_()));
        Serializables.getStatic(Config.Features.class).define("spawn_player_zombie", SpawnPlayerZombie.class);
        Serializables.getStatic(SpawnPlayerZombie.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
            IS_ENABLED = v;
        }).define("required_game_stage", Reader.string(), () -> REQUIRED_GAME_STAGE.getId(), v -> {
            REQUIRED_GAME_STAGE = GameStageHelper.find(v);
        }).define("chance", Reader.number(), () -> Float.valueOf(CHANCE), v -> {
            CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("is_scaled_by_crd", Reader.bool(), () -> IS_SCALED_BY_CRD, v -> {
            IS_SCALED_BY_CRD = v;
        }).define("head_chance", Reader.number(), () -> Float.valueOf(HEAD_CHANCE), v -> {
            HEAD_CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("head_drop_chance", Reader.number(), () -> Float.valueOf(HEAD_DROP_CHANCE), v -> {
            HEAD_DROP_CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        });
    }
}

