/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.bundle;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.AssetScreenAddon;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.IComponentHandler;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.util.TitaniumFluidUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TankInteractionBundle<T extends BasicTile>
implements IComponentBundle,
INBTSerializable<CompoundTag> {
    private final Supplier<LazyOptional<IFluidHandler>> fluidHandler;
    private int posX;
    private int posY;
    private InventoryComponent<T> input;
    private InventoryComponent<T> output;
    private ProgressBarComponent<T> bar;

    public TankInteractionBundle(Supplier<LazyOptional<IFluidHandler>> fluidHandler, int posX, int posY, T componentHarness, int maxProgress) {
        this.fluidHandler = fluidHandler;
        this.posX = posX;
        this.posY = posY;
        this.input = new InventoryComponent("tank_input", posX + 5, posY + 7, 1).setSlotToItemStackRender(0, new ItemStack((ItemLike)Items.f_42446_)).setOutputFilter((stack, integer) -> false).setSlotToColorRender(0, DyeColor.BLUE).setInputFilter((stack, integer) -> stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()).setComponentHarness(componentHarness);
        this.output = new InventoryComponent("tank_output", posX + 5, posY + 60, 1).setSlotToItemStackRender(0, new ItemStack((ItemLike)Items.f_42446_)).setInputFilter((stack, integer) -> false).setSlotToColorRender(0, DyeColor.ORANGE).setComponentHarness(componentHarness);
        this.bar = new ProgressBarComponent(posX + 5, posY + 30, maxProgress).setBarDirection(ProgressBarComponent.BarDirection.ARROW_DOWN).setCanReset(t -> true).setCanIncrease(t -> {
            ItemStack stack = this.getOutputStack(false);
            return !this.input.getStackInSlot(0).m_41619_() && this.input.getStackInSlot(0).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() && !stack.m_41619_() && !ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.input.getStackInSlot(0)) && (this.output.getStackInSlot(0).m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.output.getStackInSlot(0)));
        }).setOnFinishWork(() -> {
            ItemStack result = this.getOutputStack(false);
            if (ItemHandlerHelper.insertItem(this.output, (ItemStack)result, (boolean)true).m_41619_()) {
                result = this.getOutputStack(true);
                ItemHandlerHelper.insertItem(this.output, (ItemStack)result, (boolean)false);
                this.input.getStackInSlot(0).m_41774_(1);
                componentHarness.m_6596_();
            }
        }).setComponentHarness((BasicTile)componentHarness);
    }

    @Override
    public void accept(IComponentHandler ... handler) {
        for (IComponentHandler iComponentHandler : handler) {
            iComponentHandler.add(this.input, this.output, this.bar);
        }
    }

    public ItemStack getOutputStack(boolean execute) {
        return this.fluidHandler.get().map(iFluidHandler -> {
            ItemStack stack = this.input.getStackInSlot(0).m_41777_();
            stack.m_41764_(1);
            FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)iFluidHandler, (int)Integer.MAX_VALUE, null, (boolean)execute);
            if (result.isSuccess()) {
                return result.getResult();
            }
            result = TitaniumFluidUtil.tryEmptyContainer(stack, iFluidHandler, Integer.MAX_VALUE, execute);
            if (result.isSuccess()) {
                return result.getResult();
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return Collections.singletonList(() -> new AssetScreenAddon(AssetTypes.AUGMENT_BACKGROUND, this.posX, this.posY, true));
    }

    @Override
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return Collections.emptyList();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128365_("Input", (Tag)this.input.serializeNBT());
        compoundNBT.m_128365_("Output", (Tag)this.output.serializeNBT());
        compoundNBT.m_128365_("Bar", (Tag)this.bar.serializeNBT());
        return compoundNBT;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.input.deserializeNBT(nbt.m_128469_("Input"));
        this.output.deserializeNBT(nbt.m_128469_("Output"));
        this.bar.deserializeNBT(nbt.m_128469_("Bar"));
    }
}

