/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.utils;

import com.leclowndu93150.wakes.utils.Edge2D;
import com.leclowndu93150.wakes.utils.EdgeDistancePack;
import com.leclowndu93150.wakes.utils.Triangle2D;
import com.leclowndu93150.wakes.utils.Vector2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class TriangleSoup {
    private List<Triangle2D> triangleSoup = new ArrayList<Triangle2D>();

    public void add(Triangle2D triangle) {
        this.triangleSoup.add(triangle);
    }

    public void remove(Triangle2D triangle) {
        this.triangleSoup.remove(triangle);
    }

    public List<Triangle2D> getTriangles() {
        return this.triangleSoup;
    }

    public Triangle2D findContainingTriangle(Vector2D point) {
        for (Triangle2D triangle : this.triangleSoup) {
            if (!triangle.contains(point)) continue;
            return triangle;
        }
        return null;
    }

    public Triangle2D findNeighbour(Triangle2D triangle, Edge2D edge) {
        for (Triangle2D triangleFromSoup : this.triangleSoup) {
            if (!triangleFromSoup.isNeighbour(edge) || triangleFromSoup == triangle) continue;
            return triangleFromSoup;
        }
        return null;
    }

    public Triangle2D findOneTriangleSharing(Edge2D edge) {
        for (Triangle2D triangle : this.triangleSoup) {
            if (!triangle.isNeighbour(edge)) continue;
            return triangle;
        }
        return null;
    }

    public Edge2D findNearestEdge(Vector2D point) {
        ArrayList<EdgeDistancePack> edgeList = new ArrayList<EdgeDistancePack>();
        for (Triangle2D triangle : this.triangleSoup) {
            edgeList.add(triangle.findNearestEdge(point));
        }
        Object[] edgeDistancePacks = new EdgeDistancePack[edgeList.size()];
        edgeList.toArray(edgeDistancePacks);
        Arrays.sort(edgeDistancePacks);
        return ((EdgeDistancePack)edgeDistancePacks[0]).edge;
    }

    public void removeTrianglesUsing(Vector2D vertex) {
        ArrayList<Triangle2D> trianglesToBeRemoved = new ArrayList<Triangle2D>();
        for (Triangle2D triangle : this.triangleSoup) {
            if (!triangle.hasVertex(vertex)) continue;
            trianglesToBeRemoved.add(triangle);
        }
        this.triangleSoup.removeAll(trianglesToBeRemoved);
    }
}

